/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.BlockCompressorStream;
import org.apache.hadoop.io.compress.BlockDecompressorStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.lz4.Lz4Compressor;
import org.apache.hadoop.io.compress.snappy.SnappyCompressor;
import org.apache.hadoop.io.compress.zlib.BuiltInZlibDeflater;
import org.apache.hadoop.io.compress.zlib.ZlibCompressor;
import org.apache.hadoop.io.compress.zlib.ZlibFactory;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.log4j.Logger;
import org.junit.Assert;

public class CompressDecompressTester<T extends Compressor, E extends Decompressor> {
    private static final Logger logger = Logger.getLogger(CompressDecompressTester.class);
    private final byte[] originalRawData;
    private ImmutableList<TesterPair<T, E>> pairs = ImmutableList.of();
    private ImmutableList.Builder<TesterPair<T, E>> builder = ImmutableList.builder();
    private ImmutableSet<CompressionTestStrategy> stateges = ImmutableSet.of();
    private PreAssertionTester<T, E> assertionDelegate;

    public CompressDecompressTester(byte[] originalRawData) {
        this.originalRawData = Arrays.copyOf(originalRawData, originalRawData.length);
        this.assertionDelegate = new PreAssertionTester<T, E>(){

            @Override
            public ImmutableList<TesterPair<T, E>> filterOnAssumeWhat(ImmutableList<TesterPair<T, E>> pairs) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (TesterPair pair : pairs) {
                    if (!CompressDecompressTester.isAvailable(pair)) continue;
                    builder.add((Object)pair);
                }
                return builder.build();
            }
        };
    }

    private static boolean isNativeSnappyLoadable() {
        boolean snappyAvailable = false;
        boolean loaded = false;
        try {
            System.loadLibrary("snappy");
            logger.warn((Object)"Snappy native library is available");
            snappyAvailable = true;
            boolean hadoopNativeAvailable = NativeCodeLoader.isNativeCodeLoaded();
            boolean bl = loaded = snappyAvailable && hadoopNativeAvailable;
            if (loaded) {
                logger.info((Object)"Snappy native library loaded");
            } else {
                logger.warn((Object)"Snappy native library not loaded");
            }
        }
        catch (Throwable t) {
            logger.warn((Object)"Failed to load snappy: ", t);
            return false;
        }
        return loaded;
    }

    public static <T extends Compressor, E extends Decompressor> CompressDecompressTester<T, E> of(byte[] rawData) {
        return new CompressDecompressTester<T, E>(rawData);
    }

    public CompressDecompressTester<T, E> withCompressDecompressPair(T compressor, E decompressor) {
        this.addPair(compressor, decompressor, Joiner.on((String)"_").join((Object)compressor.getClass().getCanonicalName(), (Object)decompressor.getClass().getCanonicalName(), new Object[0]));
        return this;
    }

    public CompressDecompressTester<T, E> withTestCases(ImmutableSet<CompressionTestStrategy> stateges) {
        this.stateges = ImmutableSet.copyOf(stateges);
        return this;
    }

    private void addPair(T compressor, E decompressor, String name) {
        this.builder.add(new TesterPair<T, E>(name, compressor, decompressor));
    }

    public void test() throws InstantiationException, IllegalAccessException {
        this.pairs = this.builder.build();
        this.pairs = this.assertionDelegate.filterOnAssumeWhat(this.pairs);
        for (TesterPair pair : this.pairs) {
            for (CompressionTestStrategy strategy : this.stateges) {
                strategy.getTesterStrategy().assertCompression(pair.getName(), (Compressor)pair.getCompressor(), (Decompressor)pair.getDecompressor(), Arrays.copyOf(this.originalRawData, this.originalRawData.length));
            }
        }
        this.endAll(this.pairs);
    }

    private void endAll(ImmutableList<TesterPair<T, E>> pairs) {
        for (TesterPair pair : pairs) {
            pair.end();
        }
    }

    private static <T extends Compressor, E extends Decompressor> boolean isAvailable(TesterPair<T, E> pair) {
        Object compressor = pair.compressor;
        if (compressor.getClass().isAssignableFrom(Lz4Compressor.class) && NativeCodeLoader.isNativeCodeLoaded()) {
            return true;
        }
        if (compressor.getClass().isAssignableFrom(BuiltInZlibDeflater.class) && NativeCodeLoader.isNativeCodeLoaded()) {
            return true;
        }
        if (compressor.getClass().isAssignableFrom(ZlibCompressor.class)) {
            return ZlibFactory.isNativeZlibLoaded((Configuration)new Configuration());
        }
        return compressor.getClass().isAssignableFrom(SnappyCompressor.class) && CompressDecompressTester.isNativeSnappyLoadable();
    }

    static abstract class TesterCompressionStrategy {
        protected final Logger logger = Logger.getLogger(this.getClass());

        TesterCompressionStrategy() {
        }

        abstract void assertCompression(String var1, Compressor var2, Decompressor var3, byte[] var4);
    }

    static final class TesterPair<T extends Compressor, E extends Decompressor> {
        private final T compressor;
        private final E decompressor;
        private final String name;

        TesterPair(String name, T compressor, E decompressor) {
            this.compressor = compressor;
            this.decompressor = decompressor;
            this.name = name;
        }

        public void end() {
            Configuration cfg = new Configuration();
            this.compressor.reinit(cfg);
            this.compressor.end();
            this.decompressor.end();
        }

        public T getCompressor() {
            return this.compressor;
        }

        public E getDecompressor() {
            return this.decompressor;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum CompressionTestStrategy {
        COMPRESS_DECOMPRESS_ERRORS(new TesterCompressionStrategy(){
            private final Joiner joiner = Joiner.on((String)"- ");

            @Override
            public void assertCompression(String name, Compressor compressor, Decompressor decompressor, byte[] rawData) {
                Assert.assertTrue((boolean)this.checkSetInputNullPointerException(compressor));
                Assert.assertTrue((boolean)this.checkSetInputNullPointerException(decompressor));
                Assert.assertTrue((boolean)this.checkCompressArrayIndexOutOfBoundsException(compressor, rawData));
                Assert.assertTrue((boolean)this.checkCompressArrayIndexOutOfBoundsException(decompressor, rawData));
                Assert.assertTrue((boolean)this.checkCompressNullPointerException(compressor, rawData));
                Assert.assertTrue((boolean)this.checkCompressNullPointerException(decompressor, rawData));
                Assert.assertTrue((boolean)this.checkSetInputArrayIndexOutOfBoundsException(compressor));
                Assert.assertTrue((boolean)this.checkSetInputArrayIndexOutOfBoundsException(decompressor));
            }

            private boolean checkSetInputNullPointerException(Compressor compressor) {
                try {
                    compressor.setInput(null, 0, 1);
                }
                catch (NullPointerException npe) {
                    return true;
                }
                catch (Exception ex) {
                    this.logger.error((Object)this.joiner.join((Object)compressor.getClass().getCanonicalName(), (Object)"checkSetInputNullPointerException error !!!", new Object[0]));
                }
                return false;
            }

            private boolean checkCompressNullPointerException(Compressor compressor, byte[] rawData) {
                try {
                    compressor.setInput(rawData, 0, rawData.length);
                    compressor.compress(null, 0, 1);
                }
                catch (NullPointerException npe) {
                    return true;
                }
                catch (Exception ex) {
                    this.logger.error((Object)this.joiner.join((Object)compressor.getClass().getCanonicalName(), (Object)"checkCompressNullPointerException error !!!", new Object[0]));
                }
                return false;
            }

            private boolean checkCompressNullPointerException(Decompressor decompressor, byte[] rawData) {
                try {
                    decompressor.setInput(rawData, 0, rawData.length);
                    decompressor.decompress(null, 0, 1);
                }
                catch (NullPointerException npe) {
                    return true;
                }
                catch (Exception ex) {
                    this.logger.error((Object)this.joiner.join((Object)decompressor.getClass().getCanonicalName(), (Object)"checkCompressNullPointerException error !!!", new Object[0]));
                }
                return false;
            }

            private boolean checkSetInputNullPointerException(Decompressor decompressor) {
                try {
                    decompressor.setInput(null, 0, 1);
                }
                catch (NullPointerException npe) {
                    return true;
                }
                catch (Exception ex) {
                    this.logger.error((Object)this.joiner.join((Object)decompressor.getClass().getCanonicalName(), (Object)"checkSetInputNullPointerException error !!!", new Object[0]));
                }
                return false;
            }

            private boolean checkSetInputArrayIndexOutOfBoundsException(Compressor compressor) {
                try {
                    compressor.setInput(new byte[]{0}, 0, -1);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return true;
                }
                catch (Exception e) {
                    this.logger.error((Object)this.joiner.join((Object)compressor.getClass().getCanonicalName(), (Object)"checkSetInputArrayIndexOutOfBoundsException error !!!", new Object[0]));
                }
                return false;
            }

            private boolean checkCompressArrayIndexOutOfBoundsException(Compressor compressor, byte[] rawData) {
                try {
                    compressor.setInput(rawData, 0, rawData.length);
                    compressor.compress(new byte[rawData.length], 0, -1);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return true;
                }
                catch (Exception e) {
                    this.logger.error((Object)this.joiner.join((Object)compressor.getClass().getCanonicalName(), (Object)"checkCompressArrayIndexOutOfBoundsException error !!!", new Object[0]));
                }
                return false;
            }

            private boolean checkCompressArrayIndexOutOfBoundsException(Decompressor decompressor, byte[] rawData) {
                try {
                    decompressor.setInput(rawData, 0, rawData.length);
                    decompressor.decompress(new byte[rawData.length], 0, -1);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return true;
                }
                catch (Exception e) {
                    this.logger.error((Object)this.joiner.join((Object)decompressor.getClass().getCanonicalName(), (Object)"checkCompressArrayIndexOutOfBoundsException error !!!", new Object[0]));
                }
                return false;
            }

            private boolean checkSetInputArrayIndexOutOfBoundsException(Decompressor decompressor) {
                try {
                    decompressor.setInput(new byte[]{0}, 0, -1);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return true;
                }
                catch (Exception e) {
                    this.logger.error((Object)this.joiner.join((Object)decompressor.getClass().getCanonicalName(), (Object)"checkNullPointerException error !!!", new Object[0]));
                }
                return false;
            }
        }),
        COMPRESS_DECOMPRESS_SINGLE_BLOCK(new TesterCompressionStrategy(){
            final Joiner joiner = Joiner.on((String)"- ");

            @Override
            public void assertCompression(String name, Compressor compressor, Decompressor decompressor, byte[] rawData) {
                int cSize = 0;
                int decompressedSize = 0;
                byte[] compressedResult = new byte[rawData.length];
                byte[] decompressedBytes = new byte[rawData.length];
                try {
                    Assert.assertTrue((String)this.joiner.join((Object)name, (Object)"compressor.needsInput before error !!!", new Object[0]), (boolean)compressor.needsInput());
                    Assert.assertTrue((String)this.joiner.join((Object)name, (Object)"compressor.getBytesWritten before error !!!", new Object[0]), (compressor.getBytesWritten() == 0L ? 1 : 0) != 0);
                    compressor.setInput(rawData, 0, rawData.length);
                    compressor.finish();
                    while (!compressor.finished()) {
                        cSize += compressor.compress(compressedResult, 0, compressedResult.length);
                    }
                    compressor.reset();
                    Assert.assertTrue((String)this.joiner.join((Object)name, (Object)"decompressor.needsInput() before error !!!", new Object[0]), (boolean)decompressor.needsInput());
                    decompressor.setInput(compressedResult, 0, cSize);
                    Assert.assertFalse((String)this.joiner.join((Object)name, (Object)"decompressor.needsInput() after error !!!", new Object[0]), (boolean)decompressor.needsInput());
                    while (!decompressor.finished()) {
                        decompressedSize = decompressor.decompress(decompressedBytes, 0, decompressedBytes.length);
                    }
                    decompressor.reset();
                    Assert.assertTrue((String)this.joiner.join((Object)name, (Object)" byte size not equals error !!!", new Object[0]), (decompressedSize == rawData.length ? 1 : 0) != 0);
                    Assert.assertArrayEquals((String)this.joiner.join((Object)name, (Object)" byte arrays not equals error !!!", new Object[0]), (byte[])rawData, (byte[])decompressedBytes);
                }
                catch (Exception ex) {
                    Assert.fail((String)this.joiner.join((Object)name, (Object)ex.getMessage(), new Object[0]));
                }
            }
        }),
        COMPRESS_DECOMPRESS_WITH_EMPTY_STREAM(new TesterCompressionStrategy(){
            final Joiner joiner = Joiner.on((String)"- ");
            final ImmutableMap<Class<? extends Compressor>, Integer> emptySize = ImmutableMap.of(Lz4Compressor.class, (Object)4, ZlibCompressor.class, (Object)16, SnappyCompressor.class, (Object)4, BuiltInZlibDeflater.class, (Object)16);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void assertCompression(String name, Compressor compressor, Decompressor decompressor, byte[] originalRawData) {
                byte[] buf = null;
                ByteArrayInputStream bytesIn = null;
                BlockDecompressorStream blockDecompressorStream = null;
                ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                try {
                    compressor.reset();
                    BlockCompressorStream blockCompressorStream = new BlockCompressorStream((OutputStream)bytesOut, compressor, 1024, 0);
                    blockCompressorStream.close();
                    buf = bytesOut.toByteArray();
                    int emSize = (Integer)this.emptySize.get(compressor.getClass());
                    Assert.assertEquals((String)this.joiner.join((Object)name, (Object)("empty stream compressed output size != " + emSize), new Object[0]), (long)emSize, (long)buf.length);
                    bytesIn = new ByteArrayInputStream(buf);
                    blockDecompressorStream = new BlockDecompressorStream((InputStream)bytesIn, decompressor, 1024);
                    Assert.assertEquals((String)this.joiner.join((Object)name, (Object)" return value is not -1", new Object[0]), (long)-1L, (long)blockDecompressorStream.read());
                }
                catch (IOException e) {
                    Assert.fail((String)this.joiner.join((Object)name, (Object)e.getMessage(), new Object[0]));
                }
                finally {
                    if (blockDecompressorStream != null) {
                        try {
                            bytesOut.close();
                            blockDecompressorStream.close();
                            bytesIn.close();
                            blockDecompressorStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }),
        COMPRESS_DECOMPRESS_BLOCK(new TesterCompressionStrategy(){
            private final Joiner joiner = Joiner.on((String)"- ");
            private static final int BLOCK_SIZE = 512;
            private final byte[] operationBlock = new byte[512];
            private static final int overheadSpace = 17;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void assertCompression(String name, Compressor compressor, Decompressor decompressor, byte[] originalRawData) {
                int off = 0;
                int len = originalRawData.length;
                int maxSize = 495;
                int compresSize = 0;
                ArrayList<Integer> blockLabels = new ArrayList<Integer>();
                ByteArrayOutputStream compressedOut = new ByteArrayOutputStream();
                ByteArrayOutputStream decompressOut = new ByteArrayOutputStream();
                try {
                    if (originalRawData.length > maxSize) {
                        int bufLen;
                        do {
                            bufLen = Math.min(len, maxSize);
                            compressor.setInput(originalRawData, off, bufLen);
                            compressor.finish();
                            while (!compressor.finished()) {
                                compresSize = compressor.compress(this.operationBlock, 0, this.operationBlock.length);
                                compressedOut.write(this.operationBlock, 0, compresSize);
                                blockLabels.add(compresSize);
                            }
                            compressor.reset();
                            off += bufLen;
                        } while ((len -= bufLen) > 0);
                    }
                    off = 0;
                    byte[] compressedBytes = compressedOut.toByteArray();
                    for (Integer step : blockLabels) {
                        decompressor.setInput(compressedBytes, off, step.intValue());
                        while (!decompressor.finished()) {
                            int dSize = decompressor.decompress(this.operationBlock, 0, this.operationBlock.length);
                            decompressOut.write(this.operationBlock, 0, dSize);
                        }
                        decompressor.reset();
                        off += step.intValue();
                    }
                    Assert.assertArrayEquals((String)this.joiner.join((Object)name, (Object)"byte arrays not equals error !!!", new Object[0]), (byte[])originalRawData, (byte[])decompressOut.toByteArray());
                }
                catch (Exception ex) {
                    Assert.fail((String)this.joiner.join((Object)name, (Object)ex.getMessage(), new Object[0]));
                }
                finally {
                    try {
                        compressedOut.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        decompressOut.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        });

        private final TesterCompressionStrategy testerStrategy;

        private CompressionTestStrategy(TesterCompressionStrategy testStrategy) {
            this.testerStrategy = testStrategy;
        }

        public TesterCompressionStrategy getTesterStrategy() {
            return this.testerStrategy;
        }
    }

    static interface PreAssertionTester<T extends Compressor, E extends Decompressor> {
        public ImmutableList<TesterPair<T, E>> filterOnAssumeWhat(ImmutableList<TesterPair<T, E>> var1);
    }
}

