/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.xbill.DNS;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import lombok.Generated;
import org.apache.hadoop.shaded.org.xbill.DNS.PacketLogger;
import org.apache.hadoop.shaded.org.xbill.DNS.utils.hexdump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NioClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NioClient.class);
    private static PacketLogger packetLogger = null;
    private static final Runnable[] TIMEOUT_TASKS = new Runnable[2];
    private static final Runnable[] REGISTRATIONS_TASKS = new Runnable[2];
    private static final Runnable[] CLOSE_TASKS = new Runnable[2];
    private static Thread selectorThread;
    private static Thread closeThread;
    private static volatile Selector selector;
    private static volatile boolean run;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Selector selector() throws IOException {
        if (selector != null) return selector;
        Class<NioClient> clazz = NioClient.class;
        synchronized (NioClient.class) {
            if (selector != null) return selector;
            selector = Selector.open();
            log.debug("Starting dnsjava NIO selector thread");
            run = true;
            selectorThread = new Thread(NioClient::runSelector);
            selectorThread.setDaemon(true);
            selectorThread.setName("dnsjava NIO selector");
            selectorThread.start();
            closeThread = new Thread(() -> NioClient.close(true));
            closeThread.setName("dnsjava NIO shutdown hook");
            if (!Boolean.parseBoolean(System.getProperty("dnsjava.nio.register_shutdown_hook", "true"))) return selector;
            Runtime.getRuntime().addShutdownHook(closeThread);
            // ** MonitorExit[var0] (shouldn't be in output)
            return selector;
        }
    }

    public static void close() {
        NioClient.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close(boolean fromHook) {
        run = false;
        if (!fromHook) {
            try {
                Runtime.getRuntime().removeShutdownHook(closeThread);
            }
            catch (Exception ex) {
                log.warn("Failed to remove shutdown hook, ignoring and continuing close");
            }
        }
        try {
            NioClient.runTasks(CLOSE_TASKS);
        }
        catch (Exception e) {
            log.warn("Failed to execute shutdown task, ignoring and continuing close", (Throwable)e);
        }
        Selector localSelector = selector;
        Thread localSelectorThread = selectorThread;
        Class<NioClient> clazz = NioClient.class;
        synchronized (NioClient.class) {
            selector = null;
            selectorThread = null;
            closeThread = null;
            // ** MonitorExit[var3_5] (shouldn't be in output)
            if (localSelector != null) {
                localSelector.wakeup();
                try {
                    localSelector.close();
                }
                catch (IOException e) {
                    log.warn("Failed to properly close selector, ignoring and continuing close", (Throwable)e);
                }
            }
            if (localSelectorThread != null) {
                try {
                    localSelectorThread.join();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            return;
        }
    }

    static void runSelector() {
        int timeout = Integer.getInteger("dnsjava.nio.selector_timeout", 1000);
        if (timeout <= 0 || timeout > 1000) {
            throw new IllegalArgumentException("Invalid selector_timeout, must be between 1 and 1000");
        }
        while (run) {
            try {
                if (selector.select(timeout) == 0) {
                    NioClient.runTasks(TIMEOUT_TASKS);
                }
                if (!run) continue;
                NioClient.runTasks(REGISTRATIONS_TASKS);
                NioClient.processReadyKeys();
            }
            catch (IOException e) {
                log.error("A selection operation failed", (Throwable)e);
            }
            catch (ClosedSelectorException closedSelectorException) {}
        }
        log.debug("dnsjava NIO selector thread stopped");
    }

    static synchronized void setTimeoutTask(Runnable r, boolean isTcpClient) {
        NioClient.addTask(TIMEOUT_TASKS, r, isTcpClient);
    }

    static synchronized void setRegistrationsTask(Runnable r, boolean isTcpClient) {
        NioClient.addTask(REGISTRATIONS_TASKS, r, isTcpClient);
    }

    static synchronized void setCloseTask(Runnable r, boolean isTcpClient) {
        NioClient.addTask(CLOSE_TASKS, r, isTcpClient);
    }

    private static void addTask(Runnable[] closeTasks, Runnable r, boolean isTcpClient) {
        if (isTcpClient) {
            closeTasks[0] = r;
        } else {
            closeTasks[1] = r;
        }
    }

    private static synchronized void runTasks(Runnable[] runnables) {
        Runnable r1;
        Runnable r0 = runnables[0];
        if (r0 != null) {
            r0.run();
        }
        if ((r1 = runnables[1]) != null) {
            r1.run();
        }
    }

    private static void processReadyKeys() {
        Iterator<SelectionKey> it = selector.selectedKeys().iterator();
        while (it.hasNext()) {
            SelectionKey key = it.next();
            it.remove();
            KeyProcessor t2 = (KeyProcessor)key.attachment();
            t2.processReadyKey(key);
        }
    }

    static void verboseLog(String prefix, SocketAddress local, SocketAddress remote, ByteBuffer data) {
        if (log.isTraceEnabled() || packetLogger != null) {
            byte[] dst = new byte[data.remaining()];
            int pos = data.position();
            data.get(dst, 0, data.remaining());
            data.position(pos);
            NioClient.verboseLog(prefix, local, remote, dst);
        }
    }

    static void verboseLog(String prefix, SocketAddress local, SocketAddress remote, byte[] data) {
        if (log.isTraceEnabled()) {
            log.trace(hexdump.dump(prefix, data));
        }
        if (packetLogger != null) {
            packetLogger.log(prefix, local, remote, data);
        }
    }

    static void setPacketLogger(PacketLogger logger) {
        packetLogger = logger;
    }

    static interface KeyProcessor {
        public void processReadyKey(SelectionKey var1);
    }
}

