/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;

@XmlRootElement(name="scheduler")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SchedulerOverviewInfo {
    private String schedulerType;
    private String schedulingResourceType;
    private ResourceInfo minimumAllocation;
    private ResourceInfo maximumAllocation;
    private int applicationPriority;
    private int schedulerBusy;
    private int rmDispatcherEventQueueSize;
    private int schedulerDispatcherEventQueueSize;

    public SchedulerOverviewInfo() {
    }

    public SchedulerOverviewInfo(ResourceScheduler rs) {
        this.schedulerType = SchedulerOverviewInfo.getSchedulerName(rs);
        this.minimumAllocation = new ResourceInfo(rs.getMinimumResourceCapability());
        this.maximumAllocation = new ResourceInfo(rs.getMaximumResourceCapability());
        this.applicationPriority = rs.getMaxClusterLevelAppPriority().getPriority();
        List resourceTypeInfos = ResourceUtils.getResourcesTypeInfo();
        resourceTypeInfos.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        this.schedulingResourceType = StringUtils.join((Iterable)resourceTypeInfos, (String)",");
        ClusterMetricsInfo clusterMetrics = new ClusterMetricsInfo(rs);
        this.schedulerBusy = clusterMetrics.getRmSchedulerBusyPercent();
        this.rmDispatcherEventQueueSize = clusterMetrics.getRmEventQueueSize();
        this.schedulerDispatcherEventQueueSize = clusterMetrics.getSchedulerEventQueueSize();
    }

    private static String getSchedulerName(ResourceScheduler rs) {
        if (rs instanceof CapacityScheduler) {
            return "Capacity Scheduler";
        }
        if (rs instanceof FairScheduler) {
            return "Fair Scheduler";
        }
        if (rs instanceof FifoScheduler) {
            return "Fifo Scheduler";
        }
        return rs.getClass().getSimpleName();
    }

    public String getSchedulerType() {
        return this.schedulerType;
    }

    public String getSchedulingResourceType() {
        return this.schedulingResourceType;
    }

    public ResourceInfo getMinimumAllocation() {
        return this.minimumAllocation;
    }

    public ResourceInfo getMaximumAllocation() {
        return this.maximumAllocation;
    }

    public int getApplicationPriority() {
        return this.applicationPriority;
    }

    public int getSchedulerBusy() {
        return this.schedulerBusy;
    }

    public int getRmDispatcherEventQueueSize() {
        return this.rmDispatcherEventQueueSize;
    }

    public int getSchedulerDispatcherEventQueueSize() {
        return this.schedulerDispatcherEventQueueSize;
    }
}

