/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.FpgaDevice;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.IntelFpgaOpenclPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AoclDiagnosticOutputParser {
    private static final Logger LOG = LoggerFactory.getLogger(AoclDiagnosticOutputParser.class);

    private AoclDiagnosticOutputParser() {
    }

    public static List<FpgaDevice> parseDiagnosticOutput(String output, IntelFpgaOpenclPlugin.InnerShellExecutor shellExecutor, String fpgaType) {
        if (output.contains("DIAGNOSTIC_PASSED")) {
            ArrayList<FpgaDevice> devices = new ArrayList<FpgaDevice>();
            Matcher headerStartMatcher = Pattern.compile("acl[0-31]").matcher(output);
            Matcher headerEndMatcher = Pattern.compile("(?i)DIAGNOSTIC_PASSED").matcher(output);
            while (headerStartMatcher.find()) {
                int sectionStartIndex = headerStartMatcher.end();
                String section = null;
                String aliasName = headerStartMatcher.group();
                if (headerEndMatcher.find(sectionStartIndex)) {
                    int sectionEndIndex = headerEndMatcher.start();
                    section = output.substring(sectionStartIndex, sectionEndIndex);
                }
                if (section == null) {
                    LOG.warn("Unsupported diagnose output");
                    LOG.warn("aocl output is: " + output);
                    return Collections.emptyList();
                }
                String[] fieldRegexes = new String[]{"\\(.*\\)\n", "(?i)bus:slot.func\\s=\\s.*,", "(?i)FPGA temperature\\s=\\s.*", "(?i)Total\\sCard\\sPower\\sUsage\\s=\\s.*"};
                String[] fields = new String[4];
                for (int i = 0; i < fieldRegexes.length; ++i) {
                    Matcher fieldMatcher = Pattern.compile(fieldRegexes[i]).matcher(section);
                    if (!fieldMatcher.find()) {
                        LOG.warn("Couldn't find " + fieldRegexes[i] + " pattern");
                        fields[i] = "";
                        continue;
                    }
                    String tempFieldValue = fieldMatcher.group().trim();
                    if (i == 0) {
                        fields[i] = tempFieldValue.substring(1, tempFieldValue.length() - 1);
                        continue;
                    }
                    String ss = tempFieldValue.split("=")[1].trim();
                    fields[i] = ss.substring(0, ss.length() - 1);
                }
                String majorMinorNumber = shellExecutor.getMajorAndMinorNumber(fields[0]);
                if (null != majorMinorNumber) {
                    String[] mmn = majorMinorNumber.split(":");
                    devices.add(new FpgaDevice(fpgaType, Integer.parseInt(mmn[0]), Integer.parseInt(mmn[1]), aliasName));
                    continue;
                }
                LOG.warn("Failed to retrieve major/minor number for device");
            }
            return devices;
        }
        LOG.warn("The diagnostic has failed");
        LOG.warn("Output of aocl is: " + output);
        return Collections.emptyList();
    }
}

