/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.impl.internal.executor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.executor.ExecutorUtil;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.executor.OutOfBandScheduledExecutor;

class PartitionedScheduledExecutor
extends AbstractExecutorService
implements ScheduledExecutorService {
    private final OutOfBandScheduledExecutor scheduler;
    private final ExecutorService worker;
    private volatile boolean shutdown;
    private volatile Future<List<Runnable>> termination;

    PartitionedScheduledExecutor(OutOfBandScheduledExecutor scheduler, ExecutorService worker) {
        this.scheduler = scheduler;
        this.worker = worker;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if (this.shutdown) {
            throw new RejectedExecutionException();
        }
        ScheduledFuture<?> scheduled = this.scheduler.schedule(this.worker, command, delay, unit);
        if (this.shutdown && scheduled.cancel(false)) {
            throw new RejectedExecutionException();
        }
        return scheduled;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        if (this.shutdown) {
            throw new RejectedExecutionException();
        }
        ScheduledFuture<V> scheduled = this.scheduler.schedule(this.worker, callable, delay, unit);
        if (this.shutdown && scheduled.cancel(false)) {
            throw new RejectedExecutionException();
        }
        return scheduled;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (this.shutdown) {
            throw new RejectedExecutionException();
        }
        ScheduledFuture<?> scheduled = this.scheduler.scheduleAtFixedRate(this.worker, command, initialDelay, period, unit);
        if (this.shutdown && scheduled.cancel(false)) {
            throw new RejectedExecutionException();
        }
        return scheduled;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (this.shutdown) {
            throw new RejectedExecutionException();
        }
        ScheduledFuture<?> scheduled = this.scheduler.scheduleWithFixedDelay(this.worker, command, initialDelay, delay, unit);
        if (this.shutdown && scheduled.cancel(false)) {
            throw new RejectedExecutionException();
        }
        return scheduled;
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        try {
            Long longestDelay = ExecutorUtil.waitFor(this.scheduler.schedule(null, this::getMaxDelay, 0L, TimeUnit.NANOSECONDS));
            this.termination = this.scheduler.schedule(this.worker, () -> {
                this.worker.shutdown();
                return Collections.emptyList();
            }, longestDelay + 1L, TimeUnit.NANOSECONDS);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private long getMaxDelay() {
        long maxDelay = 0L;
        Iterator it = this.scheduler.getQueue().iterator();
        while (it.hasNext()) {
            OutOfBandScheduledExecutor.OutOfBandRsf oobJob;
            Runnable job = (Runnable)it.next();
            if (!(job instanceof OutOfBandScheduledExecutor.OutOfBandRsf) || (oobJob = (OutOfBandScheduledExecutor.OutOfBandRsf)job).getExecutor() != this.worker) continue;
            if (oobJob.isPeriodic()) {
                oobJob.cancel(false);
                it.remove();
                continue;
            }
            maxDelay = Math.max(maxDelay, oobJob.getDelay(TimeUnit.NANOSECONDS));
        }
        return maxDelay;
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown = true;
        try {
            this.termination = this.scheduler.schedule(null, this::abortTasks, 0L, TimeUnit.NANOSECONDS);
            return ExecutorUtil.waitFor(this.termination);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private List<Runnable> abortTasks() {
        ArrayList<Runnable> abortedTasks = new ArrayList<Runnable>();
        Iterator it = this.scheduler.getQueue().iterator();
        while (it.hasNext()) {
            OutOfBandScheduledExecutor.OutOfBandRsf oobJob;
            Runnable job = (Runnable)it.next();
            if (!(job instanceof OutOfBandScheduledExecutor.OutOfBandRsf) || (oobJob = (OutOfBandScheduledExecutor.OutOfBandRsf)job).getExecutor() != this.worker) continue;
            abortedTasks.add(job);
            it.remove();
        }
        abortedTasks.addAll(this.worker.shutdownNow());
        return abortedTasks;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public boolean isTerminated() {
        if (this.isShutdown()) {
            return this.termination.isDone() && this.worker.isTerminated();
        }
        return false;
    }

    @Override
    public boolean awaitTermination(long time, TimeUnit unit) throws InterruptedException {
        if (this.isShutdown()) {
            if (this.termination.isDone()) {
                return this.worker.awaitTermination(time, unit);
            }
            long end = System.nanoTime() + unit.toNanos(time);
            try {
                this.termination.get(time, unit);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getCause());
            }
            catch (TimeoutException e) {
                return false;
            }
            return this.worker.awaitTermination(end - System.nanoTime(), TimeUnit.NANOSECONDS);
        }
        return false;
    }

    @Override
    public void execute(Runnable runnable) {
        this.schedule(runnable, 0L, TimeUnit.NANOSECONDS);
    }
}

