/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.google.inject.servlet;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.shaded.com.google.inject.Binding;
import org.apache.hadoop.shaded.com.google.inject.Key;
import org.apache.hadoop.shaded.com.google.inject.OutOfScopeException;
import org.apache.hadoop.shaded.com.google.inject.Provider;
import org.apache.hadoop.shaded.com.google.inject.Scope;
import org.apache.hadoop.shaded.com.google.inject.Scopes;
import org.apache.hadoop.shaded.com.google.inject.servlet.ContinuingHttpServletRequest;
import org.apache.hadoop.shaded.com.google.inject.servlet.GuiceFilter;
import org.apache.hadoop.shaded.com.google.inject.servlet.RequestParameters;
import org.apache.hadoop.shaded.com.google.inject.servlet.RequestScoped;
import org.apache.hadoop.shaded.com.google.inject.servlet.RequestScoper;
import org.apache.hadoop.shaded.com.google.inject.servlet.ScopingException;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.shaded.javax.servlet.http.HttpSession;

public final class ServletScopes {
    private static final ThreadLocal<Context> requestScopeContext = new ThreadLocal();
    public static final Scope REQUEST = new RequestScope();
    public static final Scope SESSION = new SessionScope();

    private ServletScopes() {
    }

    @Deprecated
    public static <T> Callable<T> continueRequest(Callable<T> callable, Map<Key<?>, Object> seedMap) {
        return ServletScopes.wrap(callable, ServletScopes.continueRequest(seedMap));
    }

    private static RequestScoper continueRequest(Map<Key<?>, Object> seedMap) {
        Preconditions.checkArgument((null != seedMap ? 1 : 0) != 0, (Object)"Seed map cannot be null, try passing in Collections.emptyMap() instead.");
        final ContinuingHttpServletRequest continuingRequest = new ContinuingHttpServletRequest(GuiceFilter.getRequest(Key.get(HttpServletRequest.class)));
        for (Map.Entry<Key<?>, Object> entry : seedMap.entrySet()) {
            Object value = ServletScopes.validateAndCanonicalizeValue(entry.getKey(), entry.getValue());
            continuingRequest.setAttribute(entry.getKey().toString(), value);
        }
        return new RequestScoper(){

            @Override
            public RequestScoper.CloseableScope open() {
                ServletScopes.checkScopingState(null == GuiceFilter.localContext.get(), "Cannot continue request in the same thread as a HTTP request!");
                return new GuiceFilter.Context((HttpServletRequest)continuingRequest, (HttpServletRequest)continuingRequest, null).open();
            }
        };
    }

    public static <T> Callable<T> transferRequest(Callable<T> callable) {
        return ServletScopes.wrap(callable, ServletScopes.transferRequest());
    }

    public static RequestScoper transferRequest() {
        return GuiceFilter.localContext.get() != null ? ServletScopes.transferHttpRequest() : ServletScopes.transferNonHttpRequest();
    }

    private static RequestScoper transferHttpRequest() {
        GuiceFilter.Context context = GuiceFilter.localContext.get();
        if (context == null) {
            throw new OutOfScopeException("Not in a request scope");
        }
        return context;
    }

    private static RequestScoper transferNonHttpRequest() {
        Context context = requestScopeContext.get();
        if (context == null) {
            throw new OutOfScopeException("Not in a request scope");
        }
        return context;
    }

    public static boolean isRequestScoped(Binding<?> binding) {
        return Scopes.isScoped(binding, REQUEST, RequestScoped.class);
    }

    public static <T> Callable<T> scopeRequest(Callable<T> callable, Map<Key<?>, Object> seedMap) {
        return ServletScopes.wrap(callable, ServletScopes.scopeRequest(seedMap));
    }

    public static RequestScoper scopeRequest(Map<Key<?>, Object> seedMap) {
        Preconditions.checkArgument((null != seedMap ? 1 : 0) != 0, (Object)"Seed map cannot be null, try passing in Collections.emptyMap() instead.");
        final Context context = new Context();
        Map validatedAndCanonicalizedMap = Maps.transformEntries(seedMap, ServletScopes::validateAndCanonicalizeValue);
        context.map.putAll(validatedAndCanonicalizedMap);
        return new RequestScoper(){

            @Override
            public RequestScoper.CloseableScope open() {
                ServletScopes.checkScopingState(null == GuiceFilter.localContext.get(), "An HTTP request is already in progress, cannot scope a new request in this thread.");
                ServletScopes.checkScopingState(null == requestScopeContext.get(), "A request scope is already in progress, cannot scope a new request in this thread.");
                return context.open();
            }
        };
    }

    private static Object validateAndCanonicalizeValue(Key<?> key, Object object) {
        if (object == null || object == NullObject.INSTANCE) {
            return NullObject.INSTANCE;
        }
        Preconditions.checkArgument((boolean)key.getTypeLiteral().getRawType().isInstance(object), (String)"Value[%s] of type[%s] is not compatible with key[%s]", (Object)object, (Object)object.getClass().getName(), key);
        return object;
    }

    private static void checkScopingState(boolean condition, String msg) {
        if (!condition) {
            throw new ScopingException(msg);
        }
    }

    private static <T> Callable<T> wrap(Callable<T> delegate, RequestScoper requestScoper) {
        return () -> {
            try (RequestScoper.CloseableScope scope = requestScoper.open();){
                Object v = delegate.call();
                return v;
            }
        };
    }

    private static class Context
    implements RequestScoper {
        final Map<Key<?>, Object> map = Maps.newHashMap();
        final Lock lock = new ReentrantLock();

        private Context() {
        }

        @Override
        public RequestScoper.CloseableScope open() {
            this.lock.lock();
            final Context previous = (Context)requestScopeContext.get();
            requestScopeContext.set(this);
            return new RequestScoper.CloseableScope(){

                @Override
                public void close() {
                    requestScopeContext.set(previous);
                    lock.unlock();
                }
            };
        }
    }

    private static final class SessionScope
    implements Scope {
        private SessionScope() {
        }

        @Override
        public <T> Provider<T> scope(final Key<T> key, final Provider<T> creator) {
            final String name = key.toString();
            return new Provider<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T get() {
                    HttpSession session;
                    HttpSession httpSession = session = GuiceFilter.getRequest(key).getSession();
                    synchronized (httpSession) {
                        Object obj = session.getAttribute(name);
                        if (NullObject.INSTANCE == obj) {
                            return null;
                        }
                        Object t = obj;
                        if (t == null && !Scopes.isCircularProxy(t = creator.get())) {
                            session.setAttribute(name, t != null ? t : NullObject.INSTANCE);
                        }
                        return t;
                    }
                }

                public String toString() {
                    return String.format("%s[%s]", creator, SESSION);
                }
            };
        }

        @Override
        public String toString() {
            return "ServletScopes.SESSION";
        }
    }

    private static final class RequestScope
    implements Scope {
        private RequestScope() {
        }

        @Override
        public <T> Provider<T> scope(final Key<T> key, final Provider<T> creator) {
            return new Provider<T>(){
                private final ImmutableSet<Key<?>> REQUEST_CONTEXT_KEYS = ImmutableSet.of(Key.get(HttpServletRequest.class), Key.get(HttpServletResponse.class), (Object)new Key<Map<String, String[]>>(RequestParameters.class){});

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T get() {
                    Context context;
                    if (null == GuiceFilter.localContext.get() && null != (context = (Context)requestScopeContext.get())) {
                        Object t = context.map.get(key);
                        if (NullObject.INSTANCE == t) {
                            return null;
                        }
                        if (t == null && !Scopes.isCircularProxy(t = creator.get())) {
                            context.map.put(key, t != null ? t : NullObject.INSTANCE);
                        }
                        return t;
                    }
                    HttpServletRequest request = GuiceFilter.getOriginalRequest(key);
                    if (this.REQUEST_CONTEXT_KEYS.contains((Object)key)) {
                        return creator.get();
                    }
                    String name = key.toString();
                    HttpServletRequest httpServletRequest = request;
                    synchronized (httpServletRequest) {
                        Object obj = request.getAttribute(name);
                        if (NullObject.INSTANCE == obj) {
                            return null;
                        }
                        Object t = obj;
                        if (t == null && !Scopes.isCircularProxy(t = creator.get())) {
                            request.setAttribute(name, t != null ? t : NullObject.INSTANCE);
                        }
                        return t;
                    }
                }

                public String toString() {
                    return String.format("%s[%s]", creator, REQUEST);
                }
            };
        }

        @Override
        public String toString() {
            return "ServletScopes.REQUEST";
        }
    }

    static enum NullObject {
        INSTANCE;

    }
}

