/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.google.inject.servlet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.shaded.com.google.inject.Binder;
import org.apache.hadoop.shaded.com.google.inject.Key;
import org.apache.hadoop.shaded.com.google.inject.internal.UniqueAnnotations;
import org.apache.hadoop.shaded.com.google.inject.servlet.FilterDefinition;
import org.apache.hadoop.shaded.com.google.inject.servlet.ServletModule;
import org.apache.hadoop.shaded.com.google.inject.servlet.UriPatternMatcher;
import org.apache.hadoop.shaded.com.google.inject.servlet.UriPatternType;
import org.apache.hadoop.shaded.javax.servlet.Filter;

class FiltersModuleBuilder {
    private final Binder binder;

    public FiltersModuleBuilder(Binder binder) {
        this.binder = binder;
    }

    public ServletModule.FilterKeyBindingBuilder filter(List<String> patterns) {
        return new FilterKeyBindingBuilderImpl(this.parsePatterns(UriPatternType.SERVLET, patterns));
    }

    public ServletModule.FilterKeyBindingBuilder filterRegex(List<String> regexes) {
        return new FilterKeyBindingBuilderImpl(this.parsePatterns(UriPatternType.REGEX, regexes));
    }

    private List<UriPatternMatcher> parsePatterns(UriPatternType type, List<String> patterns) {
        ArrayList<UriPatternMatcher> patternMatchers = new ArrayList<UriPatternMatcher>();
        for (String pattern : patterns) {
            UriPatternMatcher matcher = null;
            try {
                matcher = UriPatternType.get(type, pattern);
            }
            catch (IllegalArgumentException iae) {
                this.binder.skipSources(ServletModule.class, FiltersModuleBuilder.class).addError("%s", iae.getMessage());
            }
            if (matcher == null) continue;
            patternMatchers.add(matcher);
        }
        return patternMatchers;
    }

    class FilterKeyBindingBuilderImpl
    implements ServletModule.FilterKeyBindingBuilder {
        private final List<UriPatternMatcher> uriPatterns;

        private FilterKeyBindingBuilderImpl(List<UriPatternMatcher> uriPatterns) {
            this.uriPatterns = uriPatterns;
        }

        @Override
        public void through(Class<? extends Filter> filterKey) {
            this.through(Key.get(filterKey));
        }

        @Override
        public void through(Key<? extends Filter> filterKey) {
            this.through(filterKey, new HashMap<String, String>());
        }

        @Override
        public void through(Filter filter) {
            this.through(filter, new HashMap<String, String>());
        }

        @Override
        public void through(Class<? extends Filter> filterKey, Map<String, String> initParams) {
            this.through(Key.get(filterKey), initParams);
        }

        @Override
        public void through(Key<? extends Filter> filterKey, Map<String, String> initParams) {
            this.through(filterKey, initParams, null);
        }

        private void through(Key<? extends Filter> filterKey, Map<String, String> initParams, Filter filterInstance) {
            for (UriPatternMatcher pattern : this.uriPatterns) {
                FiltersModuleBuilder.this.binder.bind(FilterDefinition.class).annotatedWith(UniqueAnnotations.create()).toProvider(new FilterDefinition(filterKey, pattern, initParams, filterInstance));
            }
        }

        @Override
        public void through(Filter filter, Map<String, String> initParams) {
            Key<Filter> filterKey = Key.get(Filter.class, UniqueAnnotations.create());
            FiltersModuleBuilder.this.binder.bind(filterKey).toInstance(filter);
            this.through(filterKey, initParams, filter);
        }
    }
}

