/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation.planning;

import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.ReservationRequestInterpreter;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.IterativePlanner;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.StageExecutionInterval;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.StageExecutionIntervalUnconstrained;

public class StageExecutionIntervalByDemand
implements StageExecutionInterval {
    private long step;

    @Override
    public ReservationInterval computeExecutionInterval(Plan plan, ReservationDefinition reservation, ReservationRequest currentReservationStage, boolean allocateLeft, RLESparseResourceAllocation allocations) {
        ReservationInterval maxInterval = new StageExecutionIntervalUnconstrained().computeExecutionInterval(plan, reservation, currentReservationStage, allocateLeft, allocations);
        ReservationRequestInterpreter jobType = reservation.getReservationRequests().getInterpreter();
        if (jobType != ReservationRequestInterpreter.R_ORDER && jobType != ReservationRequestInterpreter.R_ORDER_NO_GAP) {
            return maxInterval;
        }
        this.step = plan.getStep();
        double totalWeight = 0.0;
        long totalDuration = 0L;
        IterativePlanner.StageProvider stageProvider = new IterativePlanner.StageProvider(!allocateLeft, reservation);
        while (stageProvider.hasNext()) {
            ReservationRequest rr = stageProvider.next();
            totalWeight += this.calcWeight(rr);
            totalDuration += this.getRoundedDuration(rr, this.step);
            if (rr != currentReservationStage) continue;
            break;
        }
        double ratio = this.calcWeight(currentReservationStage) / totalWeight;
        long maxIntervalArrival = maxInterval.getStartTime();
        long maxIntervalDeadline = maxInterval.getEndTime();
        long window = maxIntervalDeadline - maxIntervalArrival;
        long windowRemainder = window - totalDuration;
        if (allocateLeft) {
            long latestEnd = (long)((double)(maxIntervalArrival + this.getRoundedDuration(currentReservationStage, this.step)) + (double)windowRemainder * ratio);
            latestEnd = StageExecutionIntervalByDemand.stepRoundDown(latestEnd, this.step);
            return new ReservationInterval(maxIntervalArrival, latestEnd);
        }
        long earlyStart = (long)((double)(maxIntervalDeadline - this.getRoundedDuration(currentReservationStage, this.step)) - (double)windowRemainder * ratio);
        earlyStart = StageExecutionIntervalByDemand.stepRoundUp(earlyStart, this.step);
        return new ReservationInterval(earlyStart, maxIntervalDeadline);
    }

    protected double calcWeight(ReservationRequest stage) {
        return stage.getDuration() * stage.getCapability().getMemorySize() * (long)stage.getNumContainers();
    }

    protected long getRoundedDuration(ReservationRequest stage, Long s) {
        return StageExecutionIntervalByDemand.stepRoundUp(stage.getDuration(), s);
    }

    protected static long stepRoundDown(long t, long s) {
        return t / s * s;
    }

    protected static long stepRoundUp(long t, long s) {
        return (t + s - 1L) / s * s;
    }
}

