/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimelineStorageMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineStorageMonitor.class);
    private ScheduledExecutorService monitorExecutorService;
    private long monitorInterval;
    private Storage storage;
    private AtomicBoolean storageDown = new AtomicBoolean();

    public TimelineStorageMonitor(Configuration conf, Storage storage) {
        this.storage = storage;
        this.monitorInterval = conf.getLong("yarn.timeline-service.reader.storage-monitor.interval-ms", 60000L);
    }

    public void start() {
        LOG.info("Scheduling {} storage monitor at interval {}", (Object)this.storage, (Object)this.monitorInterval);
        this.monitorExecutorService = Executors.newScheduledThreadPool(1);
        this.monitorExecutorService.scheduleAtFixedRate(new MonitorThread(), 0L, this.monitorInterval, TimeUnit.MILLISECONDS);
    }

    public void stop() throws Exception {
        if (this.monitorExecutorService != null) {
            this.monitorExecutorService.shutdownNow();
            if (!this.monitorExecutorService.awaitTermination(30L, TimeUnit.SECONDS)) {
                LOG.warn("Failed to stop the monitor task in time. will still proceed to close the monitor.");
            }
        }
    }

    public abstract void healthCheck() throws Exception;

    public void checkStorageIsUp() throws IOException {
        if (this.storageDown.get()) {
            throw new IOException((Object)((Object)this.storage) + " is down");
        }
    }

    private class MonitorThread
    implements Runnable {
        private MonitorThread() {
        }

        @Override
        public void run() {
            try {
                LOG.debug("Running Timeline Storage monitor");
                TimelineStorageMonitor.this.healthCheck();
                if (TimelineStorageMonitor.this.storageDown.getAndSet(false)) {
                    LOG.debug("{} health check succeeded, assuming storage is up", (Object)TimelineStorageMonitor.this.storage);
                }
            }
            catch (Exception e) {
                LOG.warn(String.format("Got failure attempting to read from %s, assuming Storage is down", new Object[]{TimelineStorageMonitor.this.storage}), (Throwable)e);
                TimelineStorageMonitor.this.storageDown.getAndSet(true);
            }
        }
    }

    public static enum Storage {
        HBase;

    }
}

