/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.shaded.org.fusesource.leveldbjni.JniDBFactory;
import org.apache.hadoop.shaded.org.iq80.leveldb.DB;
import org.apache.hadoop.shaded.org.iq80.leveldb.DBComparator;
import org.apache.hadoop.shaded.org.iq80.leveldb.DBException;
import org.apache.hadoop.shaded.org.iq80.leveldb.DBIterator;
import org.apache.hadoop.shaded.org.iq80.leveldb.Options;
import org.apache.hadoop.shaded.org.iq80.leveldb.WriteBatch;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.resourcemanager.DBManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeveldbConfigurationStore
extends YarnConfigurationStore {
    public static final Logger LOG = LoggerFactory.getLogger(LeveldbConfigurationStore.class);
    private static final String DB_NAME = "yarn-conf-store";
    private static final String LOG_KEY = "log";
    private static final String VERSION_KEY = "version";
    private static final String CONF_VERSION_NAME = "conf-version-store";
    private static final String CONF_VERSION_KEY = "conf-version";
    private DB db;
    private DBManager dbManager;
    private DBManager versionDbManager;
    private DB versionDb;
    private long maxLogs;
    private Configuration conf;
    private Configuration initSchedConf;
    @VisibleForTesting
    protected static final Version CURRENT_VERSION_INFO = Version.newInstance(0, 1);

    @Override
    public void initialize(Configuration config, Configuration schedConf, RMContext rmContext) throws IOException {
        this.conf = config;
        this.initSchedConf = schedConf;
        this.dbManager = new DBManager();
        this.versionDbManager = new DBManager();
        try {
            this.initDatabase();
            this.maxLogs = config.getLong("yarn.scheduler.configuration.store.max-logs", 1000L);
            long compactionIntervalMsec = config.getLong("yarn.scheduler.configuration.leveldb-store.compaction-interval-secs", 86400L) * 1000L;
            this.dbManager.startCompactionTimer(compactionIntervalMsec, this.getClass().getSimpleName());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void format() throws Exception {
        this.close();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        fs.delete(this.getStorageDir(DB_NAME), true);
    }

    private void initDatabase() throws Exception {
        Path confVersion = this.createStorageDir(CONF_VERSION_NAME);
        Options confOptions = new Options();
        confOptions.createIfMissing(false);
        File confVersionFile = new File(confVersion.toString());
        this.versionDb = this.versionDbManager.initDatabase(confVersionFile, confOptions, this::initVersionDb);
        Path storeRoot = this.createStorageDir(DB_NAME);
        Options options = new Options();
        options.createIfMissing(false);
        options.comparator(new DBComparator(){

            public int compare(byte[] key1, byte[] key2) {
                String key1Str = new String(key1, StandardCharsets.UTF_8);
                String key2Str = new String(key2, StandardCharsets.UTF_8);
                if (key1Str.equals(key2Str)) {
                    return 0;
                }
                if (key1Str.equals(LeveldbConfigurationStore.VERSION_KEY)) {
                    return 1;
                }
                if (key2Str.equals(LeveldbConfigurationStore.VERSION_KEY)) {
                    return -1;
                }
                if (key1Str.equals(LeveldbConfigurationStore.LOG_KEY)) {
                    return 1;
                }
                if (key2Str.equals(LeveldbConfigurationStore.LOG_KEY)) {
                    return -1;
                }
                return key1Str.compareTo(key2Str);
            }

            public String name() {
                return "keyComparator";
            }

            public byte[] findShortestSeparator(byte[] start, byte[] limit) {
                return start;
            }

            public byte[] findShortSuccessor(byte[] key) {
                return key;
            }
        });
        LOG.info("Using conf database at {}", (Object)storeRoot);
        File dbFile = new File(storeRoot.toString());
        this.db = this.dbManager.initDatabase(dbFile, options, this::initDb);
    }

    private void initVersionDb(DB database) {
        database.put(JniDBFactory.bytes((String)CONF_VERSION_KEY), JniDBFactory.bytes((String)String.valueOf(0)));
    }

    private void initDb(DB database) {
        WriteBatch initBatch = database.createWriteBatch();
        for (Map.Entry kv : this.initSchedConf) {
            initBatch.put(JniDBFactory.bytes((String)((String)kv.getKey())), JniDBFactory.bytes((String)((String)kv.getValue())));
        }
        database.write(initBatch);
        this.increaseConfigVersion();
    }

    private Path createStorageDir(String storageName) throws IOException {
        Path root = this.getStorageDir(storageName);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        fs.mkdirs(root, new FsPermission(448));
        return root;
    }

    private Path getStorageDir(String storageName) throws IOException {
        String storePath = this.conf.get("yarn.scheduler.configuration.leveldb-store.path");
        if (storePath == null) {
            throw new IOException("No store location directory configured in yarn.scheduler.configuration.leveldb-store.path");
        }
        return new Path(storePath, storageName);
    }

    @Override
    public void close() throws IOException {
        this.dbManager.close();
        this.versionDbManager.close();
    }

    @Override
    public void logMutation(YarnConfigurationStore.LogMutation logMutation) throws IOException {
        if (this.maxLogs > 0L) {
            LinkedList<YarnConfigurationStore.LogMutation> logs = this.deserLogMutations(this.db.get(JniDBFactory.bytes((String)LOG_KEY)));
            logs.add(logMutation);
            if ((long)logs.size() > this.maxLogs) {
                logs.removeFirst();
            }
            this.db.put(JniDBFactory.bytes((String)LOG_KEY), this.serLogMutations(logs));
        }
    }

    @Override
    public void confirmMutation(YarnConfigurationStore.LogMutation pendingMutation, boolean isValid) {
        WriteBatch updateBatch = this.db.createWriteBatch();
        if (isValid) {
            for (Map.Entry<String, String> changes : pendingMutation.getUpdates().entrySet()) {
                if (changes.getValue() == null || changes.getValue().isEmpty()) {
                    updateBatch.delete(JniDBFactory.bytes((String)changes.getKey()));
                    continue;
                }
                updateBatch.put(JniDBFactory.bytes((String)changes.getKey()), JniDBFactory.bytes((String)changes.getValue()));
            }
            this.increaseConfigVersion();
        }
        this.db.write(updateBatch);
    }

    private byte[] serLogMutations(LinkedList<YarnConfigurationStore.LogMutation> mutations) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(mutations);
            oos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    private LinkedList<YarnConfigurationStore.LogMutation> deserLogMutations(byte[] mutations) throws IOException {
        LinkedList linkedList;
        if (mutations == null) {
            return new LinkedList<YarnConfigurationStore.LogMutation>();
        }
        ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(mutations));
        try {
            linkedList = (LinkedList)input.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }
        input.close();
        return linkedList;
    }

    @Override
    public synchronized Configuration retrieve() {
        DBIterator itr = this.db.iterator();
        itr.seekToFirst();
        Configuration config = new Configuration(false);
        while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            String key = new String((byte[])entry.getKey(), StandardCharsets.UTF_8);
            String value = new String((byte[])entry.getValue(), StandardCharsets.UTF_8);
            if (key.equals(LOG_KEY) || key.equals(VERSION_KEY)) break;
            config.set(key, value);
        }
        return config;
    }

    private void increaseConfigVersion() {
        long configVersion = this.getConfigVersion() + 1L;
        this.versionDb.put(JniDBFactory.bytes((String)CONF_VERSION_KEY), JniDBFactory.bytes((String)String.valueOf(configVersion)));
    }

    @Override
    public long getConfigVersion() {
        String version = new String(this.versionDb.get(JniDBFactory.bytes((String)CONF_VERSION_KEY)), StandardCharsets.UTF_8);
        return Long.parseLong(version);
    }

    @Override
    public List<YarnConfigurationStore.LogMutation> getConfirmedConfHistory(long fromId) {
        return null;
    }

    @Override
    public Version getConfStoreVersion() throws Exception {
        return this.dbManager.loadVersion(VERSION_KEY);
    }

    @Override
    @VisibleForTesting
    protected LinkedList<YarnConfigurationStore.LogMutation> getLogs() throws Exception {
        return this.deserLogMutations(this.db.get(JniDBFactory.bytes((String)LOG_KEY)));
    }

    @VisibleForTesting
    protected DB getDB() {
        return this.db;
    }

    @Override
    public void storeVersion() throws Exception {
        try {
            this.storeVersion(CURRENT_VERSION_INFO);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @VisibleForTesting
    protected void storeVersion(Version version) {
        this.dbManager.storeVersion(VERSION_KEY, version);
    }

    @Override
    public Version getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }
}

