/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;

public class CSQueueStore {
    private final Map<String, CSQueue> fullNameQueues = new HashMap<String, CSQueue>();
    private final Map<String, Set<String>> shortNameToLongNames = new HashMap<String, Set<String>>();
    private final Map<String, CSQueue> getMap = new HashMap<String, CSQueue>();
    private ReadWriteLock modificationLock = new ReentrantReadWriteLock();

    Map<String, CSQueue> getFullNameQueues() {
        return ImmutableMap.copyOf(this.fullNameQueues);
    }

    @VisibleForTesting
    Map<String, CSQueue> getShortNameQueues() {
        try {
            this.modificationLock.readLock().lock();
            ImmutableMap immutableMap = ImmutableMap.copyOf(this.fullNameQueues.entrySet().stream().filter(entry -> this.getMap.get(((CSQueue)entry.getValue()).getQueueShortName()) == entry.getValue()).collect(Collectors.toMap(entry -> ((CSQueue)entry.getValue()).getQueueShortName(), entry -> (CSQueue)entry.getValue())));
            return immutableMap;
        }
        finally {
            this.modificationLock.readLock().unlock();
        }
    }

    private void updateGetMapForShortName(String shortName) {
        if (shortName.equals("root")) {
            return;
        }
        Set<String> fullNames = this.shortNameToLongNames.get(shortName);
        if (fullNames != null && fullNames.size() == 1) {
            this.getMap.put(shortName, this.fullNameQueues.get(fullNames.iterator().next()));
        } else {
            this.getMap.remove(shortName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CSQueue queue) {
        String fullName = queue.getQueuePath();
        String shortName = queue.getQueueShortName();
        try {
            this.modificationLock.writeLock().lock();
            this.fullNameQueues.put(fullName, queue);
            this.getMap.put(fullName, queue);
            if (!shortName.equals("root")) {
                Set fullNamesSet = this.shortNameToLongNames.getOrDefault(shortName, new HashSet());
                fullNamesSet.add(fullName);
                this.shortNameToLongNames.put(shortName, fullNamesSet);
            }
            this.updateGetMapForShortName(shortName);
        }
        finally {
            this.modificationLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CSQueue queue) {
        if (queue == null) {
            return;
        }
        try {
            this.modificationLock.writeLock().lock();
            String fullName = queue.getQueuePath();
            String shortName = queue.getQueueShortName();
            this.fullNameQueues.remove(fullName);
            this.getMap.remove(fullName);
            if (!shortName.equals("root")) {
                Set<String> fullNamesSet = this.shortNameToLongNames.get(shortName);
                fullNamesSet.remove(fullName);
                if (fullNamesSet.size() == 0) {
                    this.shortNameToLongNames.remove(shortName);
                }
            }
            this.updateGetMapForShortName(shortName);
        }
        finally {
            this.modificationLock.writeLock().unlock();
        }
    }

    public void remove(String name) {
        CSQueue queue = this.get(name);
        if (queue != null) {
            this.remove(queue);
        }
    }

    CSQueue getByFullName(String fullName) {
        if (fullName == null) {
            return null;
        }
        try {
            this.modificationLock.readLock().lock();
            CSQueue cSQueue = this.fullNameQueues.getOrDefault(fullName, null);
            return cSQueue;
        }
        finally {
            this.modificationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAmbiguous(String shortName) {
        if (shortName == null) {
            return false;
        }
        boolean ret = true;
        try {
            this.modificationLock.readLock().lock();
            Set<String> fullNamesSet = this.shortNameToLongNames.get(shortName);
            if (fullNamesSet == null || fullNamesSet.size() <= 1) {
                ret = false;
            }
        }
        finally {
            this.modificationLock.readLock().unlock();
        }
        return ret;
    }

    public CSQueue get(String name) {
        if (name == null) {
            return null;
        }
        try {
            this.modificationLock.readLock().lock();
            CSQueue cSQueue = this.getMap.getOrDefault(name, null);
            return cSQueue;
        }
        finally {
            this.modificationLock.readLock().unlock();
        }
    }

    public void clear() {
        try {
            this.modificationLock.writeLock().lock();
            this.fullNameQueues.clear();
            this.shortNameToLongNames.clear();
            this.getMap.clear();
        }
        finally {
            this.modificationLock.writeLock().unlock();
        }
    }

    public Collection<CSQueue> getQueues() {
        try {
            this.modificationLock.readLock().lock();
            ImmutableList immutableList = ImmutableList.copyOf(this.fullNameQueues.values());
            return immutableList;
        }
        finally {
            this.modificationLock.readLock().unlock();
        }
    }
}

