/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities;

import java.util.Set;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.DiagnosticsCollector;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;

public class GenericDiagnosticsCollector
implements DiagnosticsCollector {
    public static final String RESOURCE_DIAGNOSTICS_PREFIX = "insufficient resources=";
    public static final String PLACEMENT_CONSTRAINT_DIAGNOSTICS_PREFIX = "unsatisfied PC expression=";
    public static final String PARTITION_DIAGNOSTICS_PREFIX = "unsatisfied node partition=";
    private String diagnostics;
    private String details;

    @Override
    public void collect(String diagnosticsInfo, String detailsInfo) {
        this.diagnostics = diagnosticsInfo;
        this.details = detailsInfo;
    }

    @Override
    public String getDiagnostics() {
        return this.diagnostics;
    }

    @Override
    public String getDetails() {
        return this.details;
    }

    @Override
    public void collectResourceDiagnostics(ResourceCalculator rc, Resource required, Resource available) {
        Set insufficientResourceNames = rc.getInsufficientResourceNames(required, available);
        this.diagnostics = RESOURCE_DIAGNOSTICS_PREFIX + insufficientResourceNames;
        this.details = "required=" + required + ", available=" + available;
    }

    @Override
    public void collectPlacementConstraintDiagnostics(PlacementConstraint pc, PlacementConstraint.TargetExpression.TargetType targetType) {
        this.diagnostics = PLACEMENT_CONSTRAINT_DIAGNOSTICS_PREFIX + "\"" + pc + "\", target-type=" + targetType;
        this.details = null;
    }

    @Override
    public void collectPartitionDiagnostics(String requiredPartition, String nodePartition) {
        this.diagnostics = PARTITION_DIAGNOSTICS_PREFIX + nodePartition + ", required-partition=" + requiredPartition;
        this.details = null;
    }
}

