/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.records;

import java.util.Date;
import java.util.Objects;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.hadoop.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hadoop.shaded.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.records.AuxServiceConfiguration;

@InterfaceAudience.Public
@InterfaceStability.Unstable
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "version", "description", "launch_time", "configuration"})
public class AuxServiceRecord {
    private String name = null;
    private String version = null;
    private String description = null;
    private Date launchTime = null;
    private AuxServiceConfiguration configuration = new AuxServiceConfiguration();

    public AuxServiceRecord name(String n) {
        this.name = n;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public AuxServiceRecord version(String v) {
        this.version = v;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AuxServiceRecord description(String d) {
        this.description = d;
        return this;
    }

    public AuxServiceRecord launchTime(Date time) {
        this.launchTime = time == null ? null : (Date)time.clone();
        return this;
    }

    @JsonProperty(value="launch_time")
    public Date getLaunchTime() {
        return this.launchTime == null ? null : (Date)this.launchTime.clone();
    }

    public void setLaunchTime(Date time) {
        this.launchTime = time == null ? null : (Date)time.clone();
    }

    public AuxServiceRecord configuration(AuxServiceConfiguration conf) {
        this.configuration = conf;
        return this;
    }

    @JsonProperty(value="configuration")
    public AuxServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AuxServiceConfiguration conf) {
        this.configuration = conf;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuxServiceRecord service = (AuxServiceRecord)o;
        return Objects.equals(this.name, service.name) && Objects.equals(this.version, service.version);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Service {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    configuration: ").append(this.toIndentedString(this.configuration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

