/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.handler;

import org.apache.hadoop.shaded.org.mockito.internal.matchers.Equality;
import org.apache.hadoop.shaded.org.mockito.invocation.DescribedInvocation;
import org.apache.hadoop.shaded.org.mockito.invocation.Invocation;
import org.apache.hadoop.shaded.org.mockito.listeners.MethodInvocationReport;

public class NotifiedMethodInvocationReport
implements MethodInvocationReport {
    private final Invocation invocation;
    private final Object returnedValue;
    private final Throwable throwable;

    public NotifiedMethodInvocationReport(Invocation invocation, Object returnedValue) {
        this.invocation = invocation;
        this.returnedValue = returnedValue;
        this.throwable = null;
    }

    public NotifiedMethodInvocationReport(Invocation invocation, Throwable throwable) {
        this.invocation = invocation;
        this.returnedValue = null;
        this.throwable = throwable;
    }

    @Override
    public DescribedInvocation getInvocation() {
        return this.invocation;
    }

    @Override
    public Object getReturnedValue() {
        return this.returnedValue;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public boolean threwException() {
        return this.throwable != null;
    }

    @Override
    public String getLocationOfStubbing() {
        return this.invocation.stubInfo() == null ? null : this.invocation.stubInfo().stubbedAt().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotifiedMethodInvocationReport that = (NotifiedMethodInvocationReport)o;
        return Equality.areEqual(this.invocation, that.invocation) && Equality.areEqual(this.returnedValue, that.returnedValue) && Equality.areEqual(this.throwable, that.throwable);
    }

    public int hashCode() {
        int result = this.invocation != null ? this.invocation.hashCode() : 0;
        result = 31 * result + (this.returnedValue != null ? this.returnedValue.hashCode() : 0);
        result = 31 * result + (this.throwable != null ? this.throwable.hashCode() : 0);
        return result;
    }
}

