/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.RMVolumeShardingUtil;
import org.apache.hadoop.yarn.conf.YarnDefaultProperties;
import org.apache.hadoop.yarn.server.volume.VolumeManager;
import org.apache.hadoop.yarn.util.ScramCredentialScriptUtil;
import org.apache.hadoop.yarn.util.YarnAppUtil;
import org.slf4j.LoggerFactory;

public class RMVolumeManager
extends VolumeManager {
    private int volumeCount;
    private boolean useVolumeSharding;
    private String rmDir;
    private String rmSystemDir;
    private String rmStagingDir;
    private String newHSVolumeMountPath;

    public RMVolumeManager() {
        super("RMVolumeManager");
    }

    @Override
    public void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.LOG = LoggerFactory.getLogger(RMVolumeManager.class);
        this.volumeMode = "yarn";
        this.volumeLogfilePath = this.volumeLogfilePath + "/logs/createRMVolume.log";
        this.rmDir = conf.get("yarn.resourcemanager.dir", YarnDefaultProperties.DEFAULT_RM_DIR);
        this.mountPath = this.newVolumePathSupportEnabled ? this.rmDir : new Path(this.rmDir).getParent().toUri().getRawPath();
        this.rmSystemDir = conf.get("yarn.resourcemanager.system", YarnDefaultProperties.DEFAULT_RM_SYSTEM_DIR);
        this.rmStagingDir = conf.get("yarn.resourcemanager.staging", YarnDefaultProperties.DEFAULT_RM_STAGING_DIR);
        this.volumeCount = conf.getInt("yarn.resourcemanager.dir.volume-count", 4);
        this.useVolumeSharding = conf.getBoolean("yarn.resourcemanager.dir.volume-sharding.enabled", false) && new Path(this.rmStagingDir).toUri().getRawPath().startsWith(new Path(this.rmDir).toUri().getRawPath()) && new Path(this.rmSystemDir).toUri().getRawPath().startsWith(new Path(this.rmDir).toUri().getRawPath());
        try {
            this.lockVolume("mapr.resourcemanager.volume");
            this.verifyRMVolumeMountPoint();
            if (this.useVolumeSharding) {
                this.verifyRMShardedVolumesMountPoints();
            }
            this.createVolumes(conf);
            if (this.newHSVolumeMountPath != null && !this.isVolumeMounted("mapr.historyserver.volume")) {
                this.mountVolume("mapr.historyserver.volume", this.newHSVolumeMountPath);
            }
            RMVolumeShardingUtil.rebalanceVolumes((String)this.rmSystemDir, (int)this.volumeCount, (boolean)this.useVolumeSharding, (String)this.rmDir, (FileSystem)this.fs);
            RMVolumeShardingUtil.rebalanceVolumes((String)this.rmStagingDir, (int)this.volumeCount, (boolean)this.useVolumeSharding, (String)this.rmDir, (FileSystem)this.fs);
        }
        finally {
            this.unlockVolume("mapr.resourcemanager.volume");
        }
    }

    @Override
    public void createVolumes(Configuration conf) throws Exception {
        this.waitForYarnPathCreated();
        if (!this.isVolumeMounted("mapr.resourcemanager.volume")) {
            this.createVolume("");
            if (this.newVolumePathSupportEnabled) {
                this.moveVolumeDataAfterUpgrade();
            }
        }
        if (conf.get("hadoop.security.token.authentication.method", "DIGEST-MD5").equalsIgnoreCase("SCRAM-SHA-256")) {
            ScramCredentialScriptUtil.checkAndCopyScramCreds((Configuration)conf, (String)"resourceManager");
        }
        this.createDir(conf.get("yarn.resourcemanager.system", YarnDefaultProperties.DEFAULT_RM_SYSTEM_DIR), YarnAppUtil.RM_SYSTEM_DIR_PERMISSION);
        this.createDir(conf.get("yarn.resourcemanager.staging", YarnDefaultProperties.DEFAULT_RM_STAGING_DIR), YarnAppUtil.RM_STAGING_DIR_PERMISSION);
        if (this.useVolumeSharding) {
            for (int volumeNumber = 0; volumeNumber < this.volumeCount; ++volumeNumber) {
                if (!this.isVolumeMounted("mapr.resourcemanager.volume_" + volumeNumber)) {
                    this.createVolume(Integer.toString(volumeNumber));
                }
                this.createDir(this.rmSystemDir.replaceAll(this.rmDir, this.rmDir + "/" + volumeNumber), YarnAppUtil.RM_SYSTEM_DIR_PERMISSION);
                this.createDir(this.rmStagingDir.replaceAll(this.rmDir, this.rmDir + "/" + volumeNumber), YarnAppUtil.RM_STAGING_DIR_PERMISSION);
            }
        }
    }

    private void verifyRMVolumeMountPoint() throws IOException {
        Map<String, String> volumeInfo = this.getVolumeInfo("mapr.resourcemanager.volume");
        if (volumeInfo != null) {
            String rmVolumePath = volumeInfo.get("path");
            int mounted = Integer.parseInt(volumeInfo.get("mounted"));
            if (mounted != 1) {
                return;
            }
            if (rmVolumePath.equals(this.rmDir) && !this.newVolumePathSupportEnabled) {
                this.LOG.warn("Volume mapr.resourcemanager.volume is mounted at " + this.rmDir + ". Disabling for property " + "yarn.resourcemanager.dir.new-volume-path-support.enabled" + " is not supported. Continue as new-volume-path-support is true");
            } else if (!rmVolumePath.equals(this.mountPath)) {
                if (this.isHSVolumeChildForRMVolume(rmVolumePath)) {
                    this.unmountVolume("mapr.historyserver.volume");
                }
                this.LOG.info("Volume mapr.resourcemanager.volume is mounted at " + rmVolumePath + ". Mount path is configured as " + this.mountPath);
                this.unmountVolume("mapr.resourcemanager.volume");
            }
        }
    }

    private void verifyRMShardedVolumesMountPoints() throws IOException {
        for (int volumeNumber = 0; volumeNumber < this.volumeCount; ++volumeNumber) {
            String shardedVolumeName = "mapr.resourcemanager.volume_" + volumeNumber;
            String volumePath = this.rmDir + "/" + volumeNumber;
            Map<String, String> volumeInfo = this.getVolumeInfo(shardedVolumeName);
            if (volumeInfo == null) continue;
            String mountedPath = volumeInfo.get("path");
            int mounted = Integer.parseInt(volumeInfo.get("mounted"));
            if (mounted != 1) {
                return;
            }
            if (mountedPath.equals(volumePath)) continue;
            this.unmountVolume(shardedVolumeName);
        }
    }

    private boolean isHSVolumeChildForRMVolume(String rmVolumePath) throws IOException {
        Map<String, String> volumeInfo = this.getVolumeInfo("mapr.historyserver.volume");
        if (volumeInfo != null) {
            String hsVolumePath = volumeInfo.get("path");
            int mounted = Integer.parseInt(volumeInfo.get("mounted"));
            if (hsVolumePath.startsWith(rmVolumePath + "/") && mounted == 1) {
                this.newHSVolumeMountPath = hsVolumePath;
                this.LOG.info("Volume mapr.historyserver.volume with path " + hsVolumePath + " is child of " + "mapr.resourcemanager.volume" + " with path " + rmVolumePath + ". Before unmount " + "mapr.resourcemanager.volume" + " need to unmount " + "mapr.historyserver.volume");
                return true;
            }
        }
        return false;
    }

    private void moveVolumeDataAfterUpgrade() throws IOException {
        Path oldRMDir = new Path(this.mountPath + "/rm");
        if (this.fs.exists(oldRMDir)) {
            FileStatus[] oldData;
            for (FileStatus srcDir : oldData = this.fs.listStatus(oldRMDir)) {
                Path dstDir = new Path(this.mountPath, srcDir.getPath().getName());
                if (this.fs.exists(dstDir)) continue;
                this.fs.rename(srcDir.getPath(), dstDir);
            }
            oldData = this.fs.listStatus(oldRMDir);
            if (oldData.length == 0) {
                this.fs.delete(oldRMDir, true);
            } else {
                this.LOG.warn(oldRMDir + " directory not empty, deletion postponed");
            }
        }
    }
}

