/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.rpcauth;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslServer;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.rpcauth.TokenAuthMethod;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DigestAuthMethod
extends TokenAuthMethod {
    private static final Logger LOG = LoggerFactory.getLogger(DigestAuthMethod.class);
    static final TokenAuthMethod INSTANCE = new DigestAuthMethod();

    private DigestAuthMethod() {
        super((byte)82, "token", "DIGEST-MD5", UserGroupInformation.AuthenticationMethod.TOKEN);
    }

    @Override
    public SaslClient createSaslClient(Map<String, Object> saslProperties) throws IOException {
        Token token = (Token)saslProperties.get("org.apache.hadoop.auth.token");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating SASL " + this.mechanismName + " client to authenticate to service at " + token.getService());
        }
        return Sasl.createSaslClient(new String[]{this.mechanismName}, null, null, "default", saslProperties, new SaslClientCallbackHandler(token));
    }

    @Override
    public SaslServer createSaslServer(Server.Connection connection, Map<String, Object> saslProperties) throws IOException {
        SecretManager secretManager = (SecretManager)saslProperties.get("org.apache.hadoop.auth.secret.manager");
        if (secretManager == null) {
            throw new AccessControlException("Server is not configured to do DIGEST authentication.");
        }
        return Sasl.createSaslServer(this.mechanismName, null, "default", saslProperties, new SaslDigestCallbackHandler(secretManager, connection));
    }

    public static class SaslDigestCallbackHandler
    implements CallbackHandler {
        private SecretManager<TokenIdentifier> secretManager;
        private Server.Connection connection;

        public SaslDigestCallbackHandler(SecretManager<TokenIdentifier> secretManager, Server.Connection connection) {
            this.secretManager = secretManager;
            this.connection = connection;
        }

        private char[] getPassword(TokenIdentifier tokenid) throws SecretManager.InvalidToken {
            return TokenAuthMethod.encodePassword(this.secretManager.retrievePassword(tokenid));
        }

        @Override
        public void handle(Callback[] callbacks) throws SecretManager.InvalidToken, UnsupportedCallbackException {
            NameCallback nc = null;
            PasswordCallback pc = null;
            AuthorizeCallback ac = null;
            for (Callback callback : callbacks) {
                if (callback instanceof AuthorizeCallback) {
                    ac = (AuthorizeCallback)callback;
                    continue;
                }
                if (callback instanceof NameCallback) {
                    nc = (NameCallback)callback;
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    pc = (PasswordCallback)callback;
                    continue;
                }
                if (callback instanceof RealmCallback) continue;
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL DIGEST-MD5 Callback");
            }
            if (pc != null) {
                TokenIdentifier tokenIdentifier = TokenAuthMethod.getIdentifier(nc.getDefaultName(), this.secretManager);
                char[] password = this.getPassword(tokenIdentifier);
                UserGroupInformation user = null;
                this.connection.attemptingUser = user = tokenIdentifier.getUser();
                if (SaslRpcServer.LOG.isDebugEnabled()) {
                    SaslRpcServer.LOG.debug("SASL server DIGEST-MD5 callback: setting password for client: " + tokenIdentifier.getUser());
                }
                pc.setPassword(password);
            }
            if (ac != null) {
                String authzid;
                String authid = ac.getAuthenticationID();
                if (authid.equals(authzid = ac.getAuthorizationID())) {
                    ac.setAuthorized(true);
                } else {
                    ac.setAuthorized(false);
                }
                if (ac.isAuthorized()) {
                    if (SaslRpcServer.LOG.isDebugEnabled()) {
                        String username = TokenAuthMethod.getIdentifier(authzid, this.secretManager).getUser().getUserName();
                        SaslRpcServer.LOG.debug("SASL server DIGEST-MD5 callback: setting canonicalized client ID: " + username);
                    }
                    ac.setAuthorizedID(authzid);
                }
            }
        }
    }

    private static class SaslClientCallbackHandler
    implements CallbackHandler {
        private final String userName;
        private final char[] userPassword;

        public SaslClientCallbackHandler(Token<? extends TokenIdentifier> token) {
            this.userName = TokenAuthMethod.encodeIdentifier(token.getIdentifier());
            this.userPassword = TokenAuthMethod.encodePassword(token.getPassword());
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            NameCallback nc = null;
            PasswordCallback pc = null;
            TextInputCallback rc = null;
            for (Callback callback : callbacks) {
                if (callback instanceof RealmChoiceCallback) continue;
                if (callback instanceof NameCallback) {
                    nc = (NameCallback)callback;
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    pc = (PasswordCallback)callback;
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    rc = (RealmCallback)callback;
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL client callback");
            }
            if (nc != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("SASL client callback: setting username: " + this.userName);
                }
                nc.setName(this.userName);
            }
            if (pc != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("SASL client callback: setting userPassword");
                }
                pc.setPassword(this.userPassword);
            }
            if (rc != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("SASL client callback: setting realm: " + rc.getDefaultText());
                }
                rc.setText(rc.getDefaultText());
            }
        }
    }
}

