package org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.logging;

import org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.log4j.helpers.LogLog;

import org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.shaded.org.apache.hadoop.fs.permission.FsPermission;

/**
 * A simple log4j-appender for the system logs generated by Yarn containers.
 */
public class YarnCentralTaskLogAppender extends CentralTaskLogAppender {
    private static final FsPermission DEFAULT_PERMISSIONS =
            new FsPermission((short)0640);

    private static final String LOGSIZE_PROPERTY = "yarn.app.container.log.filesize";

    @Override
    protected String getFrameworkType() {
        return "yarn";
    }

    @Override
    protected FsPermission getLogFilePermission() {
        return DEFAULT_PERMISSIONS;
    }

    @Override
    protected synchronized Long getFileSizeLimit() {
        try {
            String propValue = System.getProperty(LOGSIZE_PROPERTY);
            return propValue == null ? null : Long.parseLong(propValue);
        } catch (NumberFormatException e) {
            LogLog.error("Log size property should be a number", e);
            return null;
        }
    }
}
