/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.log;

import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.util.TaskLogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFSContainerLogsUtils {
    public static final Logger LOG = LoggerFactory.getLogger(DFSContainerLogsUtils.class);

    public static List<Path> getContainerLogDirs(ContainerId containerId) throws IOException {
        return Arrays.asList(TaskLogUtil.getDFSLoggingHandler().getLogDir(containerId));
    }

    public static Path getContainerLogFile(ContainerId containerId, String fileName, String remoteUser) throws IOException {
        return new Path(TaskLogUtil.getDFSLoggingHandler().getLogDir(containerId), fileName);
    }

    public static InputStream openLogFileForRead(String containerIdStr, final Path logFile, String user) throws IOException {
        UserGroupInformation ugi = null;
        ugi = UserGroupInformation.isSecurityEnabled() ? UserGroupInformation.createProxyUser(user, UserGroupInformation.getLoginUser()) : UserGroupInformation.getLoginUser();
        try {
            return ugi.doAs(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws Exception {
                    FileSystem fs = FileSystem.get(TaskLogUtil.getConf());
                    return fs.open(logFile);
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public static long getFileLength(Path logFile) throws IOException {
        FileSystem fs = FileSystem.get(TaskLogUtil.getConf());
        FileStatus fileStatus = fs.listStatus(logFile)[0];
        return fileStatus.getLen();
    }

    public static Path[] getFilesInDir(Path dir) throws IOException {
        Path[] paths = null;
        FileSystem fs = FileSystem.get(TaskLogUtil.getConf());
        FileStatus[] fileStatusArr = fs.listStatus(dir);
        if (fileStatusArr != null) {
            paths = new Path[fileStatusArr.length];
            for (int i = 0; i < fileStatusArr.length; ++i) {
                paths[i] = fileStatusArr[i].getPath();
            }
        }
        return paths;
    }
}

