/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.WatcherRemoveCuratorFramework;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundEnsembleable;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.api.ErrorListenerEnsembleable;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.curator.shaded.com.google.common.collect.Maps;
import org.apache.curator.utils.Compatibility;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public class EnsembleTracker
implements Closeable,
CuratorWatcher {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final WatcherRemoveCuratorFramework client;
    private final EnsembleProvider ensembleProvider;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final AtomicInteger outstanding = new AtomicInteger(0);
    private final AtomicReference<QuorumMaj> currentConfig = new AtomicReference<QuorumMaj>(new QuorumMaj(Maps.newHashMap()));
    private final ConnectionStateListener connectionStateListener = new ConnectionStateListener(){

        @Override
        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            if (newState == ConnectionState.CONNECTED || newState == ConnectionState.RECONNECTED) {
                try {
                    EnsembleTracker.this.reset();
                }
                catch (Exception e) {
                    EnsembleTracker.this.log.error("Trying to reset after reconnection", e);
                }
            }
        }

        @Override
        public boolean doNotProxy() {
            return true;
        }
    };

    EnsembleTracker(CuratorFramework client, EnsembleProvider ensembleProvider) {
        this.client = client.newWatcherRemoveCuratorFramework();
        this.ensembleProvider = ensembleProvider;
    }

    public void start() throws Exception {
        Preconditions.checkState(this.state.compareAndSet(State.LATENT, State.STARTED), "Cannot be started more than once");
        this.client.getConnectionStateListenable().addListener(this.connectionStateListener);
        this.reset();
    }

    @Override
    public void close() {
        if (this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            this.client.removeWatchers();
            this.client.getConnectionStateListenable().removeListener(this.connectionStateListener);
        }
    }

    @Override
    public void process(WatchedEvent event) throws Exception {
        if (event.getType() == Watcher.Event.EventType.NodeDataChanged) {
            this.reset();
        }
    }

    public QuorumVerifier getCurrentConfig() {
        return this.currentConfig.get();
    }

    @VisibleForTesting
    public boolean hasOutstanding() {
        return this.outstanding.get() > 0;
    }

    private void reset() throws Exception {
        if (this.client.getState() == CuratorFrameworkState.STARTED && this.state.get() == State.STARTED) {
            BackgroundCallback backgroundCallback = new BackgroundCallback(){

                @Override
                public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
                    EnsembleTracker.this.outstanding.decrementAndGet();
                    if (event.getType() == CuratorEventType.GET_CONFIG && event.getResultCode() == KeeperException.Code.OK.intValue()) {
                        EnsembleTracker.this.processConfigData(event.getData());
                    }
                }
            };
            this.outstanding.incrementAndGet();
            try {
                ((ErrorListenerEnsembleable)((BackgroundEnsembleable)this.client.getConfig().usingWatcher(this)).inBackground(backgroundCallback)).forEnsemble();
                this.outstanding.incrementAndGet();
            }
            finally {
                this.outstanding.decrementAndGet();
            }
        }
    }

    @VisibleForTesting
    public static String configToConnectionString(QuorumVerifier data) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (QuorumPeer.QuorumServer server : data.getAllMembers().values()) {
            if (server.clientAddr == null) continue;
            if (sb.length() != 0) {
                sb.append(",");
            }
            String hostAddress = server.clientAddr.getAddress().isAnyLocalAddress() ? Compatibility.getHostAddress(server) : server.clientAddr.getAddress().getHostAddress();
            sb.append(hostAddress).append(":").append(server.clientAddr.getPort());
        }
        return sb.toString();
    }

    private void processConfigData(byte[] data) throws Exception {
        Properties properties = new Properties();
        properties.load(new ByteArrayInputStream(data));
        this.log.info("New config event received: {}", (Object)properties);
        if (!properties.isEmpty()) {
            QuorumMaj newConfig = new QuorumMaj(properties);
            String connectionString = EnsembleTracker.configToConnectionString(newConfig);
            if (connectionString.trim().length() > 0) {
                this.currentConfig.set(newConfig);
                this.ensembleProvider.setConnectionString(connectionString);
            } else {
                this.log.debug("Invalid config event received: {}", (Object)properties);
            }
        } else {
            this.log.debug("Ignoring new config as it is empty");
        }
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

