/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ClosedIOException;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsTestWithTimeout;
import org.apache.hadoop.fs.azurebfs.services.KeepAliveCache;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.http.HttpClientConnection;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestApacheClientConnectionPool
extends AbstractAbfsTestWithTimeout {
    @Override
    protected int getTestTimeoutMillis() {
        return 20000;
    }

    @Test
    public void testBasicPool() throws Exception {
        System.clearProperty("http.maxConnections");
        this.validatePoolSize(5);
    }

    @Test
    public void testSysPropAppliedPool() throws Exception {
        String customPoolSize = "10";
        System.setProperty("http.maxConnections", "10");
        this.validatePoolSize(Integer.parseInt("10"));
    }

    @Test
    public void testPoolWithZeroSysProp() throws Exception {
        String customPoolSize = "0";
        System.setProperty("http.maxConnections", "0");
        this.validatePoolSize(5);
    }

    @Test
    public void testEmptySizePool() throws Exception {
        Configuration configuration = new Configuration();
        configuration.set("fs.azure.apache.http.client.max.cache.connection.size", "0");
        AbfsConfiguration abfsConfiguration = new AbfsConfiguration(configuration, "");
        try (KeepAliveCache keepAliveCache = new KeepAliveCache(abfsConfiguration);){
            this.assertCachePutFail(keepAliveCache, (HttpClientConnection)Mockito.mock(HttpClientConnection.class));
            this.assertCacheGetIsNull(keepAliveCache);
        }
    }

    private void assertCacheGetIsNull(KeepAliveCache keepAliveCache) throws IOException {
        ((ObjectAssert)Assertions.assertThat((Object)keepAliveCache.get()).describedAs("cache.get()", new Object[0])).isNull();
    }

    private void assertCacheGetIsNonNull(KeepAliveCache keepAliveCache) throws IOException {
        ((ObjectAssert)Assertions.assertThat((Object)keepAliveCache.get()).describedAs("cache.get()", new Object[0])).isNotNull();
    }

    private void assertCachePutFail(KeepAliveCache keepAliveCache, HttpClientConnection mock) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)keepAliveCache.put(mock)).describedAs("cache.put()", new Object[0])).isFalse();
    }

    private void assertCachePutSuccess(KeepAliveCache keepAliveCache, HttpClientConnection connections) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)keepAliveCache.put(connections)).describedAs("cache.put()", new Object[0])).isTrue();
    }

    private void validatePoolSize(int size) throws Exception {
        try (KeepAliveCache keepAliveCache = new KeepAliveCache(new AbfsConfiguration(new Configuration(), ""));){
            int i;
            keepAliveCache.clear();
            HttpClientConnection[] connections = new HttpClientConnection[size * 2];
            for (i = 0; i < size * 2; ++i) {
                connections[i] = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
            }
            for (i = 0; i < size; ++i) {
                this.assertCachePutSuccess(keepAliveCache, connections[i]);
                ((HttpClientConnection)Mockito.verify((Object)connections[i], (VerificationMode)Mockito.times((int)0))).close();
            }
            for (i = size; i < size * 2; ++i) {
                this.assertCachePutSuccess(keepAliveCache, connections[i]);
                ((HttpClientConnection)Mockito.verify((Object)connections[i - size], (VerificationMode)Mockito.times((int)1))).close();
            }
            for (i = 0; i < size * 2; ++i) {
                if (i < size) {
                    this.assertCacheGetIsNonNull(keepAliveCache);
                    continue;
                }
                this.assertCacheGetIsNull(keepAliveCache);
            }
            System.clearProperty("http.maxConnections");
        }
    }

    @Test
    public void testKeepAliveCache() throws Exception {
        try (KeepAliveCache keepAliveCache = new KeepAliveCache(new AbfsConfiguration(new Configuration(), ""));){
            keepAliveCache.clear();
            HttpClientConnection connection = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
            keepAliveCache.put(connection);
            this.assertCacheGetIsNonNull(keepAliveCache);
        }
    }

    @Test
    public void testKeepAliveCacheCleanup() throws Exception {
        Configuration configuration = new Configuration();
        configuration.set("fs.azure.apache.http.client.idle.connection.ttl", "100");
        try (KeepAliveCache keepAliveCache = new KeepAliveCache(new AbfsConfiguration(configuration, ""));){
            keepAliveCache.clear();
            HttpClientConnection connection = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
            AtomicBoolean isConnClosed = new AtomicBoolean(false);
            ((HttpClientConnection)Mockito.doAnswer(closeInvocation -> {
                isConnClosed.set(true);
                return null;
            }).when((Object)connection)).close();
            keepAliveCache.put(connection);
            while (!isConnClosed.get()) {
                Thread.sleep(100L);
            }
            this.assertCacheGetIsNull(keepAliveCache);
            ((HttpClientConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).close();
        }
    }

    @Test
    public void testKeepAliveCacheCleanupWithConnections() throws Exception {
        Configuration configuration = new Configuration();
        configuration.set("fs.azure.apache.http.client.idle.connection.ttl", "100");
        try (KeepAliveCache keepAliveCache = new KeepAliveCache(new AbfsConfiguration(configuration, ""));){
            keepAliveCache.pauseThread();
            keepAliveCache.clear();
            HttpClientConnection connection = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
            keepAliveCache.put(connection);
            Thread.sleep(2L * keepAliveCache.getConnectionIdleTTL());
            ((HttpClientConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)0))).close();
            this.assertCacheGetIsNull(keepAliveCache);
            ((HttpClientConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).close();
            keepAliveCache.resumeThread();
        }
    }

    @Test
    public void testKeepAliveCacheConnectionRecache() throws Exception {
        try (KeepAliveCache keepAliveCache = new KeepAliveCache(new AbfsConfiguration(new Configuration(), ""));){
            keepAliveCache.clear();
            HttpClientConnection connection = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
            keepAliveCache.put(connection);
            this.assertCacheGetIsNonNull(keepAliveCache);
            keepAliveCache.put(connection);
            this.assertCacheGetIsNonNull(keepAliveCache);
        }
    }

    @Test
    public void testKeepAliveCacheRemoveStaleConnection() throws Exception {
        try (KeepAliveCache keepAliveCache = new KeepAliveCache(new AbfsConfiguration(new Configuration(), ""));){
            int i;
            keepAliveCache.clear();
            HttpClientConnection[] connections = new HttpClientConnection[5];
            for (i = 0; i < 5; ++i) {
                connections[i] = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
                keepAliveCache.put(connections[i]);
            }
            for (i = 0; i < 3; ++i) {
                ((HttpClientConnection)Mockito.doReturn((Object)true).when((Object)connections[i])).isStale();
            }
            for (i = 4; i >= 0; --i) {
                if (i >= 3) {
                    this.assertCacheGetIsNonNull(keepAliveCache);
                    continue;
                }
                this.assertCacheGetIsNull(keepAliveCache);
                ((HttpClientConnection)Mockito.verify((Object)connections[i], (VerificationMode)Mockito.times((int)1))).close();
            }
        }
    }

    @Test
    public void testKeepAliveCacheClosed() throws Exception {
        KeepAliveCache keepAliveCache = (KeepAliveCache)Mockito.spy((Object)new KeepAliveCache(new AbfsConfiguration(new Configuration(), "")));
        keepAliveCache.put((HttpClientConnection)Mockito.mock(HttpClientConnection.class));
        keepAliveCache.close();
        LambdaTestUtils.intercept(ClosedIOException.class, (String)"KeepAliveCache is closed", () -> keepAliveCache.get());
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        this.assertCachePutFail(keepAliveCache, conn);
        ((HttpClientConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)1))).close();
        keepAliveCache.close();
        ((KeepAliveCache)Mockito.verify((Object)keepAliveCache, (VerificationMode)Mockito.times((int)1))).closeInternal();
    }
}

