/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStream;
import org.apache.hadoop.fs.azurebfs.utils.UriUtils;
import org.assertj.core.api.AbstractByteAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;

public class AbfsInputStreamTestUtils {
    public static final int HUNDRED = 100;
    private final AbstractAbfsIntegrationTest abstractAbfsIntegrationTest;

    public AbfsInputStreamTestUtils(AbstractAbfsIntegrationTest abstractAbfsIntegrationTest) {
        this.abstractAbfsIntegrationTest = abstractAbfsIntegrationTest;
    }

    private Path path(String filepath) throws IOException {
        return this.abstractAbfsIntegrationTest.getFileSystem().makeQualified(new Path(this.getTestPath(), this.getUniquePath(filepath)));
    }

    private Path getTestPath() {
        Path path = new Path(UriUtils.generateUniqueTestPath());
        return path;
    }

    private Path getUniquePath(String filepath) {
        if (filepath.equals("/")) {
            return new Path(filepath);
        }
        return new Path(filepath + StringUtils.right((String)UUID.randomUUID().toString(), (int)12));
    }

    public AzureBlobFileSystem getFileSystem(boolean readSmallFilesCompletely) throws IOException {
        Configuration configuration = new Configuration(this.abstractAbfsIntegrationTest.getRawConfiguration());
        configuration.setBoolean("fs.azure.read.smallfilescompletely", readSmallFilesCompletely);
        configuration.setBoolean("fs.azure.read.optimizefooterread", false);
        return (AzureBlobFileSystem)FileSystem.newInstance((Configuration)configuration);
    }

    public byte[] getRandomBytesArray(int length) {
        byte[] b = new byte[length];
        new Random().nextBytes(b);
        return b;
    }

    public Path createFileWithContent(FileSystem fs, String fileName, byte[] fileContent) throws IOException {
        Path testFilePath = this.path(fileName);
        try (FSDataOutputStream oStream = fs.create(testFilePath);){
            oStream.write(fileContent);
            oStream.flush();
        }
        return testFilePath;
    }

    public void assertContentReadCorrectly(byte[] actualFileContent, int from, int len, byte[] contentRead, Path testFilePath) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualFileContent.length).describedAs("From + len should be less than or equal to the actual file content length", new Object[0])).isGreaterThanOrEqualTo(from + len);
        ((AbstractIntegerAssert)Assertions.assertThat((int)contentRead.length).describedAs("Content read length should be greater than or equal to the len", new Object[0])).isGreaterThanOrEqualTo(len);
        for (int i = 0; i < len; ++i) {
            ((AbstractByteAssert)Assertions.assertThat((byte)contentRead[i]).describedAs("The test file path is " + testFilePath + ". Equality failedat index " + i + " of the contentRead array. ActualFileContent is being compared from index " + from, new Object[0])).isEqualTo(actualFileContent[i + from]);
        }
    }

    public void assertAbfsInputStreamBufferEqualToContentStartSubsequence(byte[] actualContent, AbfsInputStream abfsInputStream, AbfsConfiguration conf, Path testFilePath) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)abfsInputStream.getBuffer().length).describedAs("ReadBuffer should be lesser than or equal to readBufferSize", new Object[0])).isLessThanOrEqualTo(conf.getReadBufferSize());
        this.assertAbfsInputStreamBufferEqualityWithContentStartingSubSequence(actualContent, abfsInputStream.getBuffer(), conf, false, testFilePath);
    }

    public void assertAbfsInputStreamBufferNotEqualToContentStartSubsequence(byte[] actualContent, AbfsInputStream abfsInputStream, AbfsConfiguration conf, Path testFilePath) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)abfsInputStream.getBuffer().length).describedAs("ReadBuffer should be lesser than or equal to readBufferSize", new Object[0])).isLessThanOrEqualTo(conf.getReadBufferSize());
        this.assertAbfsInputStreamBufferEqualityWithContentStartingSubSequence(actualContent, abfsInputStream.getBuffer(), conf, true, testFilePath);
    }

    private void assertAbfsInputStreamBufferEqualityWithContentStartingSubSequence(byte[] actualContent, byte[] abfsInputStreamReadBuffer, AbfsConfiguration conf, boolean assertEqual, Path testFilePath) {
        int bufferSize = conf.getReadBufferSize();
        int actualContentSize = actualContent.length;
        int n = Math.min(actualContentSize, bufferSize);
        int matches = 0;
        for (int i = 0; i < n && i < abfsInputStreamReadBuffer.length; ++i) {
            if (actualContent[i] != abfsInputStreamReadBuffer[i]) continue;
            ++matches;
        }
        if (assertEqual) {
            ((AbstractIntegerAssert)Assertions.assertThat((int)matches).describedAs("The test file path is " + testFilePath, new Object[0])).isEqualTo(n);
        } else {
            ((AbstractIntegerAssert)Assertions.assertThat((int)matches).describedAs("The test file path is " + testFilePath, new Object[0])).isNotEqualTo(n);
        }
    }

    public void seek(FSDataInputStream iStream, long seekPos) throws IOException {
        AbfsInputStream abfsInputStream = (AbfsInputStream)iStream.getWrappedStream();
        this.verifyAbfsInputStreamBaseStateBeforeSeek(abfsInputStream);
        iStream.seek(seekPos);
        this.verifyAbsInputStreamStateAfterSeek(abfsInputStream, seekPos);
    }

    public void verifyAbfsInputStreamBaseStateBeforeSeek(AbfsInputStream abfsInputStream) {
        ((AbstractLongAssert)Assertions.assertThat((long)abfsInputStream.getFCursor()).describedAs("FCursor should be 0 at the inputStream open", new Object[0])).isEqualTo(0L);
        ((AbstractLongAssert)Assertions.assertThat((long)abfsInputStream.getFCursorAfterLastRead()).describedAs("FCursorAfterLastRead should be -1 at the inputStream open", new Object[0])).isEqualTo(-1L);
        ((AbstractLongAssert)Assertions.assertThat((long)abfsInputStream.getLimit()).describedAs("Limit should be 0 at the inputStream open", new Object[0])).isEqualTo(0L);
        ((AbstractIntegerAssert)Assertions.assertThat((int)abfsInputStream.getBCursor()).describedAs("BCursor should be 0 at the inputStream open", new Object[0])).isEqualTo(0);
    }

    public void verifyAbsInputStreamStateAfterSeek(AbfsInputStream abfsInputStream, long seekPos) throws IOException {
        ((AbstractLongAssert)Assertions.assertThat((long)abfsInputStream.getPos()).describedAs("InputStream's pos should be " + seekPos + " after seek", new Object[0])).isEqualTo(seekPos);
        ((AbstractLongAssert)Assertions.assertThat((long)abfsInputStream.getFCursorAfterLastRead()).describedAs("FCursorAfterLastRead should be -1 after seek", new Object[0])).isEqualTo(-1L);
        ((AbstractLongAssert)Assertions.assertThat((long)abfsInputStream.getLimit()).describedAs("Limit should be 0 after seek", new Object[0])).isEqualTo(0L);
        ((AbstractIntegerAssert)Assertions.assertThat((int)abfsInputStream.getBCursor()).describedAs("BCursor should be 0 after seek", new Object[0])).isEqualTo(0);
    }
}

