/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.diagnostics;

import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidConfigurationValueException;
import org.apache.hadoop.fs.azurebfs.diagnostics.Base64StringConfigurationBasicValidator;
import org.apache.hadoop.fs.azurebfs.diagnostics.BooleanConfigurationBasicValidator;
import org.apache.hadoop.fs.azurebfs.diagnostics.IntegerConfigurationBasicValidator;
import org.apache.hadoop.fs.azurebfs.diagnostics.LongConfigurationBasicValidator;
import org.apache.hadoop.fs.azurebfs.diagnostics.StringConfigurationBasicValidator;
import org.apache.hadoop.fs.azurebfs.utils.Base64;
import org.junit.Assert;
import org.junit.Test;

public class TestConfigurationValidators
extends Assert {
    private static final String FAKE_KEY = "FakeKey";

    @Test
    public void testIntegerConfigValidator() throws Exception {
        IntegerConfigurationBasicValidator integerConfigurationValidator = new IntegerConfigurationBasicValidator(16384, 0x6400000, 0x400000, FAKE_KEY, false);
        TestConfigurationValidators.assertEquals((long)16384L, (long)integerConfigurationValidator.validate("3072").intValue());
        TestConfigurationValidators.assertEquals((long)0x400000L, (long)integerConfigurationValidator.validate(null).intValue());
        TestConfigurationValidators.assertEquals((long)0x6400000L, (long)integerConfigurationValidator.validate("104857600").intValue());
    }

    @Test(expected=InvalidConfigurationValueException.class)
    public void testIntegerConfigValidatorThrowsIfMissingValidValue() throws Exception {
        IntegerConfigurationBasicValidator integerConfigurationValidator = new IntegerConfigurationBasicValidator(16384, 0x6400000, 0x400000, FAKE_KEY, true);
        integerConfigurationValidator.validate("3072");
    }

    @Test
    public void testIntegerWithOutlierConfigValidator() throws Exception {
        IntegerConfigurationBasicValidator integerConfigurationValidator = new IntegerConfigurationBasicValidator(-1, 15, 60, -1, FAKE_KEY, false);
        TestConfigurationValidators.assertEquals((long)-1L, (long)integerConfigurationValidator.validate("-1").intValue());
        TestConfigurationValidators.assertEquals((long)-1L, (long)integerConfigurationValidator.validate(null).intValue());
        TestConfigurationValidators.assertEquals((long)15L, (long)integerConfigurationValidator.validate("15").intValue());
        TestConfigurationValidators.assertEquals((long)60L, (long)integerConfigurationValidator.validate("60").intValue());
    }

    @Test(expected=InvalidConfigurationValueException.class)
    public void testIntegerWithOutlierConfigValidatorThrowsIfMissingValidValue() throws Exception {
        IntegerConfigurationBasicValidator integerConfigurationValidator = new IntegerConfigurationBasicValidator(-1, 15, 60, -1, FAKE_KEY, true);
        integerConfigurationValidator.validate("14");
    }

    @Test
    public void testLongConfigValidator() throws Exception {
        LongConfigurationBasicValidator longConfigurationValidator = new LongConfigurationBasicValidator(16384L, 0x6400000L, 0x800000L, FAKE_KEY, false);
        TestConfigurationValidators.assertEquals((long)0x800000L, (long)longConfigurationValidator.validate(null));
        TestConfigurationValidators.assertEquals((long)16384L, (long)longConfigurationValidator.validate("3072"));
        TestConfigurationValidators.assertEquals((long)0x6400000L, (long)longConfigurationValidator.validate("104857600"));
    }

    @Test(expected=InvalidConfigurationValueException.class)
    public void testLongConfigValidatorThrowsIfMissingValidValue() throws Exception {
        LongConfigurationBasicValidator longConfigurationValidator = new LongConfigurationBasicValidator(16384L, 0x6400000L, 0x400000L, FAKE_KEY, true);
        longConfigurationValidator.validate(null);
    }

    @Test
    public void testBooleanConfigValidator() throws Exception {
        BooleanConfigurationBasicValidator booleanConfigurationValidator = new BooleanConfigurationBasicValidator(FAKE_KEY, false, false);
        TestConfigurationValidators.assertEquals((Object)true, (Object)booleanConfigurationValidator.validate("true"));
        TestConfigurationValidators.assertEquals((Object)false, (Object)booleanConfigurationValidator.validate("False"));
        TestConfigurationValidators.assertEquals((Object)false, (Object)booleanConfigurationValidator.validate(null));
    }

    @Test(expected=InvalidConfigurationValueException.class)
    public void testBooleanConfigValidatorThrowsIfMissingValidValue() throws Exception {
        BooleanConfigurationBasicValidator booleanConfigurationValidator = new BooleanConfigurationBasicValidator(FAKE_KEY, false, true);
        booleanConfigurationValidator.validate("almostTrue");
    }

    @Test
    public void testStringConfigValidator() throws Exception {
        StringConfigurationBasicValidator stringConfigurationValidator = new StringConfigurationBasicValidator(FAKE_KEY, "value", false);
        TestConfigurationValidators.assertEquals((Object)"value", (Object)stringConfigurationValidator.validate(null));
        TestConfigurationValidators.assertEquals((Object)"someValue", (Object)stringConfigurationValidator.validate("someValue"));
    }

    @Test(expected=InvalidConfigurationValueException.class)
    public void testStringConfigValidatorThrowsIfMissingValidValue() throws Exception {
        StringConfigurationBasicValidator stringConfigurationValidator = new StringConfigurationBasicValidator(FAKE_KEY, "value", true);
        stringConfigurationValidator.validate(null);
    }

    @Test
    public void testBase64StringConfigValidator() throws Exception {
        String encodedVal = Base64.encode((byte[])"someValue".getBytes());
        Base64StringConfigurationBasicValidator base64StringConfigurationValidator = new Base64StringConfigurationBasicValidator(FAKE_KEY, "", false);
        TestConfigurationValidators.assertEquals((Object)"", (Object)base64StringConfigurationValidator.validate(null));
        TestConfigurationValidators.assertEquals((Object)encodedVal, (Object)base64StringConfigurationValidator.validate(encodedVal));
    }

    @Test(expected=InvalidConfigurationValueException.class)
    public void testBase64StringConfigValidatorThrowsIfMissingValidValue() throws Exception {
        Base64StringConfigurationBasicValidator base64StringConfigurationValidator = new Base64StringConfigurationBasicValidator(FAKE_KEY, "value", true);
        base64StringConfigurationValidator.validate("some&%Value");
    }
}

