/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ITestAzureBlobFileSystemStoreListStatusWithRange
extends AbstractAbfsIntegrationTest {
    private static final boolean SUCCEED = true;
    private static final boolean FAIL = false;
    private static final String[] SORTED_ENTRY_NAMES = new String[]{"1_folder", "A0", "D01", "a+", "c0", "name5"};
    private AzureBlobFileSystemStore store;
    private AzureBlobFileSystem fs;
    @Parameterized.Parameter
    public String path;
    @Parameterized.Parameter(value=1)
    public String startFrom;
    @Parameterized.Parameter(value=2)
    public int expectedStartIndexInArray;
    @Parameterized.Parameter(value=3)
    public boolean expectedResult;

    @Parameterized.Parameters(name="Testing path \"{0}\", startFrom: \"{1}\",  Expecting result : {3}")
    public static Iterable<Object[]> params() {
        return Arrays.asList({"/", null, 0, true}, {"/", SORTED_ENTRY_NAMES[1], 1, true}, {"/", "/", -1, false}, {"/" + SORTED_ENTRY_NAMES[2], SORTED_ENTRY_NAMES[1], 1, true}, {"/" + SORTED_ENTRY_NAMES[2], SORTED_ENTRY_NAMES[2], 2, true}, {"/" + SORTED_ENTRY_NAMES[2], "/" + SORTED_ENTRY_NAMES[3], -1, false}, {"/" + SORTED_ENTRY_NAMES[2], "0-non-existent", 0, true}, {"/" + SORTED_ENTRY_NAMES[2], "z-non-existent", -1, true}, {"/" + SORTED_ENTRY_NAMES[2], "A1", 2, true});
    }

    public ITestAzureBlobFileSystemStoreListStatusWithRange() throws Exception {
        if (this.getFileSystem() == null) {
        }
        this.fs = this.getFileSystem();
        this.store = this.fs.getAbfsStore();
        this.prepareTestFiles();
        Arrays.sort(SORTED_ENTRY_NAMES);
    }

    @Test
    public void testListWithRange() throws IOException {
        block3: {
            try {
                FileStatus[] listResult = this.store.listStatus(new Path(this.path), this.startFrom, this.getTestTracingContext(this.fs, true));
                if (!this.expectedResult) {
                    Assert.fail((String)"Excepting failure with IllegalArgumentException");
                }
                this.verifyFileStatus(listResult, new Path(this.path), this.expectedStartIndexInArray);
            }
            catch (IllegalArgumentException ex) {
                if (!this.expectedResult) break block3;
                Assert.fail((String)"Excepting success");
            }
        }
    }

    private void verifyFileStatus(FileStatus[] listResult, Path parentPath, int startIndexInSortedName) throws IOException {
        if (startIndexInSortedName == -1) {
            Assert.assertEquals((String)"Expected empty FileStatus array", (long)0L, (long)listResult.length);
            return;
        }
        FileStatus[] allFileStatuses = this.fs.listStatus(parentPath);
        Assert.assertEquals((String)"number of dir/file doesn't match", (long)SORTED_ENTRY_NAMES.length, (long)allFileStatuses.length);
        int indexInResult = 0;
        for (int index = startIndexInSortedName; index < SORTED_ENTRY_NAMES.length; ++index) {
            Assert.assertEquals((String)"fileStatus doesn't match", (Object)allFileStatuses[index], (Object)listResult[indexInResult++]);
        }
    }

    private void prepareTestFiles() throws IOException {
        AzureBlobFileSystem fs = this.getFileSystem();
        for (String levelOneFolder : SORTED_ENTRY_NAMES) {
            Path levelOnePath = new Path("/" + levelOneFolder);
            Assert.assertTrue((boolean)fs.mkdirs(levelOnePath));
            for (String fileName : SORTED_ENTRY_NAMES) {
                Path filePath = new Path(levelOnePath, fileName);
                ContractTestUtils.touch((FileSystem)fs, (Path)filePath);
                ContractTestUtils.assertIsFile((FileSystem)fs, (Path)filePath);
            }
        }
    }
}

