/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.utils.Listener;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderValidator;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ITestAzureBlobFileSystemAttributes
extends AbstractAbfsIntegrationTest {
    private static final EnumSet<XAttrSetFlag> CREATE_FLAG = EnumSet.of(XAttrSetFlag.CREATE);
    private static final EnumSet<XAttrSetFlag> REPLACE_FLAG = EnumSet.of(XAttrSetFlag.REPLACE);

    @Test
    public void testSetGetXAttr() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testPath = this.path(this.getMethodName());
        fs.create(testPath);
        this.testGetSetXAttrHelper(fs, testPath);
    }

    @Test
    public void testSetGetXAttrCreateReplace() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        byte[] attributeValue = fs.getAbfsStore().encodeAttribute("one");
        String attributeName = "user.someAttribute";
        Path testFile = this.path(this.getMethodName());
        this.touch(testFile);
        fs.setXAttr(testFile, attributeName, attributeValue, CREATE_FLAG);
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])fs.getXAttr(testFile, attributeName)).describedAs("Retrieved Attribute Value is Not as Expected", new Object[0])).containsExactly(attributeValue);
        LambdaTestUtils.intercept(IOException.class, () -> fs.setXAttr(testFile, attributeName, attributeValue, CREATE_FLAG));
    }

    @Test
    public void testSetGetXAttrReplace() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        byte[] attributeValue1 = fs.getAbfsStore().encodeAttribute("one");
        byte[] attributeValue2 = fs.getAbfsStore().encodeAttribute("two");
        String attributeName = "user.someAttribute";
        Path testFile = this.path(this.getMethodName());
        LambdaTestUtils.intercept(IOException.class, () -> {
            this.touch(testFile);
            fs.setXAttr(testFile, attributeName, attributeValue1, REPLACE_FLAG);
        });
        fs.setXAttr(testFile, attributeName, attributeValue1, CREATE_FLAG);
        fs.setXAttr(testFile, attributeName, attributeValue2, REPLACE_FLAG);
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])fs.getXAttr(testFile, attributeName)).describedAs("Retrieved Attribute Value is Not as Expected", new Object[0])).containsExactly(attributeValue2);
    }

    private void testGetSetXAttrHelper(AzureBlobFileSystem fs, Path testPath) throws Exception {
        String attributeName1 = "user.attribute1";
        String attributeName2 = "user.attribute2";
        String decodedAttributeValue1 = "hi";
        String decodedAttributeValue2 = "hello";
        byte[] attributeValue1 = fs.getAbfsStore().encodeAttribute(decodedAttributeValue1);
        byte[] attributeValue2 = fs.getAbfsStore().encodeAttribute(decodedAttributeValue2);
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])fs.getXAttr(testPath, attributeName1)).describedAs("Cannot get attribute before setting it", new Object[0])).isNull();
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])fs.getXAttr(testPath, attributeName2)).describedAs("Cannot get attribute before setting it", new Object[0])).isNull();
        fs.registerListener((Listener)new TracingHeaderValidator(fs.getAbfsStore().getAbfsConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.SET_ATTR, true, 0));
        fs.setXAttr(testPath, attributeName1, attributeValue1);
        fs.setListenerOperation(FSOperationType.GET_ATTR);
        byte[] rv = fs.getXAttr(testPath, attributeName1);
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])rv).describedAs("Retrieved Attribute Does not Matches in Encoded Form", new Object[0])).containsExactly(attributeValue1);
        ((AbstractStringAssert)Assertions.assertThat((String)fs.getAbfsStore().decodeAttribute(rv)).describedAs("Retrieved Attribute Does not Matches in Decoded Form", new Object[0])).isEqualTo((Object)decodedAttributeValue1);
        fs.registerListener(null);
        fs.setXAttr(testPath, attributeName2, attributeValue2);
        rv = fs.getXAttr(testPath, attributeName1);
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])rv).describedAs("Retrieved Attribute Does not Matches in Encoded Form", new Object[0])).containsExactly(attributeValue1);
        ((AbstractStringAssert)Assertions.assertThat((String)fs.getAbfsStore().decodeAttribute(rv)).describedAs("Retrieved Attribute Does not Matches in Decoded Form", new Object[0])).isEqualTo((Object)decodedAttributeValue1);
        rv = fs.getXAttr(testPath, attributeName2);
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])rv).describedAs("Retrieved Attribute Does not Matches in Encoded Form", new Object[0])).containsExactly(attributeValue2);
        ((AbstractStringAssert)Assertions.assertThat((String)fs.getAbfsStore().decodeAttribute(rv)).describedAs("Retrieved Attribute Does not Matches in Decoded Form", new Object[0])).isEqualTo((Object)decodedAttributeValue2);
    }

    @Test
    public void testGetSetXAttrOnRoot() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        String attributeName = "user.attribute1";
        byte[] attributeValue = fs.getAbfsStore().encodeAttribute("hi");
        Path testPath = new Path("/");
        AbfsRestOperationException ex = (AbfsRestOperationException)LambdaTestUtils.intercept(AbfsRestOperationException.class, () -> fs.getXAttr(testPath, attributeName));
        ((AbstractIntegerAssert)Assertions.assertThat((int)ex.getStatusCode()).describedAs("GetXAttr() on root should fail with Bad Request", new Object[0])).isEqualTo(400);
        ex = (AbfsRestOperationException)LambdaTestUtils.intercept(AbfsRestOperationException.class, () -> fs.setXAttr(testPath, attributeName, attributeValue, CREATE_FLAG));
        ((AbstractIntegerAssert)Assertions.assertThat((int)ex.getStatusCode()).describedAs("SetXAttr() on root should fail with Bad Request", new Object[0])).isEqualTo(400);
    }
}

