/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.utils.Listener;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderValidator;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.store.BlockUploadStatistics;
import org.apache.hadoop.fs.store.DataBlocks;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ITestAzureBlobFileSystemAppend
extends AbstractAbfsIntegrationTest {
    private static final String TEST_FILE_PATH = "testfile";
    private static final String TEST_FOLDER_PATH = "testFolder";

    @Test(expected=FileNotFoundException.class)
    public void testAppendDirShouldFail() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path filePath = this.path(TEST_FILE_PATH);
        fs.mkdirs(filePath);
        fs.append(filePath, 0).close();
    }

    @Test
    public void testAppendWithLength0() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        try (FSDataOutputStream stream = fs.create(this.path(TEST_FILE_PATH));){
            byte[] b = new byte[1024];
            new Random().nextBytes(b);
            stream.write(b, 1000, 0);
            ITestAzureBlobFileSystemAppend.assertEquals((long)0L, (long)stream.getPos());
        }
    }

    @Test(expected=FileNotFoundException.class)
    public void testAppendFileAfterDelete() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path filePath = this.path(TEST_FILE_PATH);
        ContractTestUtils.touch((FileSystem)fs, (Path)filePath);
        fs.delete(filePath, false);
        fs.append(filePath).close();
    }

    @Test(expected=FileNotFoundException.class)
    public void testAppendDirectory() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path folderPath = this.path(TEST_FOLDER_PATH);
        fs.mkdirs(folderPath);
        fs.append(folderPath).close();
    }

    @Test
    public void testTracingForAppend() throws IOException {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testPath = this.path(TEST_FILE_PATH);
        fs.create(testPath).close();
        fs.registerListener((Listener)new TracingHeaderValidator(fs.getAbfsStore().getAbfsConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.APPEND, false, 0));
        fs.append(testPath, 10);
    }

    @Test
    public void testCloseOfDataBlockOnAppendComplete() throws Exception {
        HashSet<String> blockBufferTypes = new HashSet<String>();
        blockBufferTypes.add("disk");
        blockBufferTypes.add("bytebuffer");
        blockBufferTypes.add("array");
        for (String blockBufferType : blockBufferTypes) {
            Configuration configuration = new Configuration(this.getRawConfiguration());
            configuration.set("fs.azure.data.blocks.buffer", blockBufferType);
            AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)((AzureBlobFileSystem)FileSystem.newInstance((Configuration)configuration)));
            AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
            ((AzureBlobFileSystem)Mockito.doReturn((Object)store).when((Object)fs)).getAbfsStore();
            DataBlocks.DataBlock[] dataBlock = new DataBlocks.DataBlock[1];
            ((AzureBlobFileSystemStore)Mockito.doAnswer(getBlobFactoryInvocation -> {
                DataBlocks.BlockFactory factory = (DataBlocks.BlockFactory)Mockito.spy((Object)((DataBlocks.BlockFactory)getBlobFactoryInvocation.callRealMethod()));
                ((DataBlocks.BlockFactory)Mockito.doAnswer(factoryCreateInvocation -> {
                    dataBlock[0] = (DataBlocks.DataBlock)Mockito.spy((Object)((DataBlocks.DataBlock)factoryCreateInvocation.callRealMethod()));
                    return dataBlock[0];
                }).when((Object)factory)).create(Mockito.anyLong(), Mockito.anyInt(), (BlockUploadStatistics)Mockito.any(BlockUploadStatistics.class));
                return factory;
            }).when((Object)store)).getBlockFactory();
            FSDataOutputStream os = fs.create(new Path(this.getMethodName() + "_" + blockBufferType));
            try {
                os.write(new byte[1]);
                ((AbstractComparableAssert)Assertions.assertThat((Comparable)dataBlock[0].getState()).describedAs("On write of data in outputStream, state should become Writing", new Object[0])).isEqualTo((Object)DataBlocks.DataBlock.DestState.Writing);
                os.close();
                ((DataBlocks.DataBlock)Mockito.verify((Object)dataBlock[0], (VerificationMode)Mockito.times((int)1))).close();
                ((AbstractComparableAssert)Assertions.assertThat((Comparable)dataBlock[0].getState()).describedAs("On close of outputStream, state should become Closed", new Object[0])).isEqualTo((Object)DataBlocks.DataBlock.DestState.Closed);
            }
            finally {
                if (os == null) continue;
                os.close();
            }
        }
    }
}

