/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsScaleTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.constants.HttpOperationType;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStream;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStream;
import org.apache.hadoop.fs.azurebfs.utils.Listener;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderValidator;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;

@RunWith(value=Parameterized.class)
public class ITestAbfsReadWriteAndSeek
extends AbstractAbfsScaleTest {
    private static final String TEST_PATH = "/testfile";
    private final int size;
    private final boolean readaheadEnabled;
    private final HttpOperationType httpOperationType;

    @Parameterized.Parameters(name="Size={0}-readahead={1}-Client={2}")
    public static Iterable<Object[]> sizes() {
        return Arrays.asList({16384, true, HttpOperationType.JDK_HTTP_URL_CONNECTION}, {16384, true, HttpOperationType.APACHE_HTTP_CLIENT}, {0x400000, false, HttpOperationType.JDK_HTTP_URL_CONNECTION}, {0x400000, false, HttpOperationType.APACHE_HTTP_CLIENT}, {0x400000, true, HttpOperationType.JDK_HTTP_URL_CONNECTION}, {0x400000, true, HttpOperationType.APACHE_HTTP_CLIENT}, {0x400000, false, HttpOperationType.JDK_HTTP_URL_CONNECTION}, {0x400000, false, HttpOperationType.APACHE_HTTP_CLIENT}, {0x6400000, true, HttpOperationType.JDK_HTTP_URL_CONNECTION}, {0x6400000, true, HttpOperationType.APACHE_HTTP_CLIENT});
    }

    public ITestAbfsReadWriteAndSeek(int size, boolean readaheadEnabled, HttpOperationType httpOperationType) throws Exception {
        this.size = size;
        this.readaheadEnabled = readaheadEnabled;
        this.httpOperationType = httpOperationType;
    }

    @Test
    public void testReadAndWriteWithDifferentBufferSizesAndSeek() throws Exception {
        this.testReadWriteAndSeek(this.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testReadWriteAndSeek(int bufferSize) throws Exception {
        int result;
        AzureBlobFileSystem fs = this.getFileSystem();
        AbfsConfiguration abfsConfiguration = fs.getAbfsStore().getAbfsConfiguration();
        abfsConfiguration.setWriteBufferSize(bufferSize);
        abfsConfiguration.setReadBufferSize(bufferSize);
        abfsConfiguration.setReadAheadEnabled(this.readaheadEnabled);
        abfsConfiguration.setOptimizeFooterRead(false);
        byte[] b = new byte[2 * bufferSize];
        new Random().nextBytes(b);
        Path testPath = this.path(TEST_PATH);
        try (FSDataOutputStream stream = fs.create(testPath);){
            stream.write(b);
        }
        IOStatisticsLogging.logIOStatisticsAtLevel((Logger)LOG, (String)"info", (Object)stream);
        byte[] readBuffer = new byte[2 * bufferSize];
        FSDataInputStream statisticsSource = null;
        try (FSDataInputStream inputStream = fs.open(testPath);){
            statisticsSource = inputStream;
            ((AbfsInputStream)inputStream.getWrappedStream()).registerListener((Listener)new TracingHeaderValidator(abfsConfiguration.getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.READ, true, 0, ((AbfsInputStream)inputStream.getWrappedStream()).getStreamID()));
            inputStream.seek((long)bufferSize);
            result = inputStream.read(readBuffer, bufferSize, bufferSize);
            ITestAbfsReadWriteAndSeek.assertNotEquals((long)-1L, (long)result);
            inputStream.seek(0L);
            byte[] temp = new byte[5];
            int t = inputStream.read(temp, 0, 1);
            inputStream.seek(0L);
            result = inputStream.read(readBuffer, 0, bufferSize);
        }
        IOStatisticsLogging.logIOStatisticsAtLevel((Logger)LOG, (String)"info", (Object)statisticsSource);
        ITestAbfsReadWriteAndSeek.assertNotEquals((String)"data read in final read()", (long)-1L, (long)result);
        ITestAbfsReadWriteAndSeek.assertArrayEquals((byte[])readBuffer, (byte[])b);
    }

    @Test
    public void testReadAheadRequestID() throws IOException {
        AzureBlobFileSystem fs = this.getFileSystem();
        AbfsConfiguration abfsConfiguration = fs.getAbfsStore().getAbfsConfiguration();
        int bufferSize = 16384;
        abfsConfiguration.setReadBufferSize(bufferSize);
        abfsConfiguration.setReadAheadEnabled(this.readaheadEnabled);
        byte[] b = new byte[bufferSize * 10];
        new Random().nextBytes(b);
        Path testPath = this.path(TEST_PATH);
        try (FSDataOutputStream stream = fs.create(testPath);){
            ((AbfsOutputStream)stream.getWrappedStream()).registerListener((Listener)new TracingHeaderValidator(abfsConfiguration.getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.WRITE, false, 0, ((AbfsOutputStream)stream.getWrappedStream()).getStreamID()));
            stream.write(b);
            IOStatisticsLogging.logIOStatisticsAtLevel((Logger)LOG, (String)"info", (Object)stream);
        }
        byte[] readBuffer = new byte[4 * bufferSize];
        fs.registerListener((Listener)new TracingHeaderValidator(abfsConfiguration.getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.OPEN, false, 0));
        try (FSDataInputStream inputStream = fs.open(testPath);){
            ((AbfsInputStream)inputStream.getWrappedStream()).registerListener((Listener)new TracingHeaderValidator(abfsConfiguration.getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.READ, false, 0, ((AbfsInputStream)inputStream.getWrappedStream()).getStreamID()));
            int result = inputStream.read(readBuffer, 0, bufferSize * 4);
            IOStatisticsLogging.logIOStatisticsAtLevel((Logger)LOG, (String)"info", (Object)inputStream);
        }
        fs.registerListener(null);
    }
}

