/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.junit.Test;

public class ITestABFSJceksFiltering
extends AbstractAbfsIntegrationTest {
    @Test
    public void testIncompatibleCredentialProviderIsExcluded() throws Exception {
        Configuration rawConfig = this.getRawConfiguration();
        rawConfig.set("hadoop.security.credential.provider.path", "jceks://abfs@a@b.c.d/tmp/a.jceks,jceks://file/tmp/secret.jceks");
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.get((Configuration)rawConfig);){
            ITestABFSJceksFiltering.assertNotNull((String)"filesystem", (Object)fs);
            String providers = fs.getConf().get("hadoop.security.credential.provider.path");
            ITestABFSJceksFiltering.assertEquals((Object)"jceks://file/tmp/secret.jceks", (Object)providers);
        }
    }
}

