/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.utils;

import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import org.apache.hadoop.fs.azurebfs.utils.CachedSASToken;
import org.junit.Assert;
import org.junit.Test;

public final class TestCachedSASToken {
    @Test
    public void testUpdateAndGet() throws IOException {
        CachedSASToken cachedSasToken = new CachedSASToken();
        String se1 = OffsetDateTime.now(ZoneOffset.UTC).plus(240L, ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_DATE_TIME);
        String token1 = "se=" + se1;
        cachedSasToken.update(token1);
        String cachedToken = cachedSasToken.get();
        Assert.assertTrue((token1 == cachedToken ? 1 : 0) != 0);
        cachedSasToken.update(token1);
        cachedToken = cachedSasToken.get();
        Assert.assertTrue((token1 == cachedToken ? 1 : 0) != 0);
        String se2 = OffsetDateTime.now(ZoneOffset.UTC).plus(240L, ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_DATE_TIME);
        String token2 = "se=" + se2;
        cachedSasToken.update(token2);
        cachedToken = cachedSasToken.get();
        Assert.assertTrue((token2 == cachedToken ? 1 : 0) != 0);
        String se3 = OffsetDateTime.now(ZoneOffset.UTC).plus(480L, ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_DATE_TIME);
        String ske3 = OffsetDateTime.now(ZoneOffset.UTC).plus(240L, ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_DATE_TIME);
        String token3 = "se=" + se3 + "&ske=" + ske3;
        cachedSasToken.update(token3);
        cachedToken = cachedSasToken.get();
        Assert.assertTrue((token3 == cachedToken ? 1 : 0) != 0);
    }

    @Test
    public void testGetExpiration() throws IOException {
        CachedSASToken cachedSasToken = new CachedSASToken();
        String se = OffsetDateTime.now(ZoneOffset.UTC).plus(119L, ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_DATE_TIME);
        OffsetDateTime seDate = OffsetDateTime.parse(se, DateTimeFormatter.ISO_DATE_TIME);
        String token = "se=" + se;
        cachedSasToken.setForTesting(token, seDate);
        String cachedToken = cachedSasToken.get();
        Assert.assertNull((Object)cachedToken);
    }

    @Test
    public void testUpdateAndGetWithExpiredToken() throws IOException {
        CachedSASToken cachedSasToken = new CachedSASToken();
        String se1 = OffsetDateTime.now(ZoneOffset.UTC).plus(119L, ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_DATE_TIME);
        String token1 = "se=" + se1;
        cachedSasToken.update(token1);
        String cachedToken = cachedSasToken.get();
        Assert.assertNull((Object)cachedToken);
        String se2 = OffsetDateTime.now(ZoneOffset.UTC).plus(240L, ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_DATE_TIME);
        String ske2 = OffsetDateTime.now(ZoneOffset.UTC).plus(119L, ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_DATE_TIME);
        String token2 = "se=" + se2 + "&ske=" + ske2;
        cachedSasToken.update(token2);
        cachedToken = cachedSasToken.get();
        Assert.assertNull((Object)cachedToken);
    }

    @Test
    public void testUpdateAndGetWithInvalidToken() throws IOException {
        CachedSASToken cachedSasToken = new CachedSASToken();
        String token1 = "se=";
        cachedSasToken.update(token1);
        String cachedToken = cachedSasToken.get();
        Assert.assertNull((Object)cachedToken);
        String token2 = "se=xyz";
        cachedSasToken.update(token2);
        cachedToken = cachedSasToken.get();
        Assert.assertNull((Object)cachedToken);
        String token3 = "se=2100-01-01T00:00:00Z&ske=";
        cachedSasToken.update(token3);
        cachedToken = cachedSasToken.get();
        Assert.assertNull((Object)cachedToken);
        String token4 = "se=2100-01-01T00:00:00Z&ske=xyz&";
        cachedSasToken.update(token4);
        cachedToken = cachedSasToken.get();
        Assert.assertNull((Object)cachedToken);
        String token5 = "se=abc&ske=xyz&";
        cachedSasToken.update(token5);
        cachedToken = cachedSasToken.get();
        Assert.assertNull((Object)cachedToken);
    }

    public static CachedSASToken getTestCachedSASTokenInstance() {
        String expiryPostADay = OffsetDateTime.now(ZoneOffset.UTC).plus(1L, ChronoUnit.DAYS).format(DateTimeFormatter.ISO_DATE_TIME);
        String version = "2020-20-20";
        StringBuilder sb = new StringBuilder();
        sb.append("skoid=");
        sb.append(UUID.randomUUID().toString());
        sb.append("&sktid=");
        sb.append(UUID.randomUUID().toString());
        sb.append("&skt=");
        sb.append(OffsetDateTime.now(ZoneOffset.UTC).minus(1L, ChronoUnit.DAYS).format(DateTimeFormatter.ISO_DATE_TIME));
        sb.append("&ske=");
        sb.append(expiryPostADay);
        sb.append("&sks=b");
        sb.append("&skv=");
        sb.append(version);
        sb.append("&sp=rw");
        sb.append("&sr=b");
        sb.append("&se=");
        sb.append(expiryPostADay);
        sb.append("&sv=2");
        sb.append(version);
        CachedSASToken cachedSASToken = new CachedSASToken();
        cachedSASToken.update(sb.toString());
        return cachedSASToken;
    }
}

