/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.FileNotFoundException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.TrileanConversionException;
import org.apache.hadoop.fs.azurebfs.enums.Trilean;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ITestAzureBlobFileSystemInitAndCreate
extends AbstractAbfsIntegrationTest {
    public ITestAzureBlobFileSystemInitAndCreate() throws Exception {
        this.getConfiguration().unset("fs.azure.createRemoteFileSystemDuringInitialization");
    }

    @Override
    public void setup() {
    }

    @Override
    public void teardown() {
    }

    @Test(expected=FileNotFoundException.class)
    public void ensureFilesystemWillNotBeCreatedIfCreationConfigIsNotSet() throws Exception {
        AzureBlobFileSystem fs = this.createFileSystem();
        FileStatus[] fileStatuses = fs.listStatus(new Path("/"));
    }

    @Test
    public void testGetAclCallOnHnsConfigAbsence() throws Exception {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)this.getRawConfiguration());
        AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
        AbfsClient client = (AbfsClient)Mockito.spy((Object)fs.getAbfsClient());
        ((AzureBlobFileSystemStore)Mockito.doReturn((Object)client).when((Object)store)).getClient();
        ((AzureBlobFileSystemStore)Mockito.doThrow(TrileanConversionException.class).when((Object)store)).isNamespaceEnabled();
        store.setNamespaceEnabled(Trilean.UNKNOWN);
        TracingContext tracingContext = ITestAzureBlobFileSystemInitAndCreate.getSampleTracingContext(fs, true);
        ((AbfsClient)Mockito.doReturn((Object)Mockito.mock(AbfsRestOperation.class)).when((Object)client)).getAclStatus(Mockito.anyString(), (TracingContext)Mockito.any(TracingContext.class));
        store.getIsNamespaceEnabled(tracingContext);
        ((AbfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).getAclStatus(Mockito.anyString(), (TracingContext)Mockito.any(TracingContext.class));
    }

    @Test
    public void testNoGetAclCallOnHnsConfigPresence() throws Exception {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)this.getRawConfiguration());
        AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
        AbfsClient client = (AbfsClient)Mockito.spy((Object)fs.getAbfsClient());
        ((AzureBlobFileSystemStore)Mockito.doReturn((Object)client).when((Object)store)).getClient();
        ((AzureBlobFileSystemStore)Mockito.doReturn((Object)true).when((Object)store)).isNamespaceEnabled();
        TracingContext tracingContext = ITestAzureBlobFileSystemInitAndCreate.getSampleTracingContext(fs, true);
        store.getIsNamespaceEnabled(tracingContext);
        ((AbfsClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)0))).getAclStatus(Mockito.anyString(), (TracingContext)Mockito.any(TracingContext.class));
    }
}

