/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import org.apache.hadoop.fs.azurebfs.contracts.exceptions.TrileanConversionException;
import org.apache.hadoop.fs.azurebfs.enums.Trilean;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TrileanTests {
    private static final String TRUE_STR = "true";
    private static final String FALSE_STR = "false";

    @Test
    public void testGetTrileanForBoolean() {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)Trilean.getTrilean((boolean)true)).describedAs("getTrilean should return Trilean.TRUE when true is passed", new Object[0])).isEqualTo((Object)Trilean.TRUE);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)Trilean.getTrilean((boolean)false)).describedAs("getTrilean should return Trilean.FALSE when false is passed", new Object[0])).isEqualTo((Object)Trilean.FALSE);
    }

    @Test
    public void testGetTrileanForString() {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)Trilean.getTrilean((String)TRUE_STR.toLowerCase())).describedAs("getTrilean should return Trilean.TRUE when true is passed", new Object[0])).isEqualTo((Object)Trilean.TRUE);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)Trilean.getTrilean((String)TRUE_STR.toUpperCase())).describedAs("getTrilean should return Trilean.TRUE when TRUE is passed", new Object[0])).isEqualTo((Object)Trilean.TRUE);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)Trilean.getTrilean((String)FALSE_STR.toLowerCase())).describedAs("getTrilean should return Trilean.FALSE when false is passed", new Object[0])).isEqualTo((Object)Trilean.FALSE);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)Trilean.getTrilean((String)FALSE_STR.toUpperCase())).describedAs("getTrilean should return Trilean.FALSE when FALSE is passed", new Object[0])).isEqualTo((Object)Trilean.FALSE);
        this.testInvalidString(null);
        this.testInvalidString(" ");
        this.testInvalidString("invalid");
        this.testInvalidString("truee");
        this.testInvalidString("falsee");
    }

    private void testInvalidString(String invalidString) {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)Trilean.getTrilean((String)invalidString)).describedAs("getTrilean should return Trilean.UNKNOWN for anything not true/false", new Object[0])).isEqualTo((Object)Trilean.UNKNOWN);
    }

    @Test
    public void testToBoolean() throws TrileanConversionException {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)Trilean.TRUE.toBoolean()).describedAs("toBoolean should return true for Trilean.TRUE", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)Trilean.FALSE.toBoolean()).describedAs("toBoolean should return false for Trilean.FALSE", new Object[0])).isFalse();
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Trilean.UNKNOWN.toBoolean())).describedAs("toBoolean on Trilean.UNKNOWN results in TrileanConversionException", new Object[0])).isInstanceOf(TrileanConversionException.class)).describedAs("Exception message should be: catchThrowable(()->Trilean.UNKNOWN.toBoolean())", new Object[0])).hasMessage("Cannot convert Trilean.UNKNOWN to boolean");
    }
}

