/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.utils.Listener;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderValidator;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assume;
import org.junit.Test;

public class ITestAzureBlobFileSystemAttributes
extends AbstractAbfsIntegrationTest {
    private static final EnumSet<XAttrSetFlag> CREATE_FLAG = EnumSet.of(XAttrSetFlag.CREATE);
    private static final EnumSet<XAttrSetFlag> REPLACE_FLAG = EnumSet.of(XAttrSetFlag.REPLACE);

    @Test
    public void testSetGetXAttr() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        AbfsConfiguration conf = fs.getAbfsStore().getAbfsConfiguration();
        Assume.assumeTrue((boolean)this.getIsNamespaceEnabled(fs));
        byte[] attributeValue1 = fs.getAbfsStore().encodeAttribute("hi");
        byte[] attributeValue2 = fs.getAbfsStore().encodeAttribute("\u4f60\u597d");
        String attributeName1 = "user.asciiAttribute";
        String attributeName2 = "user.unicodeAttribute";
        Path testFile = this.path("setGetXAttr");
        this.touch(testFile);
        ITestAzureBlobFileSystemAttributes.assertNull((Object)fs.getXAttr(testFile, attributeName1));
        fs.registerListener((Listener)new TracingHeaderValidator(conf.getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.SET_ATTR, true, 0));
        fs.setXAttr(testFile, attributeName1, attributeValue1);
        fs.setListenerOperation(FSOperationType.GET_ATTR);
        ITestAzureBlobFileSystemAttributes.assertArrayEquals((byte[])attributeValue1, (byte[])fs.getXAttr(testFile, attributeName1));
        fs.registerListener(null);
        fs.setXAttr(testFile, attributeName2, attributeValue2);
        ITestAzureBlobFileSystemAttributes.assertArrayEquals((byte[])attributeValue1, (byte[])fs.getXAttr(testFile, attributeName1));
        ITestAzureBlobFileSystemAttributes.assertArrayEquals((byte[])attributeValue2, (byte[])fs.getXAttr(testFile, attributeName2));
    }

    @Test
    public void testSetGetXAttrCreateReplace() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)this.getIsNamespaceEnabled(fs));
        byte[] attributeValue = fs.getAbfsStore().encodeAttribute("one");
        String attributeName = "user.someAttribute";
        Path testFile = this.path("createReplaceXAttr");
        this.touch(testFile);
        fs.setXAttr(testFile, attributeName, attributeValue, CREATE_FLAG);
        ITestAzureBlobFileSystemAttributes.assertArrayEquals((byte[])attributeValue, (byte[])fs.getXAttr(testFile, attributeName));
        LambdaTestUtils.intercept(IOException.class, () -> fs.setXAttr(testFile, attributeName, attributeValue, CREATE_FLAG));
    }

    @Test
    public void testSetGetXAttrReplace() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)this.getIsNamespaceEnabled(fs));
        byte[] attributeValue1 = fs.getAbfsStore().encodeAttribute("one");
        byte[] attributeValue2 = fs.getAbfsStore().encodeAttribute("two");
        String attributeName = "user.someAttribute";
        Path testFile = this.path("replaceXAttr");
        LambdaTestUtils.intercept(IOException.class, () -> {
            this.touch(testFile);
            fs.setXAttr(testFile, attributeName, attributeValue1, REPLACE_FLAG);
        });
        fs.setXAttr(testFile, attributeName, attributeValue1, CREATE_FLAG);
        fs.setXAttr(testFile, attributeName, attributeValue2, REPLACE_FLAG);
        ITestAzureBlobFileSystemAttributes.assertArrayEquals((byte[])attributeValue2, (byte[])fs.getXAttr(testFile, attributeName));
    }
}

