/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.Closeable;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.io.IOUtils;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITestAbfsStreamStatistics
extends AbstractAbfsIntegrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(ITestAbfsStreamStatistics.class);
    private static final int LARGE_NUMBER_OF_OPS = 99;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbfsStreamOps() throws Exception {
        StringBuilder largeOperationsValidationString;
        FSDataInputStream inForLargeOperations;
        FSDataOutputStream outForLargeOperations;
        Path largeOperationsFile;
        AzureBlobFileSystem fs;
        block7: {
            this.describe("Test to see correct population of read and write operations in Abfs", new Object[0]);
            fs = this.getFileSystem();
            Path smallOperationsFile = this.path("testOneReadWriteOps");
            largeOperationsFile = this.path("testLargeReadWriteOps");
            FileSystem.Statistics statistics = fs.getFsStatistics();
            String testReadWriteOps = "test this";
            statistics.reset();
            this.assertReadWriteOps("write", 0L, statistics.getWriteOps());
            this.assertReadWriteOps("read", 0L, statistics.getReadOps());
            FSDataOutputStream outForOneOperation = null;
            FSDataInputStream inForOneOperation = null;
            try {
                outForOneOperation = fs.create(smallOperationsFile);
                statistics.reset();
                outForOneOperation.write(testReadWriteOps.getBytes());
                this.assertReadWriteOps("write", 1L, statistics.getWriteOps());
                outForOneOperation.hflush();
                inForOneOperation = fs.open(smallOperationsFile);
                statistics.reset();
                int result = inForOneOperation.read(testReadWriteOps.getBytes(), 0, testReadWriteOps.getBytes().length);
                LOG.info("Result of Read operation : {}", (Object)result);
                ITestAbfsStreamStatistics.assertTrue((String)String.format("The actual value of %d was not equal to the expected value of 2 or 3", statistics.getReadOps()), (statistics.getReadOps() == 2 || statistics.getReadOps() == 3 ? 1 : 0) != 0);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{inForOneOperation, outForOneOperation});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{inForOneOperation, outForOneOperation});
            ITestAbfsStreamStatistics.assertTrue((String)"Mismatch in content validation", (boolean)this.validateContent(fs, smallOperationsFile, testReadWriteOps.getBytes()));
            outForLargeOperations = null;
            inForLargeOperations = null;
            largeOperationsValidationString = new StringBuilder();
            try {
                int i;
                outForLargeOperations = fs.create(largeOperationsFile);
                statistics.reset();
                int largeValue = 99;
                for (i = 0; i < largeValue; ++i) {
                    outForLargeOperations.write(testReadWriteOps.getBytes());
                    largeOperationsValidationString.append(testReadWriteOps);
                }
                LOG.info("Number of bytes of Large data written: {}", (Object)largeOperationsValidationString.toString().getBytes().length);
                this.assertReadWriteOps("write", largeValue, statistics.getWriteOps());
                inForLargeOperations = fs.open(largeOperationsFile);
                for (i = 0; i < largeValue; ++i) {
                    inForLargeOperations.read(testReadWriteOps.getBytes(), 0, testReadWriteOps.getBytes().length);
                }
                if (fs.getAbfsStore().isAppendBlobKey(fs.makeQualified(largeOperationsFile).toString())) {
                    ITestAbfsStreamStatistics.assertTrue((String)String.format("The actual value of %d was not equal to the expected value", statistics.getReadOps()), (statistics.getReadOps() == largeValue + 3 || statistics.getReadOps() == largeValue + 4 ? 1 : 0) != 0);
                    break block7;
                }
                this.assertReadWriteOps("read", largeValue, statistics.getReadOps());
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{inForLargeOperations, outForLargeOperations});
                throw throwable;
            }
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{inForLargeOperations, outForLargeOperations});
        ITestAbfsStreamStatistics.assertTrue((String)"Mismatch in content validation", (boolean)this.validateContent(fs, largeOperationsFile, largeOperationsValidationString.toString().getBytes()));
    }

    private void assertReadWriteOps(String operation, long expectedValue, long actualValue) {
        ITestAbfsStreamStatistics.assertEquals((String)("Mismatch in " + operation + " operations"), (long)expectedValue, (long)actualValue);
    }
}

