/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;

public class ExceptionHandlingTestHelper {
    public static AzureBlobStorageTestAccount getPageBlobTestStorageAccount() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.azure.page.blob.dir", "/");
        conf.set("fs.azure.atomic.rename.dir", "/");
        return AzureBlobStorageTestAccount.create(conf);
    }

    public static void createEmptyFile(AzureBlobStorageTestAccount testAccount, Path testPath) throws Exception {
        NativeAzureFileSystem fs = testAccount.getFileSystem();
        FSDataOutputStream inputStream = fs.create(testPath);
        inputStream.close();
    }

    public static void createTestFolder(AzureBlobStorageTestAccount testAccount, Path testFolderPath) throws Exception {
        NativeAzureFileSystem fs = testAccount.getFileSystem();
        fs.mkdirs(testFolderPath);
        String testFolderFilePathBase = "test";
        for (int i = 0; i < 10; ++i) {
            Path p = new Path(testFolderPath.toString() + "/" + testFolderFilePathBase + i + ".dat");
            fs.create(p).close();
        }
    }
}

