/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.util.Random;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStreamStatisticsImpl;
import org.junit.Test;

public class TestAbfsOutputStreamStatistics
extends AbstractAbfsIntegrationTest {
    private static final int LOW_RANGE_FOR_RANDOM_VALUE = 49;
    private static final int HIGH_RANGE_FOR_RANDOM_VALUE = 9999;
    private static final int OPERATIONS = 10;

    @Test
    public void testAbfsOutputStreamBytesFailed() {
        this.describe("Testing number of bytes failed during upload in AbfsOutputSteam", new Object[0]);
        AbfsOutputStreamStatisticsImpl abfsOutputStreamStatistics = new AbfsOutputStreamStatisticsImpl();
        TestAbfsOutputStreamStatistics.assertEquals((String)"Mismatch in number of bytes failed to upload", (long)0L, (long)abfsOutputStreamStatistics.getBytesUploadFailed());
        int randomBytesFailed = new Random().nextInt(49);
        abfsOutputStreamStatistics.uploadFailed((long)randomBytesFailed);
        TestAbfsOutputStreamStatistics.assertEquals((String)"Mismatch in number of bytes failed to upload", (long)randomBytesFailed, (long)abfsOutputStreamStatistics.getBytesUploadFailed());
        abfsOutputStreamStatistics = new AbfsOutputStreamStatisticsImpl();
        int expectedBytesFailed = 0;
        for (int i = 0; i < 10; ++i) {
            randomBytesFailed = new Random().nextInt(9999);
            abfsOutputStreamStatistics.uploadFailed((long)randomBytesFailed);
            expectedBytesFailed += randomBytesFailed;
        }
        TestAbfsOutputStreamStatistics.assertEquals((String)"Mismatch in number of bytes failed to upload", (long)expectedBytesFailed, (long)abfsOutputStreamStatistics.getBytesUploadFailed());
    }

    @Test
    public void testAbfsOutputStreamTimeSpentOnWaitTask() {
        this.describe("Testing time Spent on waiting for task to be completed in AbfsOutputStream", new Object[0]);
        AbfsOutputStreamStatisticsImpl abfsOutputStreamStatistics = new AbfsOutputStreamStatisticsImpl();
        TestAbfsOutputStreamStatistics.assertEquals((String)"Mismatch in time spent on waiting for tasks to complete", (long)0L, (long)abfsOutputStreamStatistics.getTimeSpentOnTaskWait());
        abfsOutputStreamStatistics.timeSpentTaskWait();
        TestAbfsOutputStreamStatistics.assertEquals((String)"Mismatch in time spent on waiting for tasks to complete", (long)1L, (long)abfsOutputStreamStatistics.getTimeSpentOnTaskWait());
        abfsOutputStreamStatistics = new AbfsOutputStreamStatisticsImpl();
        for (int i = 0; i < 10; ++i) {
            abfsOutputStreamStatistics.timeSpentTaskWait();
        }
        TestAbfsOutputStreamStatistics.assertEquals((String)"Mismatch in time spent on waiting for tasks to complete", (long)10L, (long)abfsOutputStreamStatistics.getTimeSpentOnTaskWait());
    }

    @Test
    public void testAbfsOutputStreamQueueShrink() {
        this.describe("Testing queue shrink operations by AbfsOutputStream", new Object[0]);
        AbfsOutputStreamStatisticsImpl abfsOutputStreamStatistics = new AbfsOutputStreamStatisticsImpl();
        TestAbfsOutputStreamStatistics.assertEquals((String)"Mismatch in queue shrunk operations", (long)0L, (long)abfsOutputStreamStatistics.getQueueShrunkOps());
        abfsOutputStreamStatistics.queueShrunk();
        TestAbfsOutputStreamStatistics.assertEquals((String)"Mismatch in queue shrunk operations", (long)1L, (long)abfsOutputStreamStatistics.getQueueShrunkOps());
        abfsOutputStreamStatistics = new AbfsOutputStreamStatisticsImpl();
        int randomQueueValues = new Random().nextInt(9999);
        for (int i = 0; i < randomQueueValues * 10; ++i) {
            abfsOutputStreamStatistics.queueShrunk();
        }
        TestAbfsOutputStreamStatistics.assertEquals((String)"Mismatch in queue shrunk operations", (long)(randomQueueValues * 10), (long)abfsOutputStreamStatistics.getQueueShrunkOps());
    }
}

