/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.utils.Listener;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderValidator;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.Test;

public class ITestAzureBlobFileSystemAppend
extends AbstractAbfsIntegrationTest {
    private static final String TEST_FILE_PATH = "testfile";
    private static final String TEST_FOLDER_PATH = "testFolder";

    @Test(expected=FileNotFoundException.class)
    public void testAppendDirShouldFail() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path filePath = this.path(TEST_FILE_PATH);
        fs.mkdirs(filePath);
        fs.append(filePath, 0).close();
    }

    @Test
    public void testAppendWithLength0() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        try (FSDataOutputStream stream = fs.create(this.path(TEST_FILE_PATH));){
            byte[] b = new byte[1024];
            new Random().nextBytes(b);
            stream.write(b, 1000, 0);
            ITestAzureBlobFileSystemAppend.assertEquals((long)0L, (long)stream.getPos());
        }
    }

    @Test(expected=FileNotFoundException.class)
    public void testAppendFileAfterDelete() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path filePath = this.path(TEST_FILE_PATH);
        ContractTestUtils.touch((FileSystem)fs, (Path)filePath);
        fs.delete(filePath, false);
        fs.append(filePath).close();
    }

    @Test(expected=FileNotFoundException.class)
    public void testAppendDirectory() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path folderPath = this.path(TEST_FOLDER_PATH);
        fs.mkdirs(folderPath);
        fs.append(folderPath).close();
    }

    @Test
    public void testTracingForAppend() throws IOException {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testPath = this.path(TEST_FILE_PATH);
        fs.create(testPath).close();
        fs.registerListener((Listener)new TracingHeaderValidator(fs.getAbfsStore().getAbfsConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.APPEND, false, 0));
        fs.append(testPath, 10);
    }
}

