/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestBase;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Test;

public class ITestNativeAzureFileSystemAppend
extends AbstractWasbTestBase {
    private Path testPath;

    @Override
    public Configuration createConfiguration() {
        Configuration conf = super.createConfiguration();
        conf.setBoolean("fs.azure.enable.append.support", true);
        return conf;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.testPath = this.methodPath();
    }

    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.create(this.createConfiguration());
    }

    private static byte[] getTestData(int size) {
        byte[] testData = new byte[size];
        System.arraycopy(RandomStringUtils.randomAlphabetic((int)size).getBytes(), 0, testData, 0, size);
        return testData;
    }

    private byte[] createBaseFileWithData(int fileSize, Path testPath) throws Throwable {
        try (FSDataOutputStream createStream = this.fs.create(testPath);){
            byte[] fileData = null;
            if (fileSize != 0) {
                fileData = ITestNativeAzureFileSystemAppend.getTestData(fileSize);
                createStream.write(fileData);
            }
            byte[] byArray = fileData;
            return byArray;
        }
    }

    private boolean verifyFileData(int dataLength, byte[] testData, int testDataIndex, FSDataInputStream srcStream) {
        try {
            byte[] fileBuffer = new byte[dataLength];
            byte[] testDataBuffer = new byte[dataLength];
            int fileBytesRead = srcStream.read(fileBuffer);
            if (fileBytesRead < dataLength) {
                return false;
            }
            System.arraycopy(testData, testDataIndex, testDataBuffer, 0, dataLength);
            return Arrays.equals(fileBuffer, testDataBuffer);
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean verifyAppend(byte[] testData, Path testFile) {
        try (FSDataInputStream srcStream = this.fs.open(testFile);){
            int testDataSize;
            int baseBufferSize = 2048;
            int testDataIndex = 0;
            for (testDataSize = testData.length; testDataSize > baseBufferSize; testDataIndex += baseBufferSize, testDataSize -= baseBufferSize) {
                if (this.verifyFileData(baseBufferSize, testData, testDataIndex, srcStream)) continue;
                boolean bl = false;
                return bl;
            }
            if (!this.verifyFileData(testDataSize, testData, testDataIndex, srcStream)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleAppend() throws Throwable {
        try (FSDataOutputStream appendStream = null;){
            int baseDataSize = 50;
            byte[] baseDataBuffer = this.createBaseFileWithData(baseDataSize, this.testPath);
            int appendDataSize = 20;
            byte[] appendDataBuffer = ITestNativeAzureFileSystemAppend.getTestData(appendDataSize);
            appendStream = this.fs.append(this.testPath, 10);
            appendStream.write(appendDataBuffer);
            appendStream.close();
            byte[] testData = new byte[baseDataSize + appendDataSize];
            System.arraycopy(baseDataBuffer, 0, testData, 0, baseDataSize);
            System.arraycopy(appendDataBuffer, 0, testData, baseDataSize, appendDataSize);
            ITestNativeAzureFileSystemAppend.assertTrue((boolean)this.verifyAppend(testData, this.testPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleAppendOnEmptyFile() throws Throwable {
        try (FSDataOutputStream appendStream = null;){
            this.createBaseFileWithData(0, this.testPath);
            int appendDataSize = 20;
            byte[] appendDataBuffer = ITestNativeAzureFileSystemAppend.getTestData(appendDataSize);
            appendStream = this.fs.append(this.testPath, 10);
            appendStream.write(appendDataBuffer);
            appendStream.close();
            ITestNativeAzureFileSystemAppend.assertTrue((boolean)this.verifyAppend(appendDataBuffer, this.testPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleAppenderScenario() throws Throwable {
        FSDataOutputStream appendStream1 = null;
        FSDataOutputStream appendStream2 = null;
        IOException ioe = null;
        try {
            this.createBaseFileWithData(0, this.testPath);
            appendStream1 = this.fs.append(this.testPath, 10);
            boolean encounteredException = false;
            try {
                appendStream2 = this.fs.append(this.testPath, 10);
            }
            catch (IOException ex) {
                encounteredException = true;
                ioe = ex;
            }
            appendStream1.close();
            ITestNativeAzureFileSystemAppend.assertTrue((boolean)encounteredException);
            GenericTestUtils.assertExceptionContains((String)"Unable to set Append lease on the Blob", (Throwable)ioe);
        }
        finally {
            if (appendStream1 != null) {
                appendStream1.close();
            }
            if (appendStream2 != null) {
                appendStream2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleAppends() throws Throwable {
        int baseDataSize = 50;
        byte[] baseDataBuffer = this.createBaseFileWithData(baseDataSize, this.testPath);
        int appendDataSize = 100;
        int targetAppendCount = 50;
        byte[] testData = new byte[baseDataSize + appendDataSize * targetAppendCount];
        int testDataIndex = 0;
        System.arraycopy(baseDataBuffer, 0, testData, testDataIndex, baseDataSize);
        testDataIndex += baseDataSize;
        try (FSDataOutputStream appendStream = null;){
            for (int appendCount = 0; appendCount < targetAppendCount; ++appendCount) {
                byte[] appendDataBuffer = ITestNativeAzureFileSystemAppend.getTestData(appendDataSize);
                appendStream = this.fs.append(this.testPath, 30);
                appendStream.write(appendDataBuffer);
                appendStream.close();
                System.arraycopy(appendDataBuffer, 0, testData, testDataIndex, appendDataSize);
                testDataIndex += appendDataSize;
            }
            ITestNativeAzureFileSystemAppend.assertTrue((boolean)this.verifyAppend(testData, this.testPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleAppendsOnSameStream() throws Throwable {
        int baseDataSize = 50;
        byte[] baseDataBuffer = this.createBaseFileWithData(baseDataSize, this.testPath);
        int appendDataSize = 100;
        int targetAppendCount = 50;
        byte[] testData = new byte[baseDataSize + appendDataSize * targetAppendCount];
        int testDataIndex = 0;
        System.arraycopy(baseDataBuffer, 0, testData, testDataIndex, baseDataSize);
        testDataIndex += baseDataSize;
        try (FSDataOutputStream appendStream = null;){
            for (int appendCount = 0; appendCount < targetAppendCount; ++appendCount) {
                appendStream = this.fs.append(this.testPath, 50);
                int singleAppendChunkSize = 20;
                for (int appendRunSize = 0; appendRunSize < appendDataSize; appendRunSize += singleAppendChunkSize) {
                    byte[] appendDataBuffer = ITestNativeAzureFileSystemAppend.getTestData(singleAppendChunkSize);
                    appendStream.write(appendDataBuffer);
                    System.arraycopy(appendDataBuffer, 0, testData, testDataIndex + appendRunSize, singleAppendChunkSize);
                }
                appendStream.close();
                testDataIndex += appendDataSize;
            }
            ITestNativeAzureFileSystemAppend.assertTrue((boolean)this.verifyAppend(testData, this.testPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=UnsupportedOperationException.class)
    public void testFalseConfigurationFlagBehavior() throws Throwable {
        this.fs = this.testAccount.getFileSystem();
        Configuration conf = this.fs.getConf();
        conf.setBoolean("fs.azure.enable.append.support", false);
        URI uri = this.fs.getUri();
        this.fs.initialize(uri, conf);
        try (FSDataOutputStream appendStream = null;){
            this.createBaseFileWithData(0, this.testPath);
            appendStream = this.fs.append(this.testPath, 10);
        }
    }
}

