/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientRenameResult;
import org.apache.hadoop.fs.azurebfs.services.AbfsCounters;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperationType;
import org.apache.hadoop.fs.azurebfs.services.TestAbfsClient;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAbfsRenameRetryRecovery
extends AbstractAbfsIntegrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestAbfsRenameRetryRecovery.class);

    @Test
    public void testRenameFailuresDueToIncompleteMetadata() throws Exception {
        String sourcePath = this.getMethodName() + "Source";
        String destNoParentPath = "/NoParent/Dest";
        AzureBlobFileSystem fs = this.getFileSystem();
        AbfsClient mockClient = TestAbfsClient.getMockAbfsClient(fs.getAbfsStore().getClient(), fs.getAbfsStore().getAbfsConfiguration());
        AbfsCounters abfsCounters = (AbfsCounters)Mockito.mock(AbfsCounters.class);
        Mockito.when((Object)mockClient.getAbfsCounters()).thenReturn((Object)abfsCounters);
        AbfsRestOperation successOp = new AbfsRestOperation(AbfsRestOperationType.RenamePath, mockClient, "PUT", null, null);
        AbfsClientRenameResult successResult = (AbfsClientRenameResult)Mockito.mock(AbfsClientRenameResult.class);
        ((AbfsClientRenameResult)Mockito.doReturn((Object)successOp).when((Object)successResult)).getOp();
        Mockito.when((Object)successResult.isIncompleteMetadataState()).thenReturn((Object)false);
        AbfsRestOperation failedOp = new AbfsRestOperation(AbfsRestOperationType.RenamePath, mockClient, "PUT", null, null);
        AbfsClientRenameResult recoveredMetaDataIncompleteResult = (AbfsClientRenameResult)Mockito.mock(AbfsClientRenameResult.class);
        ((AbfsClientRenameResult)Mockito.doReturn((Object)failedOp).when((Object)recoveredMetaDataIncompleteResult)).getOp();
        Mockito.when((Object)recoveredMetaDataIncompleteResult.isIncompleteMetadataState()).thenReturn((Object)true);
        AbfsRestOperationException destParentNotFound = this.getMockAbfsRestOperationException(AzureServiceErrorCode.RENAME_DESTINATION_PARENT_PATH_NOT_FOUND.getStatusCode(), AzureServiceErrorCode.RENAME_DESTINATION_PARENT_PATH_NOT_FOUND.getErrorCode());
        Mockito.when((Object)mockClient.renamePath(sourcePath, destNoParentPath, null, null, null, false)).thenThrow(new Throwable[]{destParentNotFound}).thenReturn((Object)recoveredMetaDataIncompleteResult);
        LambdaTestUtils.intercept(AzureBlobFileSystemException.class, () -> mockClient.renamePath(sourcePath, destNoParentPath, null, null, null, false));
        AbfsClientRenameResult resultOfSecondRenameCall = mockClient.renamePath(sourcePath, destNoParentPath, null, null, null, false);
        ((ObjectAssert)Assertions.assertThat((Object)resultOfSecondRenameCall).describedAs("This result should be recovered result due to MetaData being in incomplete state", new Object[0])).isSameAs((Object)recoveredMetaDataIncompleteResult);
        TestAbfsRenameRetryRecovery.assertTrue((String)"Metadata incomplete state should be true if a rename is retried after no Parent directory is found", (boolean)resultOfSecondRenameCall.isIncompleteMetadataState());
        ((AbfsClient)Mockito.verify((Object)mockClient, (VerificationMode)Mockito.times((int)2))).renamePath(sourcePath, destNoParentPath, null, null, null, false);
    }

    private AbfsRestOperationException getMockAbfsRestOperationException(int statusCode, String errorCode) {
        return new AbfsRestOperationException(statusCode, errorCode, "No Parent found for the Destination file", new Exception());
    }
}

