/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStream;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.Test;

public class ITestAbfsUnbuffer
extends AbstractAbfsIntegrationTest {
    private Path dest;

    @Override
    public void setup() throws Exception {
        super.setup();
        this.dest = this.path("ITestAbfsUnbuffer");
        byte[] data = ContractTestUtils.dataset((int)16, (int)97, (int)26);
        ContractTestUtils.writeDataset((FileSystem)this.getFileSystem(), (Path)this.dest, (byte[])data, (int)data.length, (int)16, (boolean)true);
    }

    @Test
    public void testUnbuffer() throws IOException {
        try (FSDataInputStream inputStream = this.getFileSystem().open(this.dest);){
            ITestAbfsUnbuffer.assertTrue((String)("unexpected stream type " + inputStream.getWrappedStream().getClass().getSimpleName()), (boolean)(inputStream.getWrappedStream() instanceof AbfsInputStream));
            ITestAbfsUnbuffer.readAndAssertBytesRead(inputStream, 8);
            ITestAbfsUnbuffer.assertFalse((String)"AbfsInputStream buffer should not be null", (boolean)this.isBufferNull(inputStream));
            inputStream.unbuffer();
            ITestAbfsUnbuffer.assertTrue((String)"AbfsInputStream buffer should be null", (boolean)this.isBufferNull(inputStream));
        }
    }

    private boolean isBufferNull(FSDataInputStream inputStream) {
        return ((AbfsInputStream)inputStream.getWrappedStream()).getBuffer() == null;
    }

    private static void readAndAssertBytesRead(FSDataInputStream inputStream, int bytesToRead) throws IOException {
        ITestAbfsUnbuffer.assertEquals((String)"AbfsInputStream#read did not read the correct number of bytes", (long)bytesToRead, (long)inputStream.read(new byte[bytesToRead]));
    }
}

