/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.services.ExponentialRetryPolicy;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestAzureADAuthenticator
extends AbstractAbfsIntegrationTest {
    private static final int TEST_RETRY_COUNT = 10;
    private static final int TEST_MIN_BACKOFF = 20;
    private static final int TEST_MAX_BACKOFF = 30;
    private static final int TEST_DELTA_BACKOFF = 40;

    @Test
    public void testDefaultOAuthTokenFetchRetryPolicy() throws Exception {
        this.getConfiguration().unset("fs.azure.oauth.token.fetch.retry.max.retries");
        this.getConfiguration().unset("fs.azure.oauth.token.fetch.retry.min.backoff.interval");
        this.getConfiguration().unset("fs.azure.oauth.token.fetch.retry.max.backoff.interval");
        this.getConfiguration().unset("fs.azure.oauth.token.fetch.retry.delta.backoff");
        String accountName = this.getConfiguration().get("fs.azure.account.name");
        AbfsConfiguration abfsConfig = new AbfsConfiguration(this.getRawConfiguration(), accountName);
        ExponentialRetryPolicy retryPolicy = abfsConfig.getOauthTokenFetchRetryPolicy();
        ((AbstractIntegerAssert)Assertions.assertThat((int)retryPolicy.getRetryCount()).describedAs("retryCount should be the default value {} as the same is not configured", new Object[]{5})).isEqualTo(5);
        ((AbstractIntegerAssert)Assertions.assertThat((int)retryPolicy.getMinBackoff()).describedAs("minBackOff should be the default value {} as the same is not configured", new Object[]{0})).isEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)retryPolicy.getMaxBackoff()).describedAs("maxBackOff should be the default value {} as the same is not configured", new Object[]{60000})).isEqualTo(60000);
        ((AbstractIntegerAssert)Assertions.assertThat((int)retryPolicy.getDeltaBackoff()).describedAs("deltaBackOff should be the default value {} as the same is not configured", new Object[]{2})).isEqualTo(2);
    }

    @Test
    public void testOAuthTokenFetchRetryPolicy() throws IOException, IllegalAccessException {
        this.getConfiguration().set("fs.azure.oauth.token.fetch.retry.max.retries", String.valueOf(10));
        this.getConfiguration().set("fs.azure.oauth.token.fetch.retry.min.backoff.interval", String.valueOf(20));
        this.getConfiguration().set("fs.azure.oauth.token.fetch.retry.max.backoff.interval", String.valueOf(30));
        this.getConfiguration().set("fs.azure.oauth.token.fetch.retry.delta.backoff", String.valueOf(40));
        String accountName = this.getConfiguration().get("fs.azure.account.name");
        AbfsConfiguration abfsConfig = new AbfsConfiguration(this.getRawConfiguration(), accountName);
        ExponentialRetryPolicy retryPolicy = abfsConfig.getOauthTokenFetchRetryPolicy();
        ((AbstractIntegerAssert)Assertions.assertThat((int)retryPolicy.getRetryCount()).describedAs("retryCount should be {}", new Object[]{10})).isEqualTo(10);
        ((AbstractIntegerAssert)Assertions.assertThat((int)retryPolicy.getMinBackoff()).describedAs("minBackOff should be {}", new Object[]{20})).isEqualTo(20);
        ((AbstractIntegerAssert)Assertions.assertThat((int)retryPolicy.getMaxBackoff()).describedAs("maxBackOff should be {}", new Object[]{30})).isEqualTo(30);
        ((AbstractIntegerAssert)Assertions.assertThat((int)retryPolicy.getDeltaBackoff()).describedAs("deltaBackOff should be {}", new Object[]{40})).isEqualTo(40);
    }
}

