/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.SendingRequestEvent;
import com.microsoft.azure.storage.StorageEvent;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestWithTimeout;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.AzureException;
import org.apache.hadoop.fs.azure.AzureNativeFileSystemStore;
import org.apache.hadoop.fs.azure.FileMetadata;
import org.apache.hadoop.fs.azure.MockStorageInterface;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.NativeFileSystemStore;
import org.apache.hadoop.fs.azure.StorageInterface;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assume;
import org.junit.Test;

public class ITestAzureFileSystemErrorConditions
extends AbstractWasbTestWithTimeout {
    private static final int ALL_THREE_FILE_SIZE = 1024;

    @Test
    public void testNoInitialize() throws Exception {
        LambdaTestUtils.intercept(AssertionError.class, (Callable)new Callable<FileMetadata>(){

            @Override
            public FileMetadata call() throws Exception {
                return new AzureNativeFileSystemStore().retrieveMetadata("foo");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccessUnauthorizedPublicContainer() throws Exception {
        String container = "nonExistentContainer";
        String account = "hopefullyNonExistentAccount";
        Path noAccessPath = new Path("wasb://nonExistentContainer@hopefullyNonExistentAccount/someFile");
        NativeAzureFileSystem.suppressRetryPolicy();
        try {
            FileSystem.get((URI)noAccessPath.toUri(), (Configuration)new Configuration()).open(noAccessPath);
            ITestAzureFileSystemErrorConditions.assertTrue((String)"Should've thrown.", (boolean)false);
        }
        catch (AzureException ex) {
            GenericTestUtils.assertExceptionContains((String)String.format("No credentials found for account %s in the configuration, and its container %s is not accessible using anonymous credentials. Please check if the container exists first. If it is not publicly available, you have to provide account credentials.", "hopefullyNonExistentAccount", "nonExistentContainer"), (Throwable)ex);
        }
        finally {
            NativeAzureFileSystem.resumeRetryPolicy();
        }
    }

    @Test
    public void testAccessContainerWithWrongVersion() throws Exception {
        AzureNativeFileSystemStore store = new AzureNativeFileSystemStore();
        MockStorageInterface mockStorage = new MockStorageInterface();
        store.setAzureStorageInteractionLayer((StorageInterface)mockStorage);
        try (NativeAzureFileSystem fs = new NativeAzureFileSystem((NativeFileSystemStore)store);){
            Configuration conf = new Configuration();
            AzureBlobStorageTestAccount.setMockAccountKey(conf);
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("hdi_version", "2090-04-05");
            mockStorage.addPreExistingContainer(AzureBlobStorageTestAccount.getMockContainerUri(), metadata);
            AzureException ex = (AzureException)LambdaTestUtils.intercept(AzureException.class, (Callable)new Callable<FileStatus[]>((FileSystem)fs, conf){
                final /* synthetic */ FileSystem val$fs;
                final /* synthetic */ Configuration val$conf;
                {
                    this.val$fs = fileSystem;
                    this.val$conf = configuration;
                }

                @Override
                public FileStatus[] call() throws Exception {
                    this.val$fs.initialize(new URI("wasb://mockContainer@mockAccount-c01112a3-2a23-433e-af2a-e808ea385136.blob.core.windows.net/"), this.val$conf);
                    return this.val$fs.listStatus(new Path("/"));
                }
            });
            GenericTestUtils.assertExceptionContains((String)"unsupported version: 2090-04-05.", (Throwable)ex);
        }
    }

    private void injectTransientError(NativeAzureFileSystem fs, final ConnectionRecognizer connectionRecognizer) {
        fs.getStore().addTestHookToOperationContext(new AzureNativeFileSystemStore.TestHookOperationContext(){

            public OperationContext modifyOperationContext(OperationContext original) {
                original.getSendingRequestEventHandler().addListener((StorageEvent)new TransientErrorInjector(connectionRecognizer));
                return original;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransientErrorOnDelete() throws Exception {
        AzureBlobStorageTestAccount testAccount = AzureBlobStorageTestAccount.create();
        Assume.assumeNotNull((Object[])new Object[]{testAccount});
        try {
            NativeAzureFileSystem fs = testAccount.getFileSystem();
            this.injectTransientError(fs, new ConnectionRecognizer(){

                @Override
                public boolean isTargetConnection(HttpURLConnection connection) {
                    return connection.getRequestMethod().equals("DELETE");
                }
            });
            Path testFile = new Path("/a/b");
            ITestAzureFileSystemErrorConditions.assertTrue((boolean)fs.createNewFile(testFile));
            ITestAzureFileSystemErrorConditions.assertTrue((boolean)fs.rename(testFile, new Path("/x")));
        }
        finally {
            testAccount.cleanup();
        }
    }

    private void writeAllThreeFile(NativeAzureFileSystem fs, Path testFile) throws IOException {
        byte[] buffer = new byte[1024];
        Arrays.fill(buffer, (byte)3);
        try (FSDataOutputStream stream = fs.create(testFile);){
            stream.write(buffer);
        }
    }

    private void readAllThreeFile(NativeAzureFileSystem fs, Path testFile) throws IOException {
        byte[] buffer = new byte[1024];
        FSDataInputStream inStream = fs.open(testFile);
        ITestAzureFileSystemErrorConditions.assertEquals((long)buffer.length, (long)inStream.read(buffer, 0, buffer.length));
        inStream.close();
        for (int i = 0; i < buffer.length; ++i) {
            ITestAzureFileSystemErrorConditions.assertEquals((long)3L, (long)buffer[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransientErrorOnCommitBlockList() throws Exception {
        AzureBlobStorageTestAccount testAccount = AzureBlobStorageTestAccount.create();
        Assume.assumeNotNull((Object[])new Object[]{testAccount});
        try {
            NativeAzureFileSystem fs = testAccount.getFileSystem();
            this.injectTransientError(fs, new ConnectionRecognizer(){

                @Override
                public boolean isTargetConnection(HttpURLConnection connection) {
                    return connection.getRequestMethod().equals("PUT") && connection.getURL().getQuery() != null && connection.getURL().getQuery().contains("blocklist");
                }
            });
            Path testFile = new Path("/a/b");
            this.writeAllThreeFile(fs, testFile);
            this.readAllThreeFile(fs, testFile);
        }
        finally {
            testAccount.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransientErrorOnRead() throws Exception {
        AzureBlobStorageTestAccount testAccount = AzureBlobStorageTestAccount.create();
        Assume.assumeNotNull((Object[])new Object[]{testAccount});
        try {
            NativeAzureFileSystem fs = testAccount.getFileSystem();
            Path testFile = new Path("/a/b");
            this.writeAllThreeFile(fs, testFile);
            this.injectTransientError(fs, new ConnectionRecognizer(){

                @Override
                public boolean isTargetConnection(HttpURLConnection connection) {
                    return connection.getRequestMethod().equals("GET");
                }
            });
            this.readAllThreeFile(fs, testFile);
        }
        finally {
            testAccount.cleanup();
        }
    }

    private class TransientErrorInjector
    extends StorageEvent<SendingRequestEvent> {
        private final ConnectionRecognizer connectionRecognizer;
        private boolean injectedErrorOnce = false;

        public TransientErrorInjector(ConnectionRecognizer connectionRecognizer) {
            this.connectionRecognizer = connectionRecognizer;
        }

        public void eventOccurred(SendingRequestEvent eventArg) {
            HttpURLConnection connection = (HttpURLConnection)eventArg.getConnectionObject();
            if (!this.connectionRecognizer.isTargetConnection(connection)) {
                return;
            }
            if (!this.injectedErrorOnce) {
                connection.setReadTimeout(1);
                connection.disconnect();
                this.injectedErrorOnce = true;
            }
        }
    }

    private static interface ConnectionRecognizer {
        public boolean isTargetConnection(HttpURLConnection var1);
    }
}

