/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.fs.azurebfs.AbfsCountersImpl;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.junit.Test;

public class TestAbfsStatistics
extends AbstractAbfsIntegrationTest {
    private static final int LARGE_OPS = 100;

    @Test
    public void testInitializeStats() throws IOException {
        this.describe("Testing the counter values after Abfs is initialised", new Object[0]);
        AbfsCountersImpl instrumentation = new AbfsCountersImpl(this.getFileSystem().getUri());
        for (int i = 0; i < 100; ++i) {
            instrumentation.incrementCounter(AbfsStatistic.CALL_GET_DELEGATION_TOKEN, 1L);
            instrumentation.incrementCounter(AbfsStatistic.ERROR_IGNORED, 1L);
        }
        Map metricMap = instrumentation.toMap();
        this.assertAbfsStatistics(AbfsStatistic.CALL_GET_DELEGATION_TOKEN, 100L, metricMap);
        this.assertAbfsStatistics(AbfsStatistic.ERROR_IGNORED, 100L, metricMap);
    }
}

