/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.EnumSet;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.ConcurrentWriteOperationDetectedException;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.TestAbfsClient;
import org.apache.hadoop.fs.azurebfs.utils.Listener;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderValidator;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ITestAzureBlobFileSystemCreate
extends AbstractAbfsIntegrationTest {
    private static final Path TEST_FILE_PATH = new Path("testfile");
    private static final String TEST_FOLDER_PATH = "testFolder";
    private static final String TEST_CHILD_FILE = "childFile";

    @Test
    public void testEnsureFileCreatedImmediately() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        try (FSDataOutputStream out = fs.create(TEST_FILE_PATH);){
            ContractTestUtils.assertIsFile((FileSystem)fs, (Path)TEST_FILE_PATH);
        }
        ContractTestUtils.assertIsFile((FileSystem)fs, (Path)TEST_FILE_PATH);
    }

    @Test
    public void testCreateNonRecursive() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFolderPath = this.path(TEST_FOLDER_PATH);
        Path testFile = new Path(testFolderPath, TEST_CHILD_FILE);
        try {
            fs.createNonRecursive(testFile, true, 1024, (short)1, 1024L, null);
            ITestAzureBlobFileSystemCreate.fail((String)"Should've thrown");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        fs.registerListener((Listener)new TracingHeaderValidator(fs.getAbfsStore().getAbfsConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.MKDIR, false, 0));
        fs.mkdirs(testFolderPath);
        fs.registerListener(null);
        fs.createNonRecursive(testFile, true, 1024, (short)1, 1024L, null).close();
        ContractTestUtils.assertIsFile((FileSystem)fs, (Path)testFile);
    }

    @Test
    public void testCreateNonRecursive1() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFolderPath = this.path(TEST_FOLDER_PATH);
        Path testFile = new Path(testFolderPath, TEST_CHILD_FILE);
        try {
            fs.createNonRecursive(testFile, FsPermission.getDefault(), EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), 1024, (short)1, 1024L, null);
            ITestAzureBlobFileSystemCreate.fail((String)"Should've thrown");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        fs.mkdirs(testFolderPath);
        fs.createNonRecursive(testFile, true, 1024, (short)1, 1024L, null).close();
        ContractTestUtils.assertIsFile((FileSystem)fs, (Path)testFile);
    }

    @Test
    public void testCreateNonRecursive2() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFolderPath = this.path(TEST_FOLDER_PATH);
        Path testFile = new Path(testFolderPath, TEST_CHILD_FILE);
        try {
            fs.createNonRecursive(testFile, FsPermission.getDefault(), false, 1024, (short)1, 1024L, null);
            ITestAzureBlobFileSystemCreate.fail((String)"Should've thrown");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        fs.mkdirs(testFolderPath);
        fs.createNonRecursive(testFile, true, 1024, (short)1, 1024L, null).close();
        ContractTestUtils.assertIsFile((FileSystem)fs, (Path)testFile);
    }

    @Test
    public void testWriteAfterClose() throws Throwable {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFolderPath = this.path(TEST_FOLDER_PATH);
        Path testPath = new Path(testFolderPath, TEST_CHILD_FILE);
        FSDataOutputStream out = fs.create(testPath);
        out.close();
        LambdaTestUtils.intercept(IOException.class, () -> out.write(97));
        LambdaTestUtils.intercept(IOException.class, () -> out.write(new byte[]{97}));
        out.flush();
        out.close();
    }

    @Test
    public void testTryWithResources() throws Throwable {
        block9: {
            AzureBlobFileSystem fs = this.getFileSystem();
            Path testFolderPath = this.path(TEST_FOLDER_PATH);
            Path testPath = new Path(testFolderPath, TEST_CHILD_FILE);
            try (FSDataOutputStream out = fs.create(testPath);){
                out.write(49);
                out.hsync();
                fs.delete(testPath, false);
                out.write(50);
                out.hsync();
                ITestAzureBlobFileSystemCreate.fail((String)"Expected a failure");
            }
            catch (FileNotFoundException fnfe) {
                if (fs.getAbfsStore().isAppendBlobKey(fs.makeQualified(testPath).toString())) break block9;
                Throwable[] suppressed = fnfe.getSuppressed();
                ITestAzureBlobFileSystemCreate.assertEquals((String)"suppressed count", (long)1L, (long)suppressed.length);
                Throwable inner = suppressed[0];
                if (!(inner instanceof IOException)) {
                    throw inner;
                }
                GenericTestUtils.assertExceptionContains((String)fnfe.getMessage(), (Throwable)inner);
            }
        }
    }

    @Test
    public void testFilterFSWriteAfterClose() throws Throwable {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFolderPath = this.path(TEST_FOLDER_PATH);
        Path testPath = new Path(testFolderPath, TEST_CHILD_FILE);
        FSDataOutputStream out = fs.create(testPath);
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> {
            FilterOutputStream fos = new FilterOutputStream((OutputStream)out);
            try {
                fos.write(97);
                fos.flush();
                out.hsync();
                fs.delete(testPath, false);
                throw (FileNotFoundException)LambdaTestUtils.intercept(FileNotFoundException.class, () -> {
                    fos.write(98);
                    out.hsync();
                    return "hsync didn't raise an IOE";
                });
            }
            catch (Throwable throwable) {
                try {
                    fos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
    }

    @Test
    public void testDefaultCreateOverwriteFileTest() throws Throwable {
        this.testCreateFileOverwrite(true);
        this.testCreateFileOverwrite(false);
    }

    public void testCreateFileOverwrite(boolean enableConditionalCreateOverwrite) throws Throwable {
        AzureBlobFileSystem currentFs = this.getFileSystem();
        Configuration config = new Configuration(this.getRawConfiguration());
        config.set("fs.azure.enable.conditional.create.overwrite", Boolean.toString(enableConditionalCreateOverwrite));
        AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((URI)currentFs.getUri(), (Configuration)config);
        long totalConnectionMadeBeforeTest = (Long)fs.getInstrumentationMap().get(AbfsStatistic.CONNECTIONS_MADE.getStatName());
        int createRequestCount = 0;
        Path nonOverwriteFile = new Path("/NonOverwriteTest_FileName_" + UUID.randomUUID().toString());
        fs.create(nonOverwriteFile, false);
        this.assertAbfsStatistics(AbfsStatistic.CONNECTIONS_MADE, totalConnectionMadeBeforeTest + (long)(++createRequestCount), fs.getInstrumentationMap());
        fs.registerListener((Listener)new TracingHeaderValidator(fs.getAbfsStore().getAbfsConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.CREATE, false, 0));
        LambdaTestUtils.intercept(FileAlreadyExistsException.class, () -> fs.create(nonOverwriteFile, false));
        fs.registerListener(null);
        this.assertAbfsStatistics(AbfsStatistic.CONNECTIONS_MADE, totalConnectionMadeBeforeTest + (long)(++createRequestCount), fs.getInstrumentationMap());
        Path overwriteFilePath = new Path("/OverwriteTest_FileName_" + UUID.randomUUID().toString());
        fs.create(overwriteFilePath, true);
        this.assertAbfsStatistics(AbfsStatistic.CONNECTIONS_MADE, totalConnectionMadeBeforeTest + (long)(++createRequestCount), fs.getInstrumentationMap());
        fs.registerListener((Listener)new TracingHeaderValidator(fs.getAbfsStore().getAbfsConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.CREATE, true, 0));
        fs.create(overwriteFilePath, true);
        fs.registerListener(null);
        createRequestCount = enableConditionalCreateOverwrite ? (createRequestCount += 3) : ++createRequestCount;
        this.assertAbfsStatistics(AbfsStatistic.CONNECTIONS_MADE, totalConnectionMadeBeforeTest + (long)createRequestCount, fs.getInstrumentationMap());
    }

    @Test
    public void testNegativeScenariosForCreateOverwriteDisabled() throws Throwable {
        AzureBlobFileSystem currentFs = this.getFileSystem();
        Configuration config = new Configuration(this.getRawConfiguration());
        config.set("fs.azure.enable.conditional.create.overwrite", Boolean.toString(true));
        AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((URI)currentFs.getUri(), (Configuration)config);
        AbfsClient mockClient = TestAbfsClient.getMockAbfsClient(fs.getAbfsStore().getClient(), fs.getAbfsStore().getAbfsConfiguration());
        AzureBlobFileSystemStore abfsStore = fs.getAbfsStore();
        abfsStore = this.setAzureBlobSystemStoreField(abfsStore, "client", mockClient);
        boolean isNamespaceEnabled = abfsStore.getIsNamespaceEnabled(this.getTestTracingContext(fs, false));
        AbfsRestOperation successOp = (AbfsRestOperation)Mockito.mock(AbfsRestOperation.class);
        AbfsHttpOperation http200Op = (AbfsHttpOperation)Mockito.mock(AbfsHttpOperation.class);
        Mockito.when((Object)http200Op.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)successOp.getResult()).thenReturn((Object)http200Op);
        AbfsRestOperationException conflictResponseEx = this.getMockAbfsRestOperationException(409);
        AbfsRestOperationException serverErrorResponseEx = this.getMockAbfsRestOperationException(500);
        AbfsRestOperationException fileNotFoundResponseEx = this.getMockAbfsRestOperationException(404);
        AbfsRestOperationException preConditionResponseEx = this.getMockAbfsRestOperationException(412);
        ((AbfsClient)Mockito.doThrow((Throwable[])new Throwable[]{conflictResponseEx}).doThrow(new Throwable[]{conflictResponseEx}).doThrow(new Throwable[]{conflictResponseEx}).doThrow(new Throwable[]{conflictResponseEx}).doThrow(new Throwable[]{serverErrorResponseEx}).when((Object)mockClient)).createPath((String)ArgumentMatchers.any(String.class), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)false), isNamespaceEnabled ? (String)ArgumentMatchers.any(String.class) : (String)ArgumentMatchers.eq(null), isNamespaceEnabled ? (String)ArgumentMatchers.any(String.class) : (String)ArgumentMatchers.eq(null), ((Boolean)ArgumentMatchers.any(Boolean.TYPE)).booleanValue(), (String)ArgumentMatchers.eq(null), (TracingContext)ArgumentMatchers.any(TracingContext.class));
        ((AbfsClient)Mockito.doThrow((Throwable[])new Throwable[]{fileNotFoundResponseEx}).doThrow(new Throwable[]{serverErrorResponseEx}).doReturn((Object)successOp).doReturn((Object)successOp).when((Object)mockClient)).getPathStatus((String)ArgumentMatchers.any(String.class), ArgumentMatchers.eq((boolean)false), (TracingContext)ArgumentMatchers.any(TracingContext.class));
        ((AbfsClient)Mockito.doThrow((Throwable[])new Throwable[]{preConditionResponseEx}).doThrow(new Throwable[]{serverErrorResponseEx}).when((Object)mockClient)).createPath((String)ArgumentMatchers.any(String.class), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)true), isNamespaceEnabled ? (String)ArgumentMatchers.any(String.class) : (String)ArgumentMatchers.eq(null), isNamespaceEnabled ? (String)ArgumentMatchers.any(String.class) : (String)ArgumentMatchers.eq(null), ((Boolean)ArgumentMatchers.any(Boolean.TYPE)).booleanValue(), (String)ArgumentMatchers.eq(null), (TracingContext)ArgumentMatchers.any(TracingContext.class));
        this.validateCreateFileException(ConcurrentWriteOperationDetectedException.class, abfsStore);
        this.validateCreateFileException(AbfsRestOperationException.class, abfsStore);
        this.validateCreateFileException(ConcurrentWriteOperationDetectedException.class, abfsStore);
        this.validateCreateFileException(AbfsRestOperationException.class, abfsStore);
        this.validateCreateFileException(AbfsRestOperationException.class, abfsStore);
    }

    private AzureBlobFileSystemStore setAzureBlobSystemStoreField(AzureBlobFileSystemStore abfsStore, String fieldName, Object fieldObject) throws Exception {
        Field abfsClientField = AzureBlobFileSystemStore.class.getDeclaredField(fieldName);
        abfsClientField.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(abfsClientField, abfsClientField.getModifiers() & 0xFFFFFFEF);
        abfsClientField.set(abfsStore, fieldObject);
        return abfsStore;
    }

    private <E extends Throwable> void validateCreateFileException(Class<E> exceptionClass, AzureBlobFileSystemStore abfsStore) throws Exception {
        FsPermission permission = new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL);
        FsPermission umask = new FsPermission(FsAction.NONE, FsAction.NONE, FsAction.NONE);
        Path testPath = new Path("testFile");
        LambdaTestUtils.intercept(exceptionClass, () -> abfsStore.createFile(testPath, null, true, permission, umask, this.getTestTracingContext(this.getFileSystem(), true)));
    }

    private AbfsRestOperationException getMockAbfsRestOperationException(int status) {
        return new AbfsRestOperationException(status, "", "", new Exception());
    }
}

