/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.microsoft.azure.storage.StorageException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.AzureException;
import org.apache.hadoop.fs.azure.AzureNativeFileSystemStore;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.NativeAzureFileSystemBaseTest;
import org.apache.hadoop.fs.azure.SelfRenewingLease;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.junit.Test;

public class ITestNativeAzureFileSystemLive
extends NativeAzureFileSystemBaseTest {
    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.create();
    }

    @Test
    public void testMultipleRenameFileOperationsToSameDestination() throws IOException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicInteger successfulRenameCount = new AtomicInteger(0);
        AtomicReference unexpectedError = new AtomicReference();
        Path dest = this.path("dest");
        ArrayList<Thread> threads = new ArrayList<Thread>();
        int i = 0;
        while (i < 10) {
            int threadNumber = i++;
            Path src = this.path("test" + threadNumber);
            threads.add(new Thread(() -> {
                try {
                    latch.await(Long.MAX_VALUE, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    try (FSDataOutputStream output = this.fs.create(src);){
                        output.write(("Source file number " + threadNumber).getBytes());
                    }
                    if (this.fs.rename(src, dest)) {
                        LOG.info((Object)("rename succeeded for thread " + threadNumber));
                        successfulRenameCount.incrementAndGet();
                    }
                }
                catch (IOException e) {
                    unexpectedError.compareAndSet(null, e);
                    ContractTestUtils.fail((String)"Exception unexpected", (Throwable)e);
                }
            }));
        }
        threads.forEach(t -> t.start());
        Thread.sleep(2000L);
        latch.countDown();
        threads.forEach(t -> {
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        if (unexpectedError.get() != null) {
            throw (IOException)unexpectedError.get();
        }
        ITestNativeAzureFileSystemLive.assertEquals((long)1L, (long)successfulRenameCount.get());
        LOG.info((Object)"Success, only one rename operation succeeded!");
    }

    @Test
    public void testLazyRenamePendingCanOverwriteExistingFile() throws Exception {
        String srcFile = "srcFile";
        String dstFile = "dstFile";
        Path srcPath = this.path("srcFile");
        FSDataOutputStream srcStream = this.fs.create(srcPath);
        ITestNativeAzureFileSystemLive.assertTrue((boolean)this.fs.exists(srcPath));
        Path dstPath = this.path("dstFile");
        FSDataOutputStream dstStream = this.fs.create(dstPath);
        ITestNativeAzureFileSystemLive.assertTrue((boolean)this.fs.exists(dstPath));
        NativeAzureFileSystem nfs = this.fs;
        String fullSrcKey = nfs.pathToKey(nfs.makeAbsolute(srcPath));
        String fullDstKey = nfs.pathToKey(nfs.makeAbsolute(dstPath));
        nfs.getStoreInterface().rename(fullSrcKey, fullDstKey, true, null);
        ITestNativeAzureFileSystemLive.assertTrue((boolean)this.fs.exists(dstPath));
        ITestNativeAzureFileSystemLive.assertFalse((boolean)this.fs.exists(srcPath));
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{srcStream});
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{dstStream});
    }

    @Test
    public void testDeleteThrowsExceptionWithLeaseExistsErrorMessage() throws Exception {
        LOG.info((Object)"Starting test");
        Path path = this.methodPath();
        this.fs.create(path);
        this.assertPathExists("test file", path);
        NativeAzureFileSystem nfs = this.fs;
        final String fullKey = nfs.pathToKey(nfs.makeAbsolute(path));
        final AzureNativeFileSystemStore store = nfs.getStore();
        final CountDownLatch leaseAttemptComplete = new CountDownLatch(1);
        final CountDownLatch beginningDeleteAttempt = new CountDownLatch(1);
        Thread t = new Thread(){

            @Override
            public void run() {
                SelfRenewingLease lease = null;
                try {
                    lease = store.acquireLease(fullKey);
                    NativeAzureFileSystemBaseTest.LOG.info((Object)("Lease acquired: " + lease.getLeaseID()));
                }
                catch (AzureException e) {
                    NativeAzureFileSystemBaseTest.LOG.warn((Object)"Lease acqusition thread unable to acquire lease", (Throwable)e);
                }
                finally {
                    leaseAttemptComplete.countDown();
                }
                try {
                    beginningDeleteAttempt.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                try {
                    Thread.sleep(6000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                try {
                    if (lease != null) {
                        NativeAzureFileSystemBaseTest.LOG.info((Object)"Freeing lease");
                        lease.free();
                    }
                }
                catch (StorageException se) {
                    NativeAzureFileSystemBaseTest.LOG.warn((Object)"Unable to free lease.", (Throwable)se);
                }
            }
        };
        t.start();
        try {
            leaseAttemptComplete.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        beginningDeleteAttempt.countDown();
        store.delete(fullKey);
        this.assertPathDoesNotExist("Leased path", path);
    }

    @Test
    public void testIsPageBlobKey() {
        String[] positiveKeys;
        String[] negativeKeys;
        AzureNativeFileSystemStore store = this.fs.getStore();
        ITestNativeAzureFileSystemLive.assertEquals((Object)"pageBlobs", (Object)"pageBlobs");
        String uriPrefix = "file:///";
        for (String s : negativeKeys = new String[]{"", "/", "bar", "bar/", "bar/pageBlobs", "bar/pageBlobs/foo", "bar/pageBlobs/foo/", "/pageBlobs/", "/pageBlobs", "pageBlobsxyz/"}) {
            ITestNativeAzureFileSystemLive.assertFalse((boolean)store.isPageBlobKey(s));
            ITestNativeAzureFileSystemLive.assertFalse((boolean)store.isPageBlobKey(uriPrefix + s));
        }
        for (String s : positiveKeys = new String[]{"pageBlobs/", "pageBlobs/foo/", "pageBlobs/foo/bar/"}) {
            ITestNativeAzureFileSystemLive.assertTrue((boolean)store.isPageBlobKey(s));
            ITestNativeAzureFileSystemLive.assertTrue((boolean)store.isPageBlobKey(uriPrefix + s));
        }
    }

    @Test
    public void testIsAtomicRenameKey() {
        String[] positiveKeys;
        String[] negativeKeys;
        AzureNativeFileSystemStore store = this.fs.getStore();
        ITestNativeAzureFileSystemLive.assertEquals((Object)"/atomicRenameDir1,/atomicRenameDir2", (Object)"/atomicRenameDir1,/atomicRenameDir2");
        String uriPrefix = "file:///";
        for (String s : negativeKeys = new String[]{"", "/", "bar", "bar/", "bar/hbase", "bar/hbase/foo", "bar/hbase/foo/", "/hbase/", "/hbase", "hbasexyz/", "foo/atomicRenameDir1/"}) {
            ITestNativeAzureFileSystemLive.assertFalse((boolean)store.isAtomicRenameKey(s));
            ITestNativeAzureFileSystemLive.assertFalse((boolean)store.isAtomicRenameKey(uriPrefix + s));
        }
        for (String s : positiveKeys = new String[]{"hbase/", "hbase/foo/", "hbase/foo/bar/", "atomicRenameDir1/foo/", "atomicRenameDir2/bar/"}) {
            ITestNativeAzureFileSystemLive.assertTrue((boolean)store.isAtomicRenameKey(s));
            ITestNativeAzureFileSystemLive.assertTrue((boolean)store.isAtomicRenameKey(uriPrefix + s));
        }
    }

    @Test
    public void testMkdirOnExistingFolderWithLease() throws Exception {
        Path path = this.methodPath();
        this.fs.mkdirs(path);
        NativeAzureFileSystem nfs = this.fs;
        String fullKey = nfs.pathToKey(nfs.makeAbsolute(path));
        AzureNativeFileSystemStore store = nfs.getStore();
        SelfRenewingLease lease = store.acquireLease(fullKey);
        ITestNativeAzureFileSystemLive.assertNotNull((String)"lease ID", (Object)(lease.getLeaseID() != null ? 1 : 0));
        store.storeEmptyFolder(fullKey, nfs.createPermissionStatus(FsPermission.getDirDefault()));
        lease.free();
    }
}

