/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.services.ExponentialRetryPolicy;
import org.junit.Assert;
import org.junit.Test;

public class TestExponentialRetryPolicy
extends AbstractAbfsIntegrationTest {
    private final int maxRetryCount = 30;
    private final int noRetryCount = 0;
    private final int retryCount = new Random().nextInt(30);
    private final int retryCountBeyondMax = 31;

    @Test
    public void testDifferentMaxIORetryCount() throws Exception {
        AbfsConfiguration abfsConfig = this.getAbfsConfig();
        abfsConfig.setMaxIoRetries(0);
        this.testMaxIOConfig(abfsConfig);
        abfsConfig.setMaxIoRetries(this.retryCount);
        this.testMaxIOConfig(abfsConfig);
        abfsConfig.setMaxIoRetries(31);
        this.testMaxIOConfig(abfsConfig);
    }

    @Test
    public void testDefaultMaxIORetryCount() throws Exception {
        AbfsConfiguration abfsConfig = this.getAbfsConfig();
        Assert.assertEquals((String)String.format("default maxIORetry count is %s.", 30), (long)30L, (long)abfsConfig.getMaxIoRetries());
        this.testMaxIOConfig(abfsConfig);
    }

    @Test
    public void testAbfsConfigConstructor() throws Exception {
        ExponentialRetryPolicy template = new ExponentialRetryPolicy(this.getAbfsConfig().getMaxIoRetries());
        int testModifier = 1;
        int expectedMaxRetries = template.getRetryCount() + testModifier;
        int expectedMinBackoff = template.getMinBackoff() + testModifier;
        int expectedMaxBackoff = template.getMaxBackoff() + testModifier;
        int expectedDeltaBackoff = template.getDeltaBackoff() + testModifier;
        Configuration config = new Configuration(this.getRawConfiguration());
        config.setInt("fs.azure.io.retry.max.retries", expectedMaxRetries);
        config.setInt("fs.azure.io.retry.min.backoff.interval", expectedMinBackoff);
        config.setInt("fs.azure.io.retry.max.backoff.interval", expectedMaxBackoff);
        config.setInt("fs.azure.io.retry.backoff.interval", expectedDeltaBackoff);
        ExponentialRetryPolicy policy = new ExponentialRetryPolicy(new AbfsConfiguration(config, "dummyAccountName"));
        Assert.assertEquals((String)"Max retry count was not set as expected.", (long)expectedMaxRetries, (long)policy.getRetryCount());
        Assert.assertEquals((String)"Min backoff interval was not set as expected.", (long)expectedMinBackoff, (long)policy.getMinBackoff());
        Assert.assertEquals((String)"Max backoff interval was not set as expected.", (long)expectedMaxBackoff, (long)policy.getMaxBackoff());
        Assert.assertEquals((String)"Delta backoff interval was not set as expected.", (long)expectedDeltaBackoff, (long)policy.getDeltaBackoff());
    }

    private AbfsConfiguration getAbfsConfig() throws Exception {
        Configuration config = new Configuration(this.getRawConfiguration());
        return new AbfsConfiguration(config, "dummyAccountName");
    }

    private void testMaxIOConfig(AbfsConfiguration abfsConfig) {
        int localRetryCount;
        ExponentialRetryPolicy retryPolicy = new ExponentialRetryPolicy(abfsConfig.getMaxIoRetries());
        for (localRetryCount = 0; localRetryCount < abfsConfig.getMaxIoRetries(); ++localRetryCount) {
            Assert.assertTrue((String)"Retry should be allowed when retryCount less than max count configured.", (boolean)retryPolicy.shouldRetry(localRetryCount, -1));
        }
        Assert.assertEquals((String)"When all retries are exhausted, the retryCount will be same as max configured", (long)abfsConfig.getMaxIoRetries(), (long)localRetryCount);
    }
}

