/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.contracts.services.AbfsPerfLoggable;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsPerfInfo;
import org.apache.hadoop.fs.azurebfs.services.AbfsPerfTracker;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestAbfsPerfTracker {
    private static final Logger LOG = LoggerFactory.getLogger(TestAbfsPerfTracker.class);
    private static ExecutorService executorService = null;
    private static final int TEST_AGGREGATE_COUNT = 42;
    private final String filesystemName = "bogusFilesystemName";
    private final String accountName = "bogusAccountName";
    private final URL url = new URL("http", "www.microsoft.com", "/bogusFile");

    @Before
    public void setUp() throws Exception {
        executorService = Executors.newCachedThreadPool();
    }

    @After
    public void tearDown() throws Exception {
        executorService.shutdown();
    }

    @Test
    public void verifyDisablingOfTracker() throws Exception {
        AbfsPerfTracker abfsPerfTracker = new AbfsPerfTracker("bogusAccountName", "bogusFilesystemName", false);
        String latencyDetails = abfsPerfTracker.getClientLatency();
        ((AbstractStringAssert)Assertions.assertThat((String)latencyDetails).describedAs("AbfsPerfTracker should be empty", new Object[0])).isNull();
        try (AbfsPerfInfo tracker = new AbfsPerfInfo(abfsPerfTracker, "disablingCaller", "disablingCallee");){
            AbfsHttpOperation op = new AbfsHttpOperation(this.url, "GET", new ArrayList());
            tracker.registerResult((AbfsPerfLoggable)op).registerSuccess(true);
        }
        latencyDetails = abfsPerfTracker.getClientLatency();
        ((AbstractStringAssert)Assertions.assertThat((String)latencyDetails).describedAs("AbfsPerfTracker should return no record", new Object[0])).isNull();
    }

    @Test
    public void verifyTrackingForSingletonLatencyRecords() throws Exception {
        int numTasks = 100;
        AbfsPerfTracker abfsPerfTracker = new AbfsPerfTracker("bogusAccountName", "bogusFilesystemName", true);
        String latencyDetails = abfsPerfTracker.getClientLatency();
        ((AbstractStringAssert)Assertions.assertThat((String)latencyDetails).describedAs("AbfsPerfTracker should be empty", new Object[0])).isNull();
        ArrayList<Callable<Integer>> tasks = new ArrayList<Callable<Integer>>();
        AbfsHttpOperation httpOperation = new AbfsHttpOperation(this.url, "GET", new ArrayList());
        for (int i = 0; i < 100; ++i) {
            tasks.add(() -> {
                try (AbfsPerfInfo tracker = new AbfsPerfInfo(abfsPerfTracker, "oneOperationCaller", "oneOperationCallee");){
                    tracker.registerResult((AbfsPerfLoggable)httpOperation).registerSuccess(true);
                    Integer n = 0;
                    return n;
                }
            });
        }
        for (Future fr : executorService.invokeAll(tasks)) {
            fr.get();
        }
        for (int i = 0; i < 100; ++i) {
            latencyDetails = abfsPerfTracker.getClientLatency();
            ((AbstractStringAssert)Assertions.assertThat((String)latencyDetails).describedAs("AbfsPerfTracker should return non-null record", new Object[0])).isNotNull();
            ((AbstractStringAssert)Assertions.assertThat((String)latencyDetails).describedAs("Latency record should be in the correct format", new Object[0])).containsPattern((CharSequence)"h=[^ ]* t=[^ ]* a=bogusFilesystemName c=bogusAccountName cr=oneOperationCaller ce=oneOperationCallee r=Succeeded l=[0-9]+ s=0 e= ci=[^ ]* ri=[^ ]* bs=0 br=0 m=GET u=http%3A%2F%2Fwww.microsoft.com%2FbogusFile");
        }
        latencyDetails = abfsPerfTracker.getClientLatency();
        ((AbstractStringAssert)Assertions.assertThat((String)latencyDetails).describedAs("AbfsPerfTracker should return no record", new Object[0])).isNull();
    }

    @Test
    public void verifyTrackingForAggregateLatencyRecords() throws Exception {
        int numTasks = 100;
        AbfsPerfTracker abfsPerfTracker = new AbfsPerfTracker("bogusAccountName", "bogusFilesystemName", true);
        String latencyDetails = abfsPerfTracker.getClientLatency();
        ((AbstractStringAssert)Assertions.assertThat((String)latencyDetails).describedAs("AbfsPerfTracker should be empty", new Object[0])).isNull();
        ArrayList<Callable<Integer>> tasks = new ArrayList<Callable<Integer>>();
        AbfsHttpOperation httpOperation = new AbfsHttpOperation(this.url, "GET", new ArrayList());
        for (int i = 0; i < 100; ++i) {
            tasks.add(() -> {
                try (AbfsPerfInfo tracker = new AbfsPerfInfo(abfsPerfTracker, "oneOperationCaller", "oneOperationCallee");){
                    tracker.registerResult((AbfsPerfLoggable)httpOperation).registerSuccess(true).registerAggregates(Instant.now(), 42L);
                    Integer n = 0;
                    return n;
                }
            });
        }
        for (Future fr : executorService.invokeAll(tasks)) {
            fr.get();
        }
        for (int i = 0; i < 100; ++i) {
            latencyDetails = abfsPerfTracker.getClientLatency();
            ((AbstractStringAssert)Assertions.assertThat((String)latencyDetails).describedAs("AbfsPerfTracker should return non-null record", new Object[0])).isNotNull();
            ((AbstractStringAssert)Assertions.assertThat((String)latencyDetails).describedAs("Latency record should be in the correct format", new Object[0])).containsPattern((CharSequence)"h=[^ ]* t=[^ ]* a=bogusFilesystemName c=bogusAccountName cr=oneOperationCaller ce=oneOperationCallee r=Succeeded l=[0-9]+ ls=[0-9]+ lc=42 s=0 e= ci=[^ ]* ri=[^ ]* bs=0 br=0 m=GET u=http%3A%2F%2Fwww.microsoft.com%2FbogusFile");
        }
        latencyDetails = abfsPerfTracker.getClientLatency();
        ((AbstractStringAssert)Assertions.assertThat((String)latencyDetails).describedAs("AbfsPerfTracker should return no record", new Object[0])).isNull();
    }

    @Test
    public void verifyRecordingSingletonLatencyIsCheapWhenDisabled() throws Exception {
        double maxLatencyWhenDisabledMs = 1000.0;
        double minLatencyWhenDisabledMs = 0.0;
        long numTasks = 1000L;
        long aggregateLatency = 0L;
        AbfsPerfTracker abfsPerfTracker = new AbfsPerfTracker("bogusAccountName", "bogusFilesystemName", false);
        ArrayList<Callable<Long>> tasks = new ArrayList<Callable<Long>>();
        AbfsHttpOperation httpOperation = new AbfsHttpOperation(this.url, "GET", new ArrayList());
        int i = 0;
        while ((long)i < 1000L) {
            tasks.add(() -> {
                Instant startRecord = Instant.now();
                try (AbfsPerfInfo tracker = new AbfsPerfInfo(abfsPerfTracker, "oneOperationCaller", "oneOperationCallee");){
                    tracker.registerResult((AbfsPerfLoggable)httpOperation).registerSuccess(true);
                }
                long latencyRecord = Duration.between(startRecord, Instant.now()).toMillis();
                LOG.debug("Spent {} ms in recording latency.", (Object)latencyRecord);
                return latencyRecord;
            });
            ++i;
        }
        for (Future fr : executorService.invokeAll(tasks)) {
            aggregateLatency += ((Long)fr.get()).longValue();
        }
        double averageRecordLatency = aggregateLatency / 1000L;
        ((AbstractDoubleAssert)Assertions.assertThat((double)averageRecordLatency).describedAs("Average time for recording singleton latencies should be bounded", new Object[0])).isBetween(Double.valueOf(0.0), Double.valueOf(1000.0));
    }

    @Test
    public void verifyRecordingAggregateLatencyIsCheapWhenDisabled() throws Exception {
        double maxLatencyWhenDisabledMs = 1000.0;
        double minLatencyWhenDisabledMs = 0.0;
        long numTasks = 1000L;
        long aggregateLatency = 0L;
        AbfsPerfTracker abfsPerfTracker = new AbfsPerfTracker("bogusAccountName", "bogusFilesystemName", false);
        ArrayList<Callable<Long>> tasks = new ArrayList<Callable<Long>>();
        AbfsHttpOperation httpOperation = new AbfsHttpOperation(this.url, "GET", new ArrayList());
        int i = 0;
        while ((long)i < 1000L) {
            tasks.add(() -> {
                Instant startRecord = Instant.now();
                try (AbfsPerfInfo tracker = new AbfsPerfInfo(abfsPerfTracker, "oneOperationCaller", "oneOperationCallee");){
                    tracker.registerResult((AbfsPerfLoggable)httpOperation).registerSuccess(true).registerAggregates(startRecord, 42L);
                }
                long latencyRecord = Duration.between(startRecord, Instant.now()).toMillis();
                LOG.debug("Spent {} ms in recording latency.", (Object)latencyRecord);
                return latencyRecord;
            });
            ++i;
        }
        for (Future fr : executorService.invokeAll(tasks)) {
            aggregateLatency += ((Long)fr.get()).longValue();
        }
        double averageRecordLatency = aggregateLatency / 1000L;
        ((AbstractDoubleAssert)Assertions.assertThat((double)averageRecordLatency).describedAs("Average time for recording aggregate latencies should be bounded", new Object[0])).isBetween(Double.valueOf(0.0), Double.valueOf(1000.0));
    }

    @Test
    public void verifyGettingLatencyRecordsIsCheapWhenDisabled() throws Exception {
        double maxLatencyWhenDisabledMs = 1000.0;
        double minLatencyWhenDisabledMs = 0.0;
        long numTasks = 1000L;
        long aggregateLatency = 0L;
        AbfsPerfTracker abfsPerfTracker = new AbfsPerfTracker("bogusAccountName", "bogusFilesystemName", false);
        ArrayList<Callable<Long>> tasks = new ArrayList<Callable<Long>>();
        int i = 0;
        while ((long)i < 1000L) {
            tasks.add(() -> {
                Instant startGet = Instant.now();
                abfsPerfTracker.getClientLatency();
                long latencyGet = Duration.between(startGet, Instant.now()).toMillis();
                LOG.debug("Spent {} ms in retrieving latency record.", (Object)latencyGet);
                return latencyGet;
            });
            ++i;
        }
        for (Future fr : executorService.invokeAll(tasks)) {
            aggregateLatency += ((Long)fr.get()).longValue();
        }
        double averageRecordLatency = aggregateLatency / 1000L;
        ((AbstractDoubleAssert)Assertions.assertThat((double)averageRecordLatency).describedAs("Average time for getting latency records should be bounded", new Object[0])).isBetween(Double.valueOf(0.0), Double.valueOf(1000.0));
    }

    @Test
    public void verifyRecordingSingletonLatencyIsCheapWhenEnabled() throws Exception {
        double maxLatencyWhenDisabledMs = 5000.0;
        double minLatencyWhenDisabledMs = 0.0;
        long numTasks = 1000L;
        long aggregateLatency = 0L;
        AbfsPerfTracker abfsPerfTracker = new AbfsPerfTracker("bogusAccountName", "bogusFilesystemName", true);
        ArrayList<Callable<Long>> tasks = new ArrayList<Callable<Long>>();
        AbfsHttpOperation httpOperation = new AbfsHttpOperation(this.url, "GET", new ArrayList());
        int i = 0;
        while ((long)i < 1000L) {
            tasks.add(() -> {
                Instant startRecord = Instant.now();
                try (AbfsPerfInfo tracker = new AbfsPerfInfo(abfsPerfTracker, "oneOperationCaller", "oneOperationCallee");){
                    tracker.registerResult((AbfsPerfLoggable)httpOperation).registerSuccess(true);
                }
                long latencyRecord = Duration.between(startRecord, Instant.now()).toMillis();
                LOG.debug("Spent {} ms in recording latency.", (Object)latencyRecord);
                return latencyRecord;
            });
            ++i;
        }
        for (Future fr : executorService.invokeAll(tasks)) {
            aggregateLatency += ((Long)fr.get()).longValue();
        }
        double averageRecordLatency = aggregateLatency / 1000L;
        ((AbstractDoubleAssert)Assertions.assertThat((double)averageRecordLatency).describedAs("Average time for recording singleton latencies should be bounded", new Object[0])).isBetween(Double.valueOf(0.0), Double.valueOf(5000.0));
    }

    @Test
    public void verifyRecordingAggregateLatencyIsCheapWhenEnabled() throws Exception {
        double maxLatencyWhenDisabledMs = 5000.0;
        double minLatencyWhenDisabledMs = 0.0;
        long numTasks = 1000L;
        long aggregateLatency = 0L;
        AbfsPerfTracker abfsPerfTracker = new AbfsPerfTracker("bogusAccountName", "bogusFilesystemName", true);
        ArrayList<Callable<Long>> tasks = new ArrayList<Callable<Long>>();
        AbfsHttpOperation httpOperation = new AbfsHttpOperation(this.url, "GET", new ArrayList());
        int i = 0;
        while ((long)i < 1000L) {
            tasks.add(() -> {
                Instant startRecord = Instant.now();
                try (AbfsPerfInfo tracker = new AbfsPerfInfo(abfsPerfTracker, "oneOperationCaller", "oneOperationCallee");){
                    tracker.registerResult((AbfsPerfLoggable)httpOperation).registerSuccess(true).registerAggregates(startRecord, 42L);
                }
                long latencyRecord = Duration.between(startRecord, Instant.now()).toMillis();
                LOG.debug("Spent {} ms in recording latency.", (Object)latencyRecord);
                return latencyRecord;
            });
            ++i;
        }
        for (Future fr : executorService.invokeAll(tasks)) {
            aggregateLatency += ((Long)fr.get()).longValue();
        }
        double averageRecordLatency = aggregateLatency / 1000L;
        ((AbstractDoubleAssert)Assertions.assertThat((double)averageRecordLatency).describedAs("Average time for recording aggregate latencies is bounded", new Object[0])).isBetween(Double.valueOf(0.0), Double.valueOf(5000.0));
    }

    @Test
    public void verifyGettingLatencyRecordsIsCheapWhenEnabled() throws Exception {
        double maxLatencyWhenDisabledMs = 5000.0;
        double minLatencyWhenDisabledMs = 0.0;
        long numTasks = 1000L;
        long aggregateLatency = 0L;
        AbfsPerfTracker abfsPerfTracker = new AbfsPerfTracker("bogusAccountName", "bogusFilesystemName", true);
        ArrayList<Callable<Long>> tasks = new ArrayList<Callable<Long>>();
        int i = 0;
        while ((long)i < 1000L) {
            tasks.add(() -> {
                Instant startRecord = Instant.now();
                abfsPerfTracker.getClientLatency();
                long latencyRecord = Duration.between(startRecord, Instant.now()).toMillis();
                LOG.debug("Spent {} ms in recording latency.", (Object)latencyRecord);
                return latencyRecord;
            });
            ++i;
        }
        for (Future fr : executorService.invokeAll(tasks)) {
            aggregateLatency += ((Long)fr.get()).longValue();
        }
        double averageRecordLatency = aggregateLatency / 1000L;
        ((AbstractDoubleAssert)Assertions.assertThat((double)averageRecordLatency).describedAs("Average time for getting latency records should be bounded", new Object[0])).isBetween(Double.valueOf(0.0), Double.valueOf(5000.0));
    }

    @Test
    public void verifyNoExceptionOnInvalidInput() throws Exception {
        Instant testInstant = Instant.now();
        AbfsPerfTracker abfsPerfTrackerDisabled = new AbfsPerfTracker("bogusAccountName", "bogusFilesystemName", false);
        AbfsPerfTracker abfsPerfTrackerEnabled = new AbfsPerfTracker("bogusAccountName", "bogusFilesystemName", true);
        AbfsHttpOperation httpOperation = new AbfsHttpOperation(this.url, "GET", new ArrayList());
        this.verifyNoException(abfsPerfTrackerDisabled);
        this.verifyNoException(abfsPerfTrackerEnabled);
    }

    private void verifyNoException(AbfsPerfTracker abfsPerfTracker) throws Exception {
        Instant testInstant = Instant.now();
        AbfsHttpOperation httpOperation = new AbfsHttpOperation(this.url, "GET", new ArrayList());
        try (AbfsPerfInfo tracker01 = new AbfsPerfInfo(abfsPerfTracker, null, null);
             AbfsPerfInfo tracker02 = new AbfsPerfInfo(abfsPerfTracker, "test", null);
             AbfsPerfInfo tracker03 = new AbfsPerfInfo(abfsPerfTracker, "test", "test");
             AbfsPerfInfo tracker04 = new AbfsPerfInfo(abfsPerfTracker, "test", "test");
             AbfsPerfInfo tracker05 = new AbfsPerfInfo(abfsPerfTracker, null, null);
             AbfsPerfInfo tracker06 = new AbfsPerfInfo(abfsPerfTracker, "test", null);
             AbfsPerfInfo tracker07 = new AbfsPerfInfo(abfsPerfTracker, "test", "test");
             AbfsPerfInfo tracker08 = new AbfsPerfInfo(abfsPerfTracker, "test", "test");
             AbfsPerfInfo tracker09 = new AbfsPerfInfo(abfsPerfTracker, "test", "test");
             AbfsPerfInfo tracker10 = new AbfsPerfInfo(abfsPerfTracker, "test", "test");
             AbfsPerfInfo tracker11 = new AbfsPerfInfo(abfsPerfTracker, "test", "test");
             AbfsPerfInfo tracker12 = new AbfsPerfInfo(abfsPerfTracker, "test", "test");
             AbfsPerfInfo tracker13 = new AbfsPerfInfo(abfsPerfTracker, "test", "test");){
            tracker01.registerResult(null).registerSuccess(false);
            tracker02.registerResult(null).registerSuccess(false);
            tracker03.registerResult(null).registerSuccess(false);
            tracker04.registerResult((AbfsPerfLoggable)httpOperation).registerSuccess(false);
            tracker05.registerResult(null).registerSuccess(false).registerAggregates(null, 0L);
            tracker06.registerResult(null).registerSuccess(false).registerAggregates(null, 0L);
            tracker07.registerResult(null).registerSuccess(false).registerAggregates(null, 0L);
            tracker08.registerResult((AbfsPerfLoggable)httpOperation).registerSuccess(false).registerAggregates(null, 0L);
            tracker09.registerResult((AbfsPerfLoggable)httpOperation).registerSuccess(false).registerAggregates(Instant.now(), 0L);
            tracker10.registerResult((AbfsPerfLoggable)httpOperation).registerSuccess(false).registerAggregates(Instant.now(), 42L);
            tracker11.registerResult((AbfsPerfLoggable)httpOperation).registerSuccess(false).registerAggregates(testInstant, 42L);
            tracker12.registerResult((AbfsPerfLoggable)httpOperation).registerSuccess(false).registerAggregates(Instant.MAX, 42L);
            tracker13.registerResult((AbfsPerfLoggable)httpOperation).registerSuccess(false).registerAggregates(Instant.MIN, 42L);
        }
    }

    public static AbfsPerfTracker getAPerfTrackerInstance(AbfsConfiguration abfsConfig) {
        AbfsPerfTracker tracker = new AbfsPerfTracker("test", abfsConfig.getAccountName(), abfsConfig);
        return tracker;
    }
}

