/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStream;
import org.apache.hadoop.fs.azurebfs.services.ReadBuffer;
import org.apache.hadoop.fs.azurebfs.services.ReadBufferManager;
import org.apache.hadoop.io.IOUtils;
import org.assertj.core.api.AbstractInputStreamAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;

public class ITestReadBufferManager
extends AbstractAbfsIntegrationTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPurgeBufferManagerForParallelStreams() throws Exception {
        this.describe("Testing purging of buffers from ReadBufferManager for parallel input streams", new Object[0]);
        int numBuffers = 16;
        LinkedList<Integer> freeList = new LinkedList<Integer>();
        for (int i = 0; i < 16; ++i) {
            freeList.add(i);
        }
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        AzureBlobFileSystem fs = this.getABFSWithReadAheadConfig();
        try {
            for (int i = 0; i < 4; ++i) {
                String fileName = this.methodName.getMethodName() + i;
                executorService.submit(() -> {
                    byte[] fileContent = this.getRandomBytesArray(0x100000);
                    Path testFilePath = this.createFileWithContent((FileSystem)fs, fileName, fileContent);
                    try (FSDataInputStream iStream = fs.open(testFilePath);){
                        iStream.read();
                    }
                    return null;
                });
            }
        }
        finally {
            executorService.shutdown();
        }
        ReadBufferManager bufferManager = ReadBufferManager.getBufferManager();
        this.assertListEmpty("CompletedList", bufferManager.getCompletedReadListCopy());
        this.assertListEmpty("InProgressList", bufferManager.getInProgressCopiedList());
        this.assertListEmpty("ReadAheadQueue", bufferManager.getReadAheadQueueCopy());
        ((ListAssert)((ListAssert)Assertions.assertThat((List)bufferManager.getFreeListCopy()).describedAs("After closing all streams free list contents should match with " + freeList, new Object[0])).hasSize(16)).containsExactlyInAnyOrderElementsOf(freeList);
    }

    private void assertListEmpty(String listName, List<ReadBuffer> list) {
        ((ListAssert)Assertions.assertThat(list).describedAs("After closing all streams %s should be empty", new Object[]{listName})).hasSize(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPurgeBufferManagerForSequentialStream() throws Exception {
        this.describe("Testing purging of buffers in ReadBufferManager for sequential input streams", new Object[0]);
        AzureBlobFileSystem fs = this.getABFSWithReadAheadConfig();
        String fileName = this.methodName.getMethodName();
        byte[] fileContent = this.getRandomBytesArray(0x100000);
        Path testFilePath = this.createFileWithContent((FileSystem)fs, fileName, fileContent);
        AbfsInputStream iStream1 = null;
        try {
            iStream1 = (AbfsInputStream)fs.open(testFilePath).getWrappedStream();
            iStream1.read();
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(iStream1);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)iStream1);
        ReadBufferManager bufferManager = ReadBufferManager.getBufferManager();
        AbfsInputStream iStream2 = null;
        try {
            iStream2 = (AbfsInputStream)fs.open(testFilePath).getWrappedStream();
            iStream2.read();
            this.assertListDoesnotContainBuffersForIstream(bufferManager.getInProgressCopiedList(), iStream1);
            this.assertListDoesnotContainBuffersForIstream(bufferManager.getCompletedReadListCopy(), iStream1);
            this.assertListDoesnotContainBuffersForIstream(bufferManager.getReadAheadQueueCopy(), iStream1);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(iStream2);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)iStream2);
        this.assertListDoesnotContainBuffersForIstream(bufferManager.getInProgressCopiedList(), iStream2);
        this.assertListDoesnotContainBuffersForIstream(bufferManager.getCompletedReadListCopy(), iStream2);
        this.assertListDoesnotContainBuffersForIstream(bufferManager.getReadAheadQueueCopy(), iStream2);
        this.assertListEmpty("CompletedList", bufferManager.getCompletedReadListCopy());
        this.assertListEmpty("InProgressList", bufferManager.getInProgressCopiedList());
        this.assertListEmpty("ReadAheadQueue", bufferManager.getReadAheadQueueCopy());
    }

    private void assertListDoesnotContainBuffersForIstream(List<ReadBuffer> list, AbfsInputStream inputStream) {
        for (ReadBuffer buffer : list) {
            ((AbstractInputStreamAssert)Assertions.assertThat((InputStream)buffer.getStream()).describedAs("Buffers associated with closed input streams shouldn't be present", new Object[0])).isNotEqualTo((Object)inputStream);
        }
    }

    private AzureBlobFileSystem getABFSWithReadAheadConfig() throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.setLong("fs.azure.readaheadqueue.depth", 8L);
        conf.setInt("fs.azure.read.request.size", 16384);
        conf.setInt("fs.azure.read.readahead.blocksize", 16384);
        return (AzureBlobFileSystem)FileSystem.newInstance((Configuration)conf);
    }

    protected byte[] getRandomBytesArray(int length) {
        byte[] b = new byte[length];
        new Random().nextBytes(b);
        return b;
    }

    protected Path createFileWithContent(FileSystem fs, String fileName, byte[] fileContent) throws IOException {
        Path testFilePath = this.path(fileName);
        try (FSDataOutputStream oStream = fs.create(testFilePath);){
            oStream.write(fileContent);
            oStream.flush();
        }
        return testFilePath;
    }
}

