/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.ITestAbfsReadWriteAndSeek;
import org.apache.hadoop.fs.azurebfs.ITestAzureBlobFileSystemAppend;
import org.apache.hadoop.fs.azurebfs.ITestAzureBlobFileSystemAttributes;
import org.apache.hadoop.fs.azurebfs.ITestAzureBlobFileSystemCreate;
import org.apache.hadoop.fs.azurebfs.ITestAzureBlobFileSystemDelete;
import org.apache.hadoop.fs.azurebfs.ITestAzureBlobFileSystemFlush;
import org.apache.hadoop.fs.azurebfs.ITestAzureBlobFileSystemListStatus;
import org.apache.hadoop.fs.azurebfs.ITestAzureBlobFilesystemAcl;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.enums.Trilean;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.azurebfs.utils.Listener;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderFormat;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderValidator;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.AssumptionViolatedException;
import org.junit.Ignore;
import org.junit.Test;

public class TestTracingContext
extends AbstractAbfsIntegrationTest {
    private static final String[] CLIENT_CORRELATIONID_LIST = new String[]{"valid-corr-id-123", "inval!d", ""};
    private static final int HTTP_CREATED = 201;

    @Test
    public void testClientCorrelationId() throws Exception {
        this.checkCorrelationConfigValidation(CLIENT_CORRELATIONID_LIST[0], true);
        this.checkCorrelationConfigValidation(CLIENT_CORRELATIONID_LIST[1], false);
        this.checkCorrelationConfigValidation(CLIENT_CORRELATIONID_LIST[2], false);
    }

    private String getOctalNotation(FsPermission fsPermission) {
        Preconditions.checkNotNull((Object)fsPermission, (Object)"fsPermission");
        return String.format("%04d", fsPermission.toOctal());
    }

    private String getRelativePath(Path path) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        return path.toUri().getPath();
    }

    public void checkCorrelationConfigValidation(String clientCorrelationId, boolean includeInHeader) throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.set("fs.azure.client.correlationid", clientCorrelationId);
        AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)conf);
        String correlationID = fs.getClientCorrelationId();
        if (includeInHeader) {
            ((AbstractStringAssert)Assertions.assertThat((String)correlationID).describedAs("Correlation ID should match config when valid", new Object[0])).isEqualTo((Object)clientCorrelationId);
        } else {
            ((AbstractStringAssert)Assertions.assertThat((String)correlationID).describedAs("Invalid ID should be replaced with empty string", new Object[0])).isEqualTo((Object)"");
        }
        TracingContext tracingContext = new TracingContext(clientCorrelationId, fs.getFileSystemId(), FSOperationType.TEST_OP, TracingHeaderFormat.ALL_ID_FORMAT, null);
        boolean isNamespaceEnabled = fs.getIsNamespaceEnabled(tracingContext);
        String path = this.getRelativePath(new Path("/testDir"));
        String permission = isNamespaceEnabled ? this.getOctalNotation(FsPermission.getDirDefault()) : null;
        String umask = isNamespaceEnabled ? this.getOctalNotation(FsPermission.getUMask((Configuration)fs.getConf())) : null;
        AbfsRestOperation op = fs.getAbfsClient().createPath(path, false, true, permission, umask, false, null, tracingContext);
        int statusCode = op.getResult().getStatusCode();
        ((AbstractIntegerAssert)Assertions.assertThat((int)statusCode).describedAs("Request should not fail", new Object[0])).isEqualTo(201);
        String requestHeader = op.getResult().getClientRequestId().replace("[", "").replace("]", "");
        ((AbstractStringAssert)Assertions.assertThat((String)requestHeader).describedAs("Client Request Header should match TracingContext", new Object[0])).isEqualTo((Object)tracingContext.getHeader());
    }

    @Ignore
    @Test
    public void runCorrelationTestForAllMethods() throws Exception {
        HashMap<AbstractAbfsIntegrationTest, Method> testClasses = new HashMap<AbstractAbfsIntegrationTest, Method>();
        testClasses.put(new ITestAzureBlobFileSystemListStatus(), ITestAzureBlobFileSystemListStatus.class.getMethod("testListPath", new Class[0]));
        testClasses.put(new ITestAbfsReadWriteAndSeek(16384), ITestAbfsReadWriteAndSeek.class.getMethod("testReadAheadRequestID", new Class[0]));
        testClasses.put(new ITestAbfsReadWriteAndSeek(16384), ITestAbfsReadWriteAndSeek.class.getMethod("testReadAndWriteWithDifferentBufferSizesAndSeek", new Class[0]));
        testClasses.put(new ITestAzureBlobFileSystemAppend(), ITestAzureBlobFileSystemAppend.class.getMethod("testTracingForAppend", new Class[0]));
        testClasses.put(new ITestAzureBlobFileSystemFlush(), ITestAzureBlobFileSystemFlush.class.getMethod("testTracingHeaderForAppendBlob", new Class[0]));
        testClasses.put(new ITestAzureBlobFileSystemCreate(), ITestAzureBlobFileSystemCreate.class.getMethod("testDefaultCreateOverwriteFileTest", new Class[0]));
        testClasses.put(new ITestAzureBlobFilesystemAcl(), ITestAzureBlobFilesystemAcl.class.getMethod("testDefaultAclRenamedFile", new Class[0]));
        testClasses.put(new ITestAzureBlobFileSystemDelete(), ITestAzureBlobFileSystemDelete.class.getMethod("testDeleteFirstLevelDirectory", new Class[0]));
        testClasses.put(new ITestAzureBlobFileSystemCreate(), ITestAzureBlobFileSystemCreate.class.getMethod("testCreateNonRecursive", new Class[0]));
        testClasses.put(new ITestAzureBlobFileSystemAttributes(), ITestAzureBlobFileSystemAttributes.class.getMethod("testSetGetXAttr", new Class[0]));
        testClasses.put(new ITestAzureBlobFilesystemAcl(), ITestAzureBlobFilesystemAcl.class.getMethod("testEnsureAclOperationWorksForRoot", new Class[0]));
        for (AbstractAbfsIntegrationTest testClass : testClasses.keySet()) {
            try {
                testClass.setup();
                ((Method)testClasses.get((Object)testClass)).invoke((Object)testClass, new Object[0]);
                testClass.teardown();
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof AssumptionViolatedException) continue;
                throw new IOException(((Method)testClasses.get((Object)testClass)).getName() + " failed tracing context validation test");
            }
        }
    }

    @Test
    public void testExternalOps() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.registerListener((Listener)new TracingHeaderValidator(fs.getAbfsStore().getAbfsConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.HAS_PATH_CAPABILITY, false, 0));
        fs.getAbfsStore().setNamespaceEnabled(Trilean.UNKNOWN);
        fs.hasPathCapability(new Path("/"), "fs.capability.paths.acls");
        Assume.assumeTrue((boolean)this.getIsNamespaceEnabled(this.getFileSystem()));
        Assume.assumeTrue((boolean)this.getConfiguration().isCheckAccessEnabled());
        Assume.assumeTrue((this.getAuthType() == AuthType.OAuth ? 1 : 0) != 0);
        fs.setListenerOperation(FSOperationType.ACCESS);
        fs.getAbfsStore().setNamespaceEnabled(Trilean.TRUE);
        fs.access(new Path("/"), FsAction.READ);
    }
}

