/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.contracts.services.AppendRequestParameters;
import org.apache.hadoop.fs.azurebfs.services.AbfsAclHelper;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpHeader;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.azurebfs.utils.AclTestHelpers;
import org.apache.hadoop.fs.azurebfs.utils.Base64;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITestCustomerProvidedKey
extends AbstractAbfsIntegrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(ITestCustomerProvidedKey.class);
    private static final String XMS_PROPERTIES_ENCODING = "ISO-8859-1";
    private static final int INT_512 = 512;
    private static final int INT_50 = 50;
    private static final int ENCRYPTION_KEY_LEN = 32;
    private static final int FILE_SIZE = 0xA00000;
    private static final int FILE_SIZE_FOR_COPY_BETWEEN_ACCOUNTS = 0x1800000;

    public ITestCustomerProvidedKey() throws Exception {
        boolean isCPKTestsEnabled = this.getConfiguration().getBoolean("fs.azure.test.cpk.enabled", false);
        Assume.assumeTrue((boolean)isCPKTestsEnabled);
    }

    @Test
    public void testReadWithCPK() throws Exception {
        byte[] b;
        int len;
        FSDataInputStream iStream;
        AzureBlobFileSystem fs = this.getAbfs(true);
        String fileName = "/" + this.methodName.getMethodName();
        this.createFileAndGetContent(fs, fileName, 0xA00000);
        AbfsClient abfsClient = fs.getAbfsClient();
        int length = 0xA00000;
        byte[] buffer = new byte[length];
        TracingContext tracingContext = this.getTestTracingContext(fs, false);
        AbfsRestOperation op = abfsClient.getPathStatus(fileName, false, tracingContext);
        String eTag = op.getResult().getResponseHeader("ETag");
        AbfsRestOperation abfsRestOperation = abfsClient.read(fileName, 0L, buffer, 0, length, eTag, null, tracingContext);
        this.assertCPKHeaders(abfsRestOperation, true);
        this.assertResponseHeader(abfsRestOperation, true, "x-ms-encryption-key-sha256", this.getCPKSha(fs));
        this.assertResponseHeader(abfsRestOperation, true, "x-ms-server-encrypted", "true");
        this.assertResponseHeader(abfsRestOperation, false, "x-ms-request-server-encrypted", "");
        Configuration conf = fs.getConf();
        String accountName = conf.get("fs.azure.abfs.account.name");
        conf.set("fs.azure.client-provided-encryption-key." + accountName, "different-1234567890123456789012");
        try (AzureBlobFileSystem fs2 = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)conf);){
            iStream = fs2.open(new Path(fileName));
            try {
                len = 0x800000;
                b = new byte[len];
                LambdaTestUtils.intercept(IOException.class, () -> iStream.read(b, 0, len));
            }
            finally {
                if (iStream != null) {
                    iStream.close();
                }
            }
        }
        conf.unset("fs.azure.client-provided-encryption-key." + accountName);
        try (AzureBlobFileSystem fs3 = (AzureBlobFileSystem)FileSystem.get((Configuration)conf);){
            iStream = fs3.open(new Path(fileName));
            try {
                len = 0x800000;
                b = new byte[len];
                LambdaTestUtils.intercept(IOException.class, () -> iStream.read(b, 0, len));
            }
            finally {
                if (iStream != null) {
                    iStream.close();
                }
            }
        }
    }

    @Test
    public void testReadWithoutCPK() throws Exception {
        AzureBlobFileSystem fs = this.getAbfs(false);
        String fileName = "/" + this.methodName.getMethodName();
        this.createFileAndGetContent(fs, fileName, 0xA00000);
        AbfsClient abfsClient = fs.getAbfsClient();
        int length = 512;
        byte[] buffer = new byte[length * 4];
        TracingContext tracingContext = this.getTestTracingContext(fs, false);
        AbfsRestOperation op = abfsClient.getPathStatus(fileName, false, tracingContext);
        String eTag = op.getResult().getResponseHeader("ETag");
        AbfsRestOperation abfsRestOperation = abfsClient.read(fileName, 0L, buffer, 0, length, eTag, null, tracingContext);
        this.assertCPKHeaders(abfsRestOperation, false);
        this.assertResponseHeader(abfsRestOperation, false, "x-ms-encryption-key-sha256", this.getCPKSha(fs));
        this.assertResponseHeader(abfsRestOperation, true, "x-ms-server-encrypted", "true");
        this.assertResponseHeader(abfsRestOperation, false, "x-ms-request-server-encrypted", "");
        Configuration conf = fs.getConf();
        String accountName = conf.get("fs.azure.abfs.account.name");
        conf.set("fs.azure.client-provided-encryption-key." + accountName, "12345678901234567890123456789012");
        try (AzureBlobFileSystem fs2 = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)conf);
             AbfsClient abfsClient2 = fs2.getAbfsClient();){
            LambdaTestUtils.intercept(IOException.class, () -> abfsClient2.read(fileName, 0L, buffer, 0, length, eTag, null, this.getTestTracingContext(fs, false)));
        }
    }

    @Test
    public void testAppendWithCPK() throws Exception {
        AzureBlobFileSystem fs = this.getAbfs(true);
        String fileName = "/" + this.methodName.getMethodName();
        this.createFileAndGetContent(fs, fileName, 0xA00000);
        AppendRequestParameters appendRequestParameters = new AppendRequestParameters(0L, 0, 5, AppendRequestParameters.Mode.APPEND_MODE, false, null);
        byte[] buffer = this.getRandomBytesArray(5);
        AbfsClient abfsClient = fs.getAbfsClient();
        AbfsRestOperation abfsRestOperation = abfsClient.append(fileName, buffer, appendRequestParameters, null, this.getTestTracingContext(fs, false));
        this.assertCPKHeaders(abfsRestOperation, true);
        this.assertResponseHeader(abfsRestOperation, true, "x-ms-encryption-key-sha256", this.getCPKSha(fs));
        this.assertResponseHeader(abfsRestOperation, false, "x-ms-server-encrypted", "");
        this.assertResponseHeader(abfsRestOperation, true, "x-ms-request-server-encrypted", "true");
        Configuration conf = fs.getConf();
        String accountName = conf.get("fs.azure.abfs.account.name");
        conf.set("fs.azure.client-provided-encryption-key." + accountName, "different-1234567890123456789012");
        try (AzureBlobFileSystem fs2 = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)conf);
             AbfsClient abfsClient2 = fs2.getAbfsClient();){
            LambdaTestUtils.intercept(IOException.class, () -> abfsClient2.append(fileName, buffer, appendRequestParameters, null, this.getTestTracingContext(fs, false)));
        }
        conf.unset("fs.azure.client-provided-encryption-key." + accountName);
        try (AzureBlobFileSystem fs3 = (AzureBlobFileSystem)FileSystem.get((Configuration)conf);
             AbfsClient abfsClient3 = fs3.getAbfsClient();){
            LambdaTestUtils.intercept(IOException.class, () -> abfsClient3.append(fileName, buffer, appendRequestParameters, null, this.getTestTracingContext(fs, false)));
        }
    }

    @Test
    public void testAppendWithoutCPK() throws Exception {
        AzureBlobFileSystem fs = this.getAbfs(false);
        String fileName = "/" + this.methodName.getMethodName();
        this.createFileAndGetContent(fs, fileName, 0xA00000);
        AppendRequestParameters appendRequestParameters = new AppendRequestParameters(0L, 0, 5, AppendRequestParameters.Mode.APPEND_MODE, false, null);
        byte[] buffer = this.getRandomBytesArray(5);
        AbfsClient abfsClient = fs.getAbfsClient();
        AbfsRestOperation abfsRestOperation = abfsClient.append(fileName, buffer, appendRequestParameters, null, this.getTestTracingContext(fs, false));
        this.assertCPKHeaders(abfsRestOperation, false);
        this.assertResponseHeader(abfsRestOperation, false, "x-ms-encryption-key-sha256", "");
        this.assertResponseHeader(abfsRestOperation, false, "x-ms-server-encrypted", "");
        this.assertResponseHeader(abfsRestOperation, true, "x-ms-request-server-encrypted", "true");
        Configuration conf = fs.getConf();
        String accountName = conf.get("fs.azure.abfs.account.name");
        conf.set("fs.azure.client-provided-encryption-key." + accountName, "12345678901234567890123456789012");
        try (AzureBlobFileSystem fs2 = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)conf);
             AbfsClient abfsClient2 = fs2.getAbfsClient();){
            LambdaTestUtils.intercept(IOException.class, () -> abfsClient2.append(fileName, buffer, appendRequestParameters, null, this.getTestTracingContext(fs, false)));
        }
    }

    @Test
    public void testSetGetXAttr() throws Exception {
        AzureBlobFileSystem fs = this.getAbfs(true);
        String fileName = this.methodName.getMethodName();
        this.createFileAndGetContent(fs, fileName, 0xA00000);
        String valSent = "testValue";
        String attrName = "testXAttr";
        fs.setXAttr(new Path(fileName), attrName, valSent.getBytes(StandardCharsets.UTF_8), EnumSet.of(XAttrSetFlag.CREATE));
        byte[] valBytes = fs.getXAttr(new Path(fileName), attrName);
        String valRecieved = new String(valBytes);
        ITestCustomerProvidedKey.assertEquals((Object)valSent, (Object)valRecieved);
        valSent = "new value";
        fs.setXAttr(new Path(fileName), attrName, valSent.getBytes(StandardCharsets.UTF_8), EnumSet.of(XAttrSetFlag.REPLACE));
        valBytes = fs.getXAttr(new Path(fileName), attrName);
        valRecieved = new String(valBytes);
        ITestCustomerProvidedKey.assertEquals((Object)valSent, (Object)valRecieved);
        LambdaTestUtils.intercept(IOException.class, () -> this.getAbfs(false).getXAttr(new Path(fileName), attrName));
        LambdaTestUtils.intercept(IOException.class, () -> this.getSameFSWithWrongCPK(fs).getXAttr(new Path(fileName), attrName));
    }

    @Test
    public void testCopyBetweenAccounts() throws Exception {
        byte[] buffer;
        int length;
        FSDataInputStream iStream;
        String accountName = this.getRawConfiguration().get("fs.azure.test.cpk-enabled-secondary-account");
        String accountKey = this.getRawConfiguration().get("fs.azure.test.cpk-enabled-secondary-account.key");
        Assume.assumeTrue((accountName != null && !accountName.isEmpty() ? 1 : 0) != 0);
        Assume.assumeTrue((accountKey != null && !accountKey.isEmpty() ? 1 : 0) != 0);
        String fileSystemName = "cpkfs";
        AzureBlobFileSystem fs1 = this.getAbfs(true);
        int fileSize = 0x1800000;
        byte[] fileContent = this.getRandomBytesArray(fileSize);
        Path testFilePath = this.createFileWithContent((FileSystem)fs1, "fs1-file.txt", fileContent);
        Configuration conf = new Configuration();
        conf.addResource("azure-test.xml");
        conf.setBoolean("fs.azure.createRemoteFileSystemDuringInitialization", true);
        conf.unset("fs.azure.abfs.account.name");
        conf.set("fs.azure.abfs.account.name", accountName);
        conf.set("fs.azure.account.key." + accountName, accountKey);
        conf.set("fs.azure.client-provided-encryption-key." + accountName, "123456789012345678901234567890ab");
        conf.set("fs.defaultFS", "abfs://" + fileSystemName + "@" + accountName);
        AzureBlobFileSystem fs2 = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)conf);
        Path fs2DestFilePath = new Path("fs2-dest-file.txt");
        FSDataOutputStream ops = fs2.create(fs2DestFilePath);
        try (FSDataInputStream iStream2 = fs1.open(testFilePath);){
            int bytesRead;
            long totalBytesRead = 0L;
            do {
                int length2 = 0x800000;
                byte[] buffer2 = new byte[length2];
                bytesRead = iStream2.read(buffer2, 0, length2);
                ops.write(buffer2);
            } while ((totalBytesRead += (long)bytesRead) < (long)fileContent.length);
            ops.close();
        }
        conf.unset("fs.azure.client-provided-encryption-key." + accountName);
        conf.set("fs.azure.client-provided-encryption-key." + accountName, "different-1234567890123456789012");
        try (AzureBlobFileSystem fs3 = (AzureBlobFileSystem)FileSystem.get((Configuration)conf);){
            iStream = fs3.open(fs2DestFilePath);
            try {
                length = 0x800000;
                buffer = new byte[length];
                LambdaTestUtils.intercept(IOException.class, () -> iStream.read(buffer, 0, length));
            }
            finally {
                if (iStream != null) {
                    iStream.close();
                }
            }
        }
        conf.unset("fs.azure.client-provided-encryption-key." + accountName);
        try (AzureBlobFileSystem fs4 = (AzureBlobFileSystem)FileSystem.get((Configuration)conf);){
            iStream = fs4.open(fs2DestFilePath);
            try {
                length = 0x800000;
                buffer = new byte[length];
                LambdaTestUtils.intercept(IOException.class, () -> iStream.read(buffer, 0, length));
            }
            finally {
                if (iStream != null) {
                    iStream.close();
                }
            }
        }
        iStream2 = fs2.open(fs2DestFilePath);
        try {
            long totalBytesRead = 0L;
            int pos = 0;
            do {
                int length3 = 0x800000;
                byte[] buffer3 = new byte[length3];
                int bytesRead = iStream2.read(buffer3, 0, length3);
                totalBytesRead += (long)bytesRead;
                for (int i = 0; i < bytesRead; ++i) {
                    ITestCustomerProvidedKey.assertEquals((long)fileContent[pos + i], (long)buffer3[i]);
                }
                pos += bytesRead;
            } while (totalBytesRead < (long)fileContent.length);
        }
        finally {
            if (iStream2 != null) {
                iStream2.close();
            }
        }
    }

    @Test
    public void testListPathWithCPK() throws Exception {
        this.testListPath(true);
    }

    @Test
    public void testListPathWithoutCPK() throws Exception {
        this.testListPath(false);
    }

    private void testListPath(boolean isWithCPK) throws Exception {
        AzureBlobFileSystem fs = this.getAbfs(isWithCPK);
        String testDirName = "/" + this.methodName.getMethodName();
        Path testPath = new Path(testDirName);
        fs.mkdirs(testPath);
        this.createFileAndGetContent(fs, testDirName + "/aaa", 0xA00000);
        this.createFileAndGetContent(fs, testDirName + "/bbb", 0xA00000);
        AbfsClient abfsClient = fs.getAbfsClient();
        AbfsRestOperation abfsRestOperation = abfsClient.listPath(testDirName, false, 50, null, this.getTestTracingContext(fs, false));
        this.assertListstatus(fs, abfsRestOperation, testPath);
        Configuration conf = fs.getConf();
        String accountName = conf.get("fs.azure.abfs.account.name");
        conf.set("fs.azure.client-provided-encryption-key." + accountName, "different-1234567890123456789012");
        AzureBlobFileSystem fs2 = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)conf);
        AbfsClient abfsClient2 = fs2.getAbfsClient();
        TracingContext tracingContext = this.getTestTracingContext(fs, false);
        abfsRestOperation = abfsClient2.listPath(testDirName, false, 50, null, tracingContext);
        this.assertListstatus(fs, abfsRestOperation, testPath);
        if (isWithCPK) {
            conf.unset("fs.azure.client-provided-encryption-key." + accountName);
            AzureBlobFileSystem fs3 = (AzureBlobFileSystem)FileSystem.get((Configuration)conf);
            AbfsClient abfsClient3 = fs3.getAbfsClient();
            abfsRestOperation = abfsClient3.listPath(testDirName, false, 50, null, tracingContext);
            this.assertListstatus(fs, abfsRestOperation, testPath);
        }
    }

    private void assertListstatus(AzureBlobFileSystem fs, AbfsRestOperation abfsRestOperation, Path testPath) throws IOException {
        this.assertCPKHeaders(abfsRestOperation, false);
        this.assertNoCPKResponseHeadersPresent(abfsRestOperation);
        FileStatus[] listStatuses = fs.listStatus(testPath);
        ((AbstractIntegerAssert)Assertions.assertThat((int)listStatuses.length).describedAs("listStatuses should have 2 entries", new Object[0])).isEqualTo(2);
        listStatuses = this.getSameFSWithWrongCPK(fs).listStatus(testPath);
        ((AbstractIntegerAssert)Assertions.assertThat((int)listStatuses.length).describedAs("listStatuses should have 2 entries", new Object[0])).isEqualTo(2);
    }

    @Test
    public void testCreatePathWithCPK() throws Exception {
        this.testCreatePath(true);
    }

    @Test
    public void testCreatePathWithoutCPK() throws Exception {
        this.testCreatePath(false);
    }

    private void testCreatePath(boolean isWithCPK) throws Exception {
        AzureBlobFileSystem fs = this.getAbfs(isWithCPK);
        String testFileName = "/" + this.methodName.getMethodName();
        this.createFileAndGetContent(fs, testFileName, 0xA00000);
        AbfsClient abfsClient = fs.getAbfsClient();
        FsPermission permission = new FsPermission(FsAction.EXECUTE, FsAction.EXECUTE, FsAction.EXECUTE);
        FsPermission umask = new FsPermission(FsAction.NONE, FsAction.NONE, FsAction.NONE);
        TracingContext tracingContext = this.getTestTracingContext(fs, false);
        boolean isNamespaceEnabled = fs.getIsNamespaceEnabled(tracingContext);
        AbfsRestOperation abfsRestOperation = abfsClient.createPath(testFileName, true, true, isNamespaceEnabled ? this.getOctalNotation(permission) : null, isNamespaceEnabled ? this.getOctalNotation(umask) : null, false, null, tracingContext);
        this.assertCPKHeaders(abfsRestOperation, isWithCPK);
        this.assertResponseHeader(abfsRestOperation, isWithCPK, "x-ms-encryption-key-sha256", this.getCPKSha(fs));
        this.assertResponseHeader(abfsRestOperation, false, "x-ms-server-encrypted", "");
        this.assertResponseHeader(abfsRestOperation, true, "x-ms-request-server-encrypted", "true");
        FileStatus[] listStatuses = fs.listStatus(new Path(testFileName));
        ((AbstractIntegerAssert)Assertions.assertThat((int)listStatuses.length).describedAs("listStatuses should have 1 entry", new Object[0])).isEqualTo(1);
        listStatuses = this.getSameFSWithWrongCPK(fs).listStatus(new Path(testFileName));
        ((AbstractIntegerAssert)Assertions.assertThat((int)listStatuses.length).describedAs("listStatuses should have 1 entry", new Object[0])).isEqualTo(1);
    }

    @Test
    public void testRenamePathWithCPK() throws Exception {
        this.testRenamePath(true);
    }

    @Test
    public void testRenamePathWithoutCPK() throws Exception {
        this.testRenamePath(false);
    }

    private void testRenamePath(boolean isWithCPK) throws Exception {
        AzureBlobFileSystem fs = this.getAbfs(isWithCPK);
        String testFileName = "/" + this.methodName.getMethodName();
        this.createFileAndGetContent(fs, testFileName, 0xA00000);
        FileStatus fileStatusBeforeRename = fs.getFileStatus(new Path(testFileName));
        String newName = "/newName";
        AbfsClient abfsClient = fs.getAbfsClient();
        AbfsRestOperation abfsRestOperation = abfsClient.renamePath(testFileName, newName, null, this.getTestTracingContext(fs, false));
        this.assertCPKHeaders(abfsRestOperation, false);
        this.assertNoCPKResponseHeadersPresent(abfsRestOperation);
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> fs.getFileStatus(new Path(testFileName)));
        FileStatus fileStatusAfterRename = fs.getFileStatus(new Path(newName));
        ((AbstractLongAssert)Assertions.assertThat((long)fileStatusAfterRename.getLen()).describedAs("File size has to be same before and after rename", new Object[0])).isEqualTo(fileStatusBeforeRename.getLen());
    }

    @Test
    public void testFlushWithCPK() throws Exception {
        this.testFlush(true);
    }

    @Test
    public void testFlushWithoutCPK() throws Exception {
        this.testFlush(false);
    }

    private void testFlush(boolean isWithCPK) throws Exception {
        AzureBlobFileSystem fs = this.getAbfs(isWithCPK);
        String testFileName = "/" + this.methodName.getMethodName();
        fs.create(new Path(testFileName));
        AbfsClient abfsClient = fs.getAbfsClient();
        String expectedCPKSha = this.getCPKSha(fs);
        byte[] fileContent = this.getRandomBytesArray(0xA00000);
        Path testFilePath = new Path(testFileName + "1");
        FSDataOutputStream oStream = fs.create(testFilePath);
        oStream.write(fileContent);
        Configuration conf = fs.getConf();
        String accountName = conf.get("fs.azure.abfs.account.name");
        conf.set("fs.azure.client-provided-encryption-key." + accountName, "different-1234567890123456789012");
        try (AzureBlobFileSystem fs2 = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)conf);
             AbfsClient abfsClient2 = fs2.getAbfsClient();){
            LambdaTestUtils.intercept(IOException.class, () -> abfsClient2.flush(testFileName, 0L, false, false, null, null, this.getTestTracingContext(fs, false)));
        }
        if (isWithCPK) {
            conf.unset("fs.azure.client-provided-encryption-key." + accountName);
            try (AzureBlobFileSystem fs3 = (AzureBlobFileSystem)FileSystem.get((Configuration)conf);
                 AbfsClient abfsClient3 = fs3.getAbfsClient();){
                LambdaTestUtils.intercept(IOException.class, () -> abfsClient3.flush(testFileName, 0L, false, false, null, null, this.getTestTracingContext(fs, false)));
            }
        }
        AbfsRestOperation abfsRestOperation = abfsClient.flush(testFileName, 0L, false, false, null, null, this.getTestTracingContext(fs, false));
        this.assertCPKHeaders(abfsRestOperation, isWithCPK);
        this.assertResponseHeader(abfsRestOperation, isWithCPK, "x-ms-encryption-key-sha256", expectedCPKSha);
        this.assertResponseHeader(abfsRestOperation, false, "x-ms-server-encrypted", "");
        this.assertResponseHeader(abfsRestOperation, true, "x-ms-request-server-encrypted", isWithCPK + "");
    }

    @Test
    public void testSetPathPropertiesWithCPK() throws Exception {
        this.testSetPathProperties(true);
    }

    @Test
    public void testSetPathPropertiesWithoutCPK() throws Exception {
        this.testSetPathProperties(false);
    }

    private void testSetPathProperties(boolean isWithCPK) throws Exception {
        AzureBlobFileSystem fs = this.getAbfs(isWithCPK);
        String testFileName = "/" + this.methodName.getMethodName();
        this.createFileAndGetContent(fs, testFileName, 0xA00000);
        AbfsClient abfsClient = fs.getAbfsClient();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("key", "val");
        AbfsRestOperation abfsRestOperation = abfsClient.setPathProperties(testFileName, this.convertXmsPropertiesToCommaSeparatedString(properties), this.getTestTracingContext(fs, false));
        this.assertCPKHeaders(abfsRestOperation, isWithCPK);
        this.assertResponseHeader(abfsRestOperation, isWithCPK, "x-ms-encryption-key-sha256", this.getCPKSha(fs));
        this.assertResponseHeader(abfsRestOperation, false, "x-ms-server-encrypted", "");
        this.assertResponseHeader(abfsRestOperation, true, "x-ms-request-server-encrypted", "true");
    }

    @Test
    public void testGetPathStatusFileWithCPK() throws Exception {
        this.testGetPathStatusFile(true);
    }

    @Test
    public void testGetPathStatusFileWithoutCPK() throws Exception {
        this.testGetPathStatusFile(false);
    }

    private void testGetPathStatusFile(boolean isWithCPK) throws Exception {
        AzureBlobFileSystem fs = this.getAbfs(isWithCPK);
        String testFileName = "/" + this.methodName.getMethodName();
        this.createFileAndGetContent(fs, testFileName, 0xA00000);
        AbfsClient abfsClient = fs.getAbfsClient();
        TracingContext tracingContext = this.getTestTracingContext(fs, false);
        AbfsRestOperation abfsRestOperation = abfsClient.getPathStatus(testFileName, false, tracingContext);
        this.assertCPKHeaders(abfsRestOperation, false);
        this.assertResponseHeader(abfsRestOperation, isWithCPK, "x-ms-encryption-key-sha256", this.getCPKSha(fs));
        this.assertResponseHeader(abfsRestOperation, true, "x-ms-server-encrypted", "true");
        this.assertResponseHeader(abfsRestOperation, false, "x-ms-request-server-encrypted", "");
        abfsRestOperation = abfsClient.getPathStatus(testFileName, true, tracingContext);
        this.assertCPKHeaders(abfsRestOperation, isWithCPK);
        this.assertResponseHeader(abfsRestOperation, isWithCPK, "x-ms-encryption-key-sha256", this.getCPKSha(fs));
        this.assertResponseHeader(abfsRestOperation, true, "x-ms-server-encrypted", "true");
        this.assertResponseHeader(abfsRestOperation, false, "x-ms-request-server-encrypted", "");
    }

    @Test
    public void testDeletePathWithCPK() throws Exception {
        this.testDeletePath(false);
    }

    @Test
    public void testDeletePathWithoutCPK() throws Exception {
        this.testDeletePath(false);
    }

    private void testDeletePath(boolean isWithCPK) throws Exception {
        AzureBlobFileSystem fs = this.getAbfs(isWithCPK);
        String testFileName = "/" + this.methodName.getMethodName();
        this.createFileAndGetContent(fs, testFileName, 0xA00000);
        FileStatus[] listStatuses = fs.listStatus(new Path(testFileName));
        ((AbstractIntegerAssert)Assertions.assertThat((int)listStatuses.length).describedAs("listStatuses should have 1 entry", new Object[0])).isEqualTo(1);
        AbfsClient abfsClient = fs.getAbfsClient();
        AbfsRestOperation abfsRestOperation = abfsClient.deletePath(testFileName, false, null, this.getTestTracingContext(fs, false));
        this.assertCPKHeaders(abfsRestOperation, false);
        this.assertNoCPKResponseHeadersPresent(abfsRestOperation);
        Assertions.assertThatThrownBy(() -> fs.listStatus(new Path(testFileName))).isInstanceOf(FileNotFoundException.class);
    }

    @Test
    public void testSetPermissionWithCPK() throws Exception {
        this.testSetPermission(true);
    }

    @Test
    public void testSetPermissionWithoutCPK() throws Exception {
        this.testSetPermission(false);
    }

    private void testSetPermission(boolean isWithCPK) throws Exception {
        AzureBlobFileSystem fs = this.getAbfs(isWithCPK);
        String testFileName = "/" + this.methodName.getMethodName();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled(this.getTestTracingContext(fs, false)));
        this.createFileAndGetContent(fs, testFileName, 0xA00000);
        AbfsClient abfsClient = fs.getAbfsClient();
        FsPermission permission = new FsPermission(FsAction.EXECUTE, FsAction.EXECUTE, FsAction.EXECUTE);
        AbfsRestOperation abfsRestOperation = abfsClient.setPermission(testFileName, permission.toString(), this.getTestTracingContext(fs, false));
        this.assertCPKHeaders(abfsRestOperation, false);
        this.assertNoCPKResponseHeadersPresent(abfsRestOperation);
    }

    @Test
    public void testSetAclWithCPK() throws Exception {
        this.testSetAcl(true);
    }

    @Test
    public void testSetAclWithoutCPK() throws Exception {
        this.testSetAcl(false);
    }

    private void testSetAcl(boolean isWithCPK) throws Exception {
        AzureBlobFileSystem fs = this.getAbfs(isWithCPK);
        String testFileName = "/" + this.methodName.getMethodName();
        TracingContext tracingContext = this.getTestTracingContext(fs, false);
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled(tracingContext));
        this.createFileAndGetContent(fs, testFileName, 0xA00000);
        AbfsClient abfsClient = fs.getAbfsClient();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)});
        Map aclEntries = AbfsAclHelper.deserializeAclSpec((String)AclEntry.aclSpecToString((List)aclSpec));
        AbfsRestOperation abfsRestOperation = abfsClient.setAcl(testFileName, AbfsAclHelper.serializeAclSpec((Map)aclEntries), tracingContext);
        this.assertCPKHeaders(abfsRestOperation, false);
        this.assertNoCPKResponseHeadersPresent(abfsRestOperation);
    }

    @Test
    public void testGetAclWithCPK() throws Exception {
        this.testGetAcl(true);
    }

    @Test
    public void testGetAclWithoutCPK() throws Exception {
        this.testGetAcl(false);
    }

    private void testGetAcl(boolean isWithCPK) throws Exception {
        AzureBlobFileSystem fs = this.getAbfs(isWithCPK);
        String testFileName = "/" + this.methodName.getMethodName();
        TracingContext tracingContext = this.getTestTracingContext(fs, false);
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled(tracingContext));
        this.createFileAndGetContent(fs, testFileName, 0xA00000);
        AbfsClient abfsClient = fs.getAbfsClient();
        AbfsRestOperation abfsRestOperation = abfsClient.getAclStatus(testFileName, tracingContext);
        this.assertCPKHeaders(abfsRestOperation, false);
        this.assertNoCPKResponseHeadersPresent(abfsRestOperation);
    }

    @Test
    public void testCheckAccessWithCPK() throws Exception {
        this.testCheckAccess(true);
    }

    @Test
    public void testCheckAccessWithoutCPK() throws Exception {
        this.testCheckAccess(false);
    }

    private void testCheckAccess(boolean isWithCPK) throws Exception {
        boolean isHNSEnabled = this.getConfiguration().getBoolean("fs.azure.test.namespace.enabled", false);
        Assume.assumeTrue((String)"fs.azure.test.namespace.enabled is false", (boolean)isHNSEnabled);
        Assume.assumeTrue((String)"AuthType has to be OAuth", (this.getAuthType() == AuthType.OAuth ? 1 : 0) != 0);
        AzureBlobFileSystem fs = this.getAbfs(isWithCPK);
        String testFileName = "/" + this.methodName.getMethodName();
        fs.create(new Path(testFileName));
        AbfsClient abfsClient = fs.getAbfsClient();
        AbfsRestOperation abfsRestOperation = abfsClient.checkAccess(testFileName, "rwx", this.getTestTracingContext(fs, false));
        this.assertCPKHeaders(abfsRestOperation, false);
        this.assertNoCPKResponseHeadersPresent(abfsRestOperation);
    }

    private byte[] createFileAndGetContent(AzureBlobFileSystem fs, String fileName, int fileSize) throws IOException {
        byte[] fileContent = this.getRandomBytesArray(fileSize);
        Path testFilePath = this.createFileWithContent((FileSystem)fs, fileName, fileContent);
        ContractTestUtils.verifyFileContents((FileSystem)fs, (Path)testFilePath, (byte[])fileContent);
        return fileContent;
    }

    private void assertCPKHeaders(AbfsRestOperation abfsRestOperation, boolean isCPKHeaderExpected) {
        this.assertHeader(abfsRestOperation, "x-ms-encryption-key", isCPKHeaderExpected);
        this.assertHeader(abfsRestOperation, "x-ms-encryption-key-sha256", isCPKHeaderExpected);
        this.assertHeader(abfsRestOperation, "x-ms-encryption-algorithm", isCPKHeaderExpected);
    }

    private void assertNoCPKResponseHeadersPresent(AbfsRestOperation abfsRestOperation) {
        this.assertResponseHeader(abfsRestOperation, false, "x-ms-server-encrypted", "");
        this.assertResponseHeader(abfsRestOperation, false, "x-ms-request-server-encrypted", "");
        this.assertResponseHeader(abfsRestOperation, false, "x-ms-encryption-key-sha256", "");
    }

    private void assertResponseHeader(AbfsRestOperation abfsRestOperation, boolean isHeaderExpected, String headerName, String expectedValue) {
        AbfsHttpOperation result = abfsRestOperation.getResult();
        String value = result.getResponseHeader(headerName);
        if (isHeaderExpected) {
            Assertions.assertThat((String)value).isEqualTo((Object)expectedValue);
        } else {
            Assertions.assertThat((String)value).isNull();
        }
    }

    private void assertHeader(AbfsRestOperation abfsRestOperation, String headerName, boolean isCPKHeaderExpected) {
        ITestCustomerProvidedKey.assertTrue((abfsRestOperation != null ? 1 : 0) != 0);
        Optional<AbfsHttpHeader> header = abfsRestOperation.getRequestHeaders().stream().filter(abfsHttpHeader -> abfsHttpHeader.getName().equalsIgnoreCase(headerName)).findFirst();
        String desc = isCPKHeaderExpected ? "CPK header " + headerName + " is expected, but the same is absent." : "CPK header " + headerName + " is not expected, but the same is present.";
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)header.isPresent()).describedAs(desc, new Object[0])).isEqualTo(isCPKHeaderExpected);
    }

    private byte[] getSHA256Hash(String key) throws IOException {
        try {
            MessageDigest digester = MessageDigest.getInstance("SHA-256");
            return digester.digest(key.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    private String getCPKSha(AzureBlobFileSystem abfs) throws IOException {
        Configuration conf = abfs.getConf();
        String accountName = conf.get("fs.azure.abfs.account.name");
        String encryptionKey = conf.get("fs.azure.client-provided-encryption-key." + accountName);
        if (encryptionKey == null || encryptionKey.isEmpty()) {
            return "";
        }
        return this.getBase64EncodedString(this.getSHA256Hash(encryptionKey));
    }

    private String getBase64EncodedString(byte[] bytes) {
        return java.util.Base64.getEncoder().encodeToString(bytes);
    }

    private Path createFileWithContent(FileSystem fs, String fileName, byte[] fileContent) throws IOException {
        Path testFilePath = new Path(fileName);
        try (FSDataOutputStream oStream = fs.create(testFilePath);){
            oStream.write(fileContent);
            oStream.flush();
        }
        return testFilePath;
    }

    private String convertXmsPropertiesToCommaSeparatedString(Hashtable<String, String> properties) throws CharacterCodingException {
        StringBuilder commaSeparatedProperties = new StringBuilder();
        CharsetEncoder encoder = Charset.forName(XMS_PROPERTIES_ENCODING).newEncoder();
        for (Map.Entry<String, String> propertyEntry : properties.entrySet()) {
            String key = propertyEntry.getKey();
            String value = propertyEntry.getValue();
            Boolean canEncodeValue = encoder.canEncode(value);
            if (!canEncodeValue.booleanValue()) {
                throw new CharacterCodingException();
            }
            String encodedPropertyValue = Base64.encode((byte[])encoder.encode(CharBuffer.wrap(value)).array());
            commaSeparatedProperties.append(key).append("=").append(encodedPropertyValue);
            commaSeparatedProperties.append(",");
        }
        if (commaSeparatedProperties.length() != 0) {
            commaSeparatedProperties.deleteCharAt(commaSeparatedProperties.length() - 1);
        }
        return commaSeparatedProperties.toString();
    }

    private String getOctalNotation(FsPermission fsPermission) {
        Preconditions.checkNotNull((Object)fsPermission, (Object)"fsPermission");
        return String.format("%04d", fsPermission.toOctal());
    }

    private byte[] getRandomBytesArray(int length) {
        byte[] b = new byte[length];
        new Random().nextBytes(b);
        return b;
    }

    private AzureBlobFileSystem getAbfs(boolean withCPK) throws IOException {
        return this.getAbfs(withCPK, "12345678901234567890123456789012");
    }

    private AzureBlobFileSystem getAbfs(boolean withCPK, String cpk) throws IOException {
        Configuration conf = this.getRawConfiguration();
        if (withCPK) {
            conf.set("fs.azure.client-provided-encryption-key." + this.getAccountName(), cpk);
        } else {
            conf.unset("fs.azure.client-provided-encryption-key." + this.getAccountName());
        }
        return (AzureBlobFileSystem)FileSystem.newInstance((Configuration)conf);
    }

    private AzureBlobFileSystem getSameFSWithWrongCPK(AzureBlobFileSystem fs) throws IOException {
        AbfsConfiguration abfsConf = fs.getAbfsStore().getAbfsConfiguration();
        Configuration conf = abfsConf.getRawConfiguration();
        String accountName = conf.get("fs.azure.abfs.account.name");
        String cpk = conf.get("fs.azure.client-provided-encryption-key." + accountName);
        if (cpk == null || cpk.isEmpty()) {
            cpk = "01234567890123456789012345678912";
        }
        cpk = "different-" + cpk;
        String differentCpk = cpk.substring(0, 31);
        conf.set("fs.azure.client-provided-encryption-key." + accountName, differentCpk);
        conf.set("fs.defaultFS", "abfs://" + this.getFileSystemName() + "@" + accountName);
        AzureBlobFileSystem sameFSWithDifferentCPK = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)conf);
        return sameFSWithDifferentCPK;
    }
}

