/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.oauth2.RetryTestTokenProvider;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class ITestAbfsRestOperationException
extends AbstractAbfsIntegrationTest {
    private static final String RETRY_TEST_TOKEN_PROVIDER = "org.apache.hadoop.fs.azurebfs.oauth2.RetryTestTokenProvider";

    @Test
    public void testAbfsRestOperationExceptionFormat() throws IOException {
        String[] errorFields;
        String errorMessage;
        AzureBlobFileSystem fs = this.getFileSystem();
        Path nonExistedFilePath1 = new Path("nonExistedPath1");
        Path nonExistedFilePath2 = new Path("nonExistedPath2");
        try {
            FileStatus fileStatus = fs.getFileStatus(nonExistedFilePath1);
        }
        catch (Exception ex) {
            errorMessage = ex.getLocalizedMessage();
            errorFields = errorMessage.split(",");
            Assert.assertEquals((long)4L, (long)errorFields.length);
            Assert.assertEquals((Object)"Operation failed: \"The specified path does not exist.\"", (Object)errorFields[0].trim());
            Assert.assertEquals((Object)"404", (Object)errorFields[1].trim());
            Assert.assertEquals((Object)"HEAD", (Object)errorFields[2].trim());
            Assert.assertTrue((boolean)errorFields[3].trim().startsWith("http"));
        }
        try {
            fs.listFiles(nonExistedFilePath2, false);
        }
        catch (Exception ex) {
            errorMessage = ex.getLocalizedMessage();
            errorFields = errorMessage.split(",");
            Assert.assertEquals((long)6L, (long)errorFields.length);
            Assert.assertEquals((Object)"Operation failed: \"The specified path does not exist.\"", (Object)errorFields[0].trim());
            Assert.assertEquals((Object)"404", (Object)errorFields[1].trim());
            Assert.assertEquals((Object)"GET", (Object)errorFields[2].trim());
            Assert.assertTrue((boolean)errorFields[3].trim().startsWith("http"));
            Assert.assertEquals((Object)"PathNotFound", (Object)errorFields[4].trim());
            Assert.assertTrue((errorFields[5].contains("RequestId") && errorFields[5].contains("Time") ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCustomTokenFetchRetryCount() throws Exception {
        this.testWithDifferentCustomTokenFetchRetry(0);
        this.testWithDifferentCustomTokenFetchRetry(3);
        this.testWithDifferentCustomTokenFetchRetry(5);
    }

    public void testWithDifferentCustomTokenFetchRetry(int numOfRetries) throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Configuration config = new Configuration(this.getRawConfiguration());
        String accountName = config.get("fs.azure.abfs.account.name");
        config.set("fs.azure.account.auth.type." + accountName, "Custom");
        config.set("fs.azure.account.oauth.provider.type." + accountName, RETRY_TEST_TOKEN_PROVIDER);
        config.set("fs.azure.custom.token.fetch.retry.count", Integer.toString(numOfRetries));
        config.set("fs.azure.createRemoteFileSystemDuringInitialization", "false");
        AzureBlobFileSystem fs1 = (AzureBlobFileSystem)FileSystem.newInstance((URI)fs.getUri(), (Configuration)config);
        RetryTestTokenProvider.ResetStatusToFirstTokenFetch();
        LambdaTestUtils.intercept(Exception.class, () -> fs1.getFileStatus(new Path("/")));
        Assert.assertTrue((String)("Number of token fetch retries (" + RetryTestTokenProvider.reTryCount + ") done, does not match with fs.azure.custom.token.fetch.retry.count configured (" + numOfRetries + ")"), (RetryTestTokenProvider.reTryCount == numOfRetries ? 1 : 0) != 0);
    }

    @Test
    public void testAuthFailException() throws Exception {
        Configuration config = new Configuration(this.getRawConfiguration());
        String accountName = config.get("fs.azure.abfs.account.name");
        config.set("fs.azure.account.auth.type." + accountName, "Custom");
        config.set("fs.azure.account.oauth.provider.type." + accountName, RETRY_TEST_TOKEN_PROVIDER);
        config.set("fs.azure.createRemoteFileSystemDuringInitialization", "false");
        AzureBlobFileSystem fs = this.getFileSystem(config);
        try {
            fs.getFileStatus(new Path("/"));
            ITestAbfsRestOperationException.fail((String)"Should fail at auth token fetch call");
        }
        catch (AbfsRestOperationException e) {
            String errorDesc = "Should throw RestOp exception on AAD failure";
            ((AbstractIntegerAssert)Assertions.assertThat((int)e.getStatusCode()).describedAs("Incorrect status code. " + errorDesc, new Object[0])).isEqualTo(-1);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)e.getErrorCode()).describedAs("Incorrect error code. " + errorDesc, new Object[0])).isEqualTo((Object)AzureServiceErrorCode.UNKNOWN);
            ((AbstractStringAssert)Assertions.assertThat((String)e.getErrorMessage()).describedAs("Incorrect error message. " + errorDesc, new Object[0])).contains(new CharSequence[]{"Auth failure: "});
        }
    }
}

