/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsScaleTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStream;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStream;
import org.apache.hadoop.fs.azurebfs.utils.Listener;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderValidator;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ITestAbfsReadWriteAndSeek
extends AbstractAbfsScaleTest {
    private static final Path TEST_PATH = new Path("/testfile");
    private final int size;

    @Parameterized.Parameters(name="Size={0}")
    public static Iterable<Object[]> sizes() {
        return Arrays.asList({16384}, {0x400000}, {0x400000}, {0x6400000});
    }

    public ITestAbfsReadWriteAndSeek(int size) throws Exception {
        this.size = size;
    }

    @Test
    public void testReadAndWriteWithDifferentBufferSizesAndSeek() throws Exception {
        this.testReadWriteAndSeek(this.size);
    }

    private void testReadWriteAndSeek(int bufferSize) throws Exception {
        int result;
        AzureBlobFileSystem fs = this.getFileSystem();
        AbfsConfiguration abfsConfiguration = fs.getAbfsStore().getAbfsConfiguration();
        abfsConfiguration.setWriteBufferSize(bufferSize);
        abfsConfiguration.setReadBufferSize(bufferSize);
        byte[] b = new byte[2 * bufferSize];
        new Random().nextBytes(b);
        try (FSDataOutputStream stream = fs.create(TEST_PATH);){
            stream.write(b);
        }
        byte[] readBuffer = new byte[2 * bufferSize];
        try (FSDataInputStream inputStream = fs.open(TEST_PATH);){
            ((AbfsInputStream)inputStream.getWrappedStream()).registerListener((Listener)new TracingHeaderValidator(abfsConfiguration.getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.READ, true, 0, ((AbfsInputStream)inputStream.getWrappedStream()).getStreamID()));
            inputStream.seek((long)bufferSize);
            result = inputStream.read(readBuffer, bufferSize, bufferSize);
            ITestAbfsReadWriteAndSeek.assertNotEquals((long)-1L, (long)result);
            inputStream.seek(0L);
            byte[] temp = new byte[5];
            int t = inputStream.read(temp, 0, 1);
            inputStream.seek(0L);
            result = inputStream.read(readBuffer, 0, bufferSize);
        }
        ITestAbfsReadWriteAndSeek.assertNotEquals((String)"data read in final read()", (long)-1L, (long)result);
        ITestAbfsReadWriteAndSeek.assertArrayEquals((byte[])readBuffer, (byte[])b);
    }

    @Test
    public void testReadAheadRequestID() throws IOException {
        AzureBlobFileSystem fs = this.getFileSystem();
        AbfsConfiguration abfsConfiguration = fs.getAbfsStore().getAbfsConfiguration();
        int bufferSize = 16384;
        abfsConfiguration.setReadBufferSize(bufferSize);
        byte[] b = new byte[bufferSize * 10];
        new Random().nextBytes(b);
        try (FSDataOutputStream stream = fs.create(TEST_PATH);){
            ((AbfsOutputStream)stream.getWrappedStream()).registerListener((Listener)new TracingHeaderValidator(abfsConfiguration.getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.WRITE, false, 0, ((AbfsOutputStream)stream.getWrappedStream()).getStreamID()));
            stream.write(b);
        }
        byte[] readBuffer = new byte[4 * bufferSize];
        fs.registerListener((Listener)new TracingHeaderValidator(abfsConfiguration.getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.OPEN, false, 0));
        try (FSDataInputStream inputStream = fs.open(TEST_PATH);){
            ((AbfsInputStream)inputStream.getWrappedStream()).registerListener((Listener)new TracingHeaderValidator(abfsConfiguration.getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.READ, false, 0, ((AbfsInputStream)inputStream.getWrappedStream()).getStreamID()));
            int result = inputStream.read(readBuffer, 0, bufferSize * 4);
        }
        fs.registerListener(null);
    }
}

